package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.ejianc.business.bedget.bean.ContrastanalysisEntity;
import com.ejianc.business.bedget.bean.ContrastanalysisdetailEntity;
import com.ejianc.business.bedget.service.IContrastanalysisService;
import com.ejianc.business.change.bean.ChangeContrastanalysistEntity;
import com.ejianc.business.change.service.IChangeContrastanalysistService;
import com.ejianc.business.change.vo.ChangeContrastanalysisdetailVO;
import com.ejianc.business.change.vo.ChangeContrastanalysistVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;


/**
 * 对比分析变更表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changeContrastanalysist")
public class ChangeContrastanalysistController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IChangeContrastanalysistService service;
    @Autowired
    private IContrastanalysisService contrastanalysisService;

    /**
     * 初始化更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetailByContrastanalysistId")
    @ResponseBody
    public CommonResponse<ChangeContrastanalysistVO> queryDetailByContrastanalysistId(@RequestParam(value = "contrastanalysisId") Long contrastanalysisId) {
        ContrastanalysisEntity ContrastanalysisVo = contrastanalysisService.selectById(contrastanalysisId);
        ChangeContrastanalysistVO changeVO = BeanMapper.map(ContrastanalysisVo, ChangeContrastanalysistVO.class);
        Long id = IdWorker.getId();
        changeVO.setContrastanalysisId(contrastanalysisId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        //限额设计指标分析清单
        List<ContrastanalysisdetailEntity> contrastanalysisdetailList = ContrastanalysisVo.getContrastanalysisdetailEntities();
        if(contrastanalysisdetailList!=null&&contrastanalysisdetailList.size()>0){
            List<ChangeContrastanalysisdetailVO> changeContrastanalysisdetailVO = new ArrayList<>();
            for(ContrastanalysisdetailEntity entity : contrastanalysisdetailList){
                ChangeContrastanalysisdetailVO vo = BeanMapper.map(entity, ChangeContrastanalysisdetailVO.class);
                vo.setMid(id);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changeContrastanalysisdetailVO.add(vo);
            }
            changeVO.setContrastanalysisdetailEntities(changeContrastanalysisdetailVO);
        }

        return CommonResponse.success("查询详情成功！", changeVO);

    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeContrastanalysistVO> saveOrUpdate(@RequestBody ChangeContrastanalysistVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeContrastanalysistVO> queryDetail(Long id) {
    	ChangeContrastanalysistEntity entity = service.selectById(id);
        ChangeContrastanalysistVO vo = BeanMapper.map(entity, ChangeContrastanalysistVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeContrastanalysistVO> vos) {
        service.removeByIds(vos.stream().map(ChangeContrastanalysistVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeContrastanalysistVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangeContrastanalysistEntity> page = service.queryPage(param,false);
        IPage<ChangeContrastanalysistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeContrastanalysistVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangeContrastanalysistEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ChangeContrastanalysistEntiy-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refChangeContrastanalysistEntiyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangeContrastanalysistVO>> refChangeContrastanalysistEntiyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangeContrastanalysistEntity> page = service.queryPage(param,false);
        IPage<ChangeContrastanalysistVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeContrastanalysistVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
