package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ContrastanalysisdetailEntity;
import com.ejianc.business.bedget.service.IContrastanalysisdetailService;
import com.ejianc.business.bedget.vo.ContrastanalysisVO;
import com.ejianc.business.bedget.vo.ContrastanalysisdetailVO;
import com.ejianc.business.change.bean.ChangeContrastanalysisdetailEntity;
import com.ejianc.business.change.service.IChangeContrastanalysisdetailService;
import com.ejianc.business.change.vo.ChangeContrastanalysisdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 对比分析清单导入导出
 */
@Controller
@RequestMapping("changeContrastanalysisExport")
public class ExeclChangeContrastanalysisController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContrastanalysisdetailService ContrastanalysisdetailService;
    @Autowired
    private IChangeContrastanalysisdetailService changeContrastanalysisdetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadContrastanalysis")
    @ResponseBody
    public void downloadContrastanalysis(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "contrastanalysisdetail-import.xlsx", "施工图预算清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportContrastanalysis", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportContrastanalysis(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangeContrastanalysisdetailVO> successList = new ArrayList<>();
        List<ChangeContrastanalysisdetailVO> errorList = new ArrayList<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    ChangeContrastanalysisdetailVO changeContrastanalysisdetailVO = new ChangeContrastanalysisdetailVO();
                    changeContrastanalysisdetailVO.setId(IdWorker.getId());//id
                    changeContrastanalysisdetailVO.setSort(datas.get(0)); // 序号
                    changeContrastanalysisdetailVO.setName(StringUtils.isNotBlank(datas.get(1))? datas.get(1):null); // 工程名称或费用名称
                    changeContrastanalysisdetailVO.setBiddingStage(StringUtils.isNotBlank(datas.get(2))?new BigDecimal(datas.get(2)):null); // 投标阶段
                    changeContrastanalysisdetailVO.setTenderListTotal(StringUtils.isNotBlank(datas.get(3))?new BigDecimal(datas.get(3)):null); // 投标清单合价
                    changeContrastanalysisdetailVO.setMemo(StringUtils.isNotBlank(datas.get(4))?datas.get(4):null); // 备注

                    /*if(StringUtils.isEmpty(datas.get(0))) {
                        ContrastanalysisdetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(ContrastanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(1))) {
                        ContrastanalysisdetailVO.setErrorMsg("名称不能为空！");
                        errorList.add(ContrastanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(2))) {
                        ContrastanalysisdetailVO.setErrorMsg("单位不能为空！");
                        errorList.add(ContrastanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(3))) {
                        ContrastanalysisdetailVO.setErrorMsg("投标工程量不能为空！");
                        errorList.add(ContrastanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(4))) {
                        ContrastanalysisdetailVO.setErrorMsg("建筑面积(m²)不能为空！");
                        errorList.add(ContrastanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(5))) {
                        ContrastanalysisdetailVO.setErrorMsg("投标指标不能为空！");
                        errorList.add(ContrastanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(6))) {
                        ContrastanalysisdetailVO.setErrorMsg("(计划成本)限额设计指标不能为空！");
                        errorList.add(ContrastanalysisdetailVO);
                        continue;
                    }*/
                    successList.add(changeContrastanalysisdetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportContrastanalysisFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportContrastanalysisFromDatabase(@RequestBody ChangeContrastanalysisdetailVO changeContrastanalysisdetailVO, HttpServletResponse response) {
        QueryWrapper<ChangeContrastanalysisdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", changeContrastanalysisdetailVO.getMid());
        queryWrapper.eq("dr", 0);
        List<ChangeContrastanalysisdetailEntity> list = changeContrastanalysisdetailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("contrastanalysisdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportContrastanalysisFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportContrastanalysisFromPage(@RequestBody List<ChangeContrastanalysisdetailVO> list, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("contrastanalysisdetail-export.xlsx", beans, response);
    }

}
