package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.SubpackagedetailEntity;
import com.ejianc.business.change.bean.ChangesubpackagedetailEntity;
import com.ejianc.business.change.service.IChangesubpackagedetailService;
import com.ejianc.business.change.vo.ChangesubpackageVO;
import com.ejianc.business.change.vo.ChangesubpackagedetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 施工图预算清单导入导出变更
 */
@Controller
@RequestMapping("changeSubpackageExport")
public class ExeclChangeSubpackageController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IChangesubpackagedetailService changesubpackagedetailService;


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadSubpackage")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "subpackagedetail-import.xlsx", "施工图预算清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportSubpackage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangesubpackagedetailVO> successList = new ArrayList<>();
        List<ChangesubpackagedetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 2; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ChangesubpackagedetailVO changesubpackagedetailVO = new ChangesubpackagedetailVO();
                    changesubpackagedetailVO.setId(IdWorker.getId());//id
                    changesubpackagedetailVO.setSort(datas.get(0)); // 序号
                    changesubpackagedetailVO.setSection(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 区段
                    changesubpackagedetailVO.setSubtitleCode(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 子目编码
                    changesubpackagedetailVO.setSubtitleName(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 子目名称
                    changesubpackagedetailVO.setSubtitleFeature(StringUtils.isNotBlank(datas.get(4)) ? datas.get(4) : null); // 子目特征描述
                    changesubpackagedetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(5)) ? datas.get(5) : null); // 计量单位
                    changesubpackagedetailVO.setQuantities(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : null); // 工程量
                    changesubpackagedetailVO.setArtificialUnitPrice(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); // 人工费(单价)
                    changesubpackagedetailVO.setMaterialsUnitPrice(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 材料费(单价)
                    changesubpackagedetailVO.setMechanicalUnitPrice(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 机械费(单价)
                    changesubpackagedetailVO.setEnterpriseManageUnitPrice(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null); // 企业管理费(单价)
                    changesubpackagedetailVO.setProfitsUnitPrice(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); // 利润(单价)
                    changesubpackagedetailVO.setFeesUnitPrice(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null); //  规费
                    changesubpackagedetailVO.setTaxUnitPrice(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) : null); //  税金
                    changesubpackagedetailVO.setComprehensiveUnitPrice(StringUtils.isNotBlank(datas.get(14)) ? new BigDecimal(datas.get(14)) : null); // 综合单价
                    changesubpackagedetailVO.setArtificialTotal(StringUtils.isNotBlank(datas.get(15)) ? new BigDecimal(datas.get(15)) : null); // 人工费(综合)
                    changesubpackagedetailVO.setMaterialsTotal(StringUtils.isNotBlank(datas.get(16)) ? new BigDecimal(datas.get(16)) : null); // 材料费(综合)
                    changesubpackagedetailVO.setMechanicalTotal(StringUtils.isNotBlank(datas.get(17)) ? new BigDecimal(datas.get(17)) : null); // 机械费(综合)
                    changesubpackagedetailVO.setEnterpriseManageTotal(StringUtils.isNotBlank(datas.get(18)) ? new BigDecimal(datas.get(18)) : null); // 企业管理费
                    changesubpackagedetailVO.setProfitsTotal(StringUtils.isNotBlank(datas.get(19)) ? new BigDecimal(datas.get(19)) : null); // 利润
                    changesubpackagedetailVO.setFeesTotal(StringUtils.isNotBlank(datas.get(20)) ? new BigDecimal(datas.get(20)) : null); //  规费
                    changesubpackagedetailVO.setTaxTotal(StringUtils.isNotBlank(datas.get(21)) ? new BigDecimal(datas.get(21)) : null); //  税金
                    changesubpackagedetailVO.setComprehensiveTotal(StringUtils.isNotBlank(datas.get(22)) ? new BigDecimal(datas.get(22)) : null); // 合价
                    changesubpackagedetailVO.setSubpackageBudgetTotal(StringUtils.isNotBlank(datas.get(23)) ? new BigDecimal(datas.get(23)) : null); // 分包施工图预算量合计
                    changesubpackagedetailVO.setSubpackageQuantities(StringUtils.isNotBlank(datas.get(24)) ? new BigDecimal(datas.get(24)) : null); // 工程量
                    changesubpackagedetailVO.setSubpackageMeasuringUnit(StringUtils.isNotBlank(datas.get(25)) ? datas.get(25) : null); //计量单位
                    changesubpackagedetailVO.setExcludingTaxUnitPrice(StringUtils.isNotBlank(datas.get(26)) ? new BigDecimal(datas.get(26)) : null); //除税单价
                    changesubpackagedetailVO.setExcludingTaxTotal(StringUtils.isNotBlank(datas.get(27)) ? new BigDecimal(datas.get(27)) : null); // 除税合价
                    changesubpackagedetailVO.setIncludingTaxTotal(StringUtils.isNotBlank(datas.get(28)) ? new BigDecimal(datas.get(28)) : null); // 含税合价
                    successList.add(changesubpackagedetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubpackageFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody ChangesubpackageVO changesubpackageVO, HttpServletResponse response) {
        QueryWrapper<ChangesubpackagedetailEntity> queryWrapper;
        queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", changesubpackageVO.getId());
        queryWrapper.eq("dr", 0);
        List<ChangesubpackagedetailEntity> list = changesubpackagedetailService.list(queryWrapper);
        List<ChangesubpackagedetailVO> changesubpackagedetailVOList = BeanMapper.mapList(list, ChangesubpackagedetailVO.class);
        if (changesubpackagedetailVOList != null && changesubpackagedetailVOList.size() > 0) {
            for (int i = 0; i < changesubpackagedetailVOList.size(); i++) {
                ChangesubpackagedetailVO changesubpackagedetailVO = changesubpackagedetailVOList.get(i);
                changesubpackagedetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subpackagedetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubpackageFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<ChangesubpackagedetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                ChangesubpackagedetailVO changesubpackagedetailVO = list.get(i);
                changesubpackagedetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subpackagedetail-export.xlsx", beans, response);
    }

}
