package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ContrastanalysisEntity;
import com.ejianc.business.bedget.bean.ContrastanalysisdetailEntity;
import com.ejianc.business.bedget.bean.QuotaanalysisEntity;
import com.ejianc.business.bedget.bean.QuotaanalysisdetailEntity;
import com.ejianc.business.bedget.service.IContrastanalysisService;
import com.ejianc.business.change.bean.ChangeContrastanalysisdetailEntity;
import com.ejianc.business.change.bean.ChangeContrastanalysistEntity;
import com.ejianc.business.change.bean.ChangeQuotaanalysisEntity;
import com.ejianc.business.change.bean.ChangeQuotaanalysisdetailEntity;
import com.ejianc.business.change.service.IChangeContrastanalysistService;
import com.ejianc.business.record.bean.RecordContrastanalysisdetailEntity;
import com.ejianc.business.record.bean.RecordContrastanalysistEntity;
import com.ejianc.business.record.bean.RecordQuotaanalysisEntity;
import com.ejianc.business.record.bean.RecordQuotaanalysisdetailEntity;
import com.ejianc.business.record.service.IRecordContrastanalysistService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changeContrastanalysistEntiy")
public class ChangeContrastanalysistBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Contrastanalysist = "zjkj-contrastanalysist";//对比分析
	private static final String Contrastanalysist_CHANGE = "zjkj-contrastanalysistChange";//对比分析变更
	private static final String Contrastanalysist_RECORD = "zjkj-contrastanalysistRecord";//对比分析变更记录

	//单据类型
	private static final String Contrastanalysist_BILLTYPE_CODE = "BT202203000001";//对比分析
	private static final String Contrastanalysist_CHANGE_BILLTYPE_CODE = "BT202203000002";//对比分析变更
	private static final String Contrastanalysist_RECORD_BILLTYPE_CODE = "BT202203000003";//对比分析变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangeContrastanalysistService changeContrastanalysistService;
	@Autowired
	private IContrastanalysisService contrastanalysisService;
	@Autowired
	private IRecordContrastanalysistService recordContrastanalysistService;


	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("---------进来啦--------");
		//TODO
		//1、获取目前单据信息、变更信息
		ChangeContrastanalysistEntity changeEntity = changeContrastanalysistService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getContrastanalysisId());
		ContrastanalysisEntity contrastanalysisEntity = contrastanalysisService.selectById(changeEntity.getContrastanalysisId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordContrastanalysistEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("contrastanalysis_id", contrastanalysisEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordContrastanalysistService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordContrastanalysistEntity recordContrastanalysistEntity = BeanMapper.map(contrastanalysisEntity, RecordContrastanalysistEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordContrastanalysistEntity);
		recordContrastanalysistEntity.setBillState(null);
		recordContrastanalysistEntity.setContrastanalysisId(contrastanalysisEntity.getId());
		recordContrastanalysistEntity.setContrastanalysisCode(contrastanalysisEntity.getBillCode()+"-"+(count+1));
		recordContrastanalysistEntity.setId(recordId);
		recordContrastanalysistEntity.setBillCode(contrastanalysisEntity.getBillCode());
		recordContrastanalysistEntity.setChangeReason(changeEntity.getChangeReason());
		recordContrastanalysistEntity.setEffectTime(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<ContrastanalysisdetailEntity> contrastanalysisdetailEntity = contrastanalysisEntity.getContrastanalysisdetailEntities();
		if(contrastanalysisdetailEntity!=null&&contrastanalysisdetailEntity.size()>0){
			List<RecordContrastanalysisdetailEntity> recordContrastanalysisdetailEntity = new ArrayList<>();
			for(ContrastanalysisdetailEntity entity : contrastanalysisdetailEntity){
				RecordContrastanalysisdetailEntity reEntity = BeanMapper.map(entity, RecordContrastanalysisdetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setMid(recordId);
				recordContrastanalysisdetailEntity.add(reEntity);
				entity.setRowState("del");
			}
			recordContrastanalysistEntity.setContrastanalysisdetailEntities(recordContrastanalysisdetailEntity);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Contrastanalysist_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Contrastanalysist_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(contrastanalysisEntity.getId().toString(), sourceBillType, Contrastanalysist , recordId.toString(), targetBillType, Contrastanalysist_RECORD);
		recordContrastanalysistService.saveOrUpdate(recordContrastanalysistEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + contrastanalysisEntity.getCreateUserCode());
		//3、修改当前单据状态
		ContrastanalysisEntity newContrastanalysisEntity = BeanMapper.map(changeEntity, ContrastanalysisEntity.class);
		newContrastanalysisEntity.setChangeState("3");//状态改为已变更
		newContrastanalysisEntity.setChangeId(null);
		newContrastanalysisEntity.setBillState(contrastanalysisEntity.getBillState());
		newContrastanalysisEntity.setId(contrastanalysisEntity.getId());
		newContrastanalysisEntity.setCreateTime(contrastanalysisEntity.getCreateTime());
		newContrastanalysisEntity.setCreateUserCode(contrastanalysisEntity.getCreateUserCode());
		newContrastanalysisEntity.setTenantId(contrastanalysisEntity.getTenantId());
		newContrastanalysisEntity.setVersion(contrastanalysisEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangeContrastanalysisdetailEntity> changeContrastanalysisdetailEntity = changeEntity.getContrastanalysisdetailEntities();
		if(changeContrastanalysisdetailEntity!=null&&changeContrastanalysisdetailEntity.size()>0){
			List<ContrastanalysisdetailEntity> newQuotaanalysisdetailList = BeanMapper.mapList(changeContrastanalysisdetailEntity, ContrastanalysisdetailEntity.class);
			newQuotaanalysisdetailList.addAll(contrastanalysisdetailEntity);
			newContrastanalysisEntity.setContrastanalysisdetailEntities(newQuotaanalysisdetailList);
		}
		logger.info("---------保存--------");
		contrastanalysisService.saveOrUpdate(newContrastanalysisEntity, false);

		sourceBillType = Contrastanalysist_CHANGE_BILLTYPE_CODE;
		targetBillType = Contrastanalysist_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Contrastanalysist_CHANGE, contrastanalysisEntity.getId().toString(), targetBillType, Contrastanalysist);
		recordContrastanalysistService.saveOrUpdate(recordContrastanalysistEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
