package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.DesignestimateEntity;
import com.ejianc.business.bedget.service.IDesignestimateService;
import com.ejianc.business.change.bean.ChangedesignestimateEntity;
import com.ejianc.business.change.mapper.ChangedesignestimateMapper;
import com.ejianc.business.change.service.IChangedesignestimateService;
import com.ejianc.business.change.vo.ChangedesignestimateVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;


/**
 * 设计概算变更
 * 
 * @author generator
 * 
 */
@Service("changedesignestimateService")
public class ChangedesignestimateServiceImpl extends BaseServiceImpl<ChangedesignestimateMapper, ChangedesignestimateEntity> implements IChangedesignestimateService {
    @Autowired
    private IDesignestimateService designestimateService;
    @Override
    public CommonResponse<ChangedesignestimateVO> saveChange(ChangedesignestimateVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangedesignestimateEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangedesignestimateEntity entity = BeanMapper.map(saveOrUpdateVO, ChangedesignestimateEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangedesignestimateEntity> queryWrapper = new QueryWrapper<ChangedesignestimateEntity>();
        queryWrapper.eq("designestimate_id", saveOrUpdateVO.getDesignestimateId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangedesignestimateEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //设计概算指标分析子表
        this.saveOrUpdate(entity, false);

        ChangedesignestimateVO vo = BeanMapper.map(entity, ChangedesignestimateVO.class);
        vo.setDesignestimatedetailEntities(saveOrUpdateVO.getDesignestimatedetailEntities());
        vo.setRecorddesignestimateList(saveOrUpdateVO.getRecorddesignestimateList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            DesignestimateEntity designestimateEntity = designestimateService.selectById(vo.getDesignestimateId());
            designestimateEntity.setChangeState("2");//状态改为变更中
            designestimateEntity.setChangeId(vo.getId());
            designestimateService.saveOrUpdate(designestimateEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
}
