package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotalEntity;
import com.ejianc.business.bedget.bean.MaterialanalysisEntity;
import com.ejianc.business.bedget.service.IMaterialanalysisService;
import com.ejianc.business.change.bean.ChangeconsdrawbudgettotalEntity;
import com.ejianc.business.change.bean.ChangematerialanalysisEntity;
import com.ejianc.business.change.mapper.ChangematerialanalysisMapper;
import com.ejianc.business.change.service.IChangematerialanalysisService;
import com.ejianc.business.change.vo.ChangeconsdrawbudgettotalVO;
import com.ejianc.business.change.vo.ChangematerialanalysisVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;


/**
 * 施工图预算材料分析变更
 * 
 * @author generator
 * 
 */
@Service("changematerialanalysisService")
public class ChangematerialanalysisServiceImpl extends BaseServiceImpl<ChangematerialanalysisMapper, ChangematerialanalysisEntity> implements IChangematerialanalysisService {

    @Autowired
    private IMaterialanalysisService materialanalysisService;

    @Override
    public CommonResponse<ChangematerialanalysisVO> saveChange(ChangematerialanalysisVO saveOrUpdateVO) {



        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangematerialanalysisEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangematerialanalysisEntity entity = BeanMapper.map(saveOrUpdateVO, ChangematerialanalysisEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangematerialanalysisEntity> queryWrapper = new QueryWrapper<ChangematerialanalysisEntity>();
        queryWrapper.eq("original_id", saveOrUpdateVO.getOriginalId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangematerialanalysisEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //设计概算指标分析子表
        this.saveOrUpdate(entity, false);

        ChangematerialanalysisVO vo = BeanMapper.map(entity, ChangematerialanalysisVO.class);
        vo.setMaterialanalysisdetailEntities(saveOrUpdateVO.getMaterialanalysisdetailEntities());
        vo.setRecordmaterialanalysisVOS(saveOrUpdateVO.getRecordmaterialanalysisVOS());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            MaterialanalysisEntity materialanalysisEntity = materialanalysisService.selectById(vo.getOriginalId());
            materialanalysisEntity.setChangeState("2");//状态改为变更中
            materialanalysisEntity.setChangeId(vo.getId());
            materialanalysisService.saveOrUpdate(materialanalysisEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);

    }
}
