package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotadesigndetailEntity;
import com.ejianc.business.bedget.bean.QuotadesignEntity;
import com.ejianc.business.bedget.service.IQuotadesignService;
import com.ejianc.business.change.bean.ChangequotadesignEntity;
import com.ejianc.business.change.bean.ChangequotadesigndetailEntity;
import com.ejianc.business.change.service.IChangequotadesignService;
import com.ejianc.business.record.bean.RecordquotadesignEntity;
import com.ejianc.business.record.bean.RecordquotadesigndetaillEntity;
import com.ejianc.business.record.service.IRecordquotadesignService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changequotadesign") 
public class ChangequotadesignBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Quotadesign = "zjkj-quotadesign";//限额设计分析
	private static final String Quotadesign_CHANGE = "zjkj-quotadesignChange";//限额设计分析变更
	private static final String Quotadesign_RECORD = "zjkj-quotadesignRecord";//限额设计分析变更记录

	//单据类型
	private static final String Quotadesign_BILLTYPE_CODE = "BT202202000021";//限额设计分析
	private static final String Quotadesign_CHANGE_BILLTYPE_CODE = "BT202202000022";//限额设计分析变更
	private static final String Quotadesign_RECORD_BILLTYPE_CODE = "BT202202000023";//限额设计分析变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangequotadesignService changequotadesignService;
	@Autowired
	private IQuotadesignService quotadesignService;
	@Autowired
	private IRecordquotadesignService recordquotadesignService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前单据信息、变更信息
		ChangequotadesignEntity changeEntity = changequotadesignService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getOriginalId());
		QuotadesignEntity quotadesignEntity = quotadesignService.selectById(changeEntity.getOriginalId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordquotadesignEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("original_id", quotadesignEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordquotadesignService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordquotadesignEntity recordQuotadesignEntity = BeanMapper.map(quotadesignEntity, RecordquotadesignEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordQuotadesignEntity);
		recordQuotadesignEntity.setBillState(null);
		recordQuotadesignEntity.setOriginalId(quotadesignEntity.getId());
		recordQuotadesignEntity.setQuotadesignCode(quotadesignEntity.getBillCode()+"-"+(count+1));
		recordQuotadesignEntity.setId(recordId);
		recordQuotadesignEntity.setBillCode(quotadesignEntity.getBillCode());
		recordQuotadesignEntity.setChangeReason(changeEntity.getChangeReason());
		recordQuotadesignEntity.setEffectDate(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<QuotadesigndetailEntity> quotadesigndetailEntities = quotadesignEntity.getQuotadesigndetailEntities();
		if(quotadesigndetailEntities!=null&&quotadesigndetailEntities.size()>0){
			List<RecordquotadesigndetaillEntity> recordquotadesigndetaillEntity = new ArrayList<>();
			for(QuotadesigndetailEntity entity : quotadesigndetailEntities){
				RecordquotadesigndetaillEntity reEntity = BeanMapper.map(entity, RecordquotadesigndetaillEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setId(IdWorker.getId());
				reEntity.setOriginalId(entity.getId());
				recordquotadesigndetaillEntity.add(reEntity);
			}
			recordQuotadesignEntity.setQuotadesigndetailEntities(recordquotadesigndetaillEntity);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Quotadesign_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Quotadesign_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(quotadesignEntity.getId().toString(), sourceBillType, Quotadesign , recordId.toString(), targetBillType, Quotadesign_RECORD);
		recordquotadesignService.saveOrUpdate(recordQuotadesignEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + quotadesignEntity.getCreateUserCode());
		//3、修改当前单据状态
		QuotadesignEntity newQuotadesignEntity = BeanMapper.map(changeEntity, QuotadesignEntity.class);
		newQuotadesignEntity.setChangeState("3");//状态改为已变更
		newQuotadesignEntity.setChangeId(null);
		newQuotadesignEntity.setBillState(quotadesignEntity.getBillState());
		newQuotadesignEntity.setId(quotadesignEntity.getId());
		newQuotadesignEntity.setCreateTime(quotadesignEntity.getCreateTime());
		newQuotadesignEntity.setCreateUserCode(quotadesignEntity.getCreateUserCode());
		newQuotadesignEntity.setTenantId(quotadesignEntity.getTenantId());
		newQuotadesignEntity.setVersion(quotadesignEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangequotadesigndetailEntity> changequotadesigndetailList = changeEntity.getQuotadesigndetailEntities();
		if(changequotadesigndetailList!=null&&changequotadesigndetailList.size()>0){
			List<QuotadesigndetailEntity> newQuotadesigndetailList = BeanMapper.mapList(changequotadesigndetailList, QuotadesigndetailEntity.class);
			//原单据子表的基础信息不变
			if(quotadesigndetailEntities != null && quotadesigndetailEntities.size() > 0){
				QuotadesigndetailEntity originalQuotadesigndetailInfo = quotadesigndetailEntities.get(0);

				for (int i = 0; i < changequotadesigndetailList.size(); i++) {
					ChangequotadesigndetailEntity changeQuotadesigndetail = changequotadesigndetailList.get(i);
					QuotadesigndetailEntity newQuotadesigndetail = newQuotadesigndetailList.get(i);

					boolean isChangeUpdate = false;//true 变更更新数据 false 变更新增数据
					for (int j = 0; j < quotadesigndetailEntities.size(); j++) {
						QuotadesigndetailEntity originalQuotadesigndetail = quotadesigndetailEntities.get(j);
						if(originalQuotadesigndetail.getId().equals(changeQuotadesigndetail.getOriginalId())){

							newQuotadesigndetail.setId(originalQuotadesigndetail.getId());
							newQuotadesigndetail.setCreateTime(originalQuotadesigndetailInfo.getCreateTime());
							newQuotadesigndetail.setCreateUserCode(originalQuotadesigndetailInfo.getCreateUserCode());

							newQuotadesigndetail.setUpdateTime(changeQuotadesigndetail.getUpdateTime());
							newQuotadesigndetail.setUpdateUserCode(changeQuotadesigndetail.getCreateUserCode());

							isChangeUpdate = true;
							break;
						}
					}

					if(!isChangeUpdate){//变更新增
						newQuotadesigndetail.setCreateTime(changeQuotadesigndetail.getUpdateTime());
						newQuotadesigndetail.setCreateUserCode(changeQuotadesigndetail.getCreateUserCode());
					}

					newQuotadesigndetail.setBillState(originalQuotadesigndetailInfo.getBillState());
					newQuotadesigndetail.setTenantId(originalQuotadesigndetailInfo.getTenantId());
					newQuotadesigndetail.setVersion(originalQuotadesigndetailInfo.getVersion());
				}
			}
			//原始单与变更单对比后（新增）
			newQuotadesignEntity.setQuotadesigndetailEntities(newQuotadesigndetailList);

			//原始单与变更单对比后（删除）
			List<QuotadesigndetailEntity> deleteDatas = new ArrayList<>();
			for (int i = 0; i < quotadesigndetailEntities.size(); i++) {
				QuotadesigndetailEntity quotadesigndetail = quotadesigndetailEntities.get(i);
				boolean isSame = false;
				for (int j = 0; j < newQuotadesigndetailList.size(); j++) {
					QuotadesigndetailEntity newDetail = newQuotadesigndetailList.get(j);
					if(quotadesigndetail.getId().equals(newDetail.getId())) {
						isSame = true;
					}
				}
				if(!isSame){//变更已删除行
					quotadesigndetail.setRowState("del");
					deleteDatas.add(quotadesigndetail);
				}
			}

			if(deleteDatas.size() > 0){
				newQuotadesigndetailList.addAll(deleteDatas);
				newQuotadesignEntity.setQuotadesigndetailEntities(newQuotadesigndetailList);
			}
			newQuotadesignEntity.setQuotadesigndetailEntities(newQuotadesigndetailList);
		}
		logger.info("---------保存--------");
		quotadesignService.saveOrUpdate(newQuotadesignEntity, false);

		sourceBillType = Quotadesign_CHANGE_BILLTYPE_CODE;
		targetBillType = Quotadesign_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Quotadesign_CHANGE, quotadesignEntity.getId().toString(), targetBillType, Quotadesign);
		recordquotadesignService.saveOrUpdate(recordQuotadesignEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
