package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.*;
import com.ejianc.business.bedget.service.IDesignestimateService;
import com.ejianc.business.bedget.service.IDesignestimatedetailService;
import com.ejianc.business.bedget.vo.EstimatesummarydetailVO;
import com.ejianc.business.record.bean.RecordestimatesummaryEntity;
import com.ejianc.business.record.service.IRecordestimatesummaryService;
import com.ejianc.business.record.vo.RecordestimatesummaryVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.service.IEstimatesummaryService;
import com.ejianc.business.bedget.vo.EstimatesummaryVO;

/**
 * 设计概算汇总表
 *
 * @author generator
 */
@Controller
@RequestMapping("estimatesummary")
public class EstimatesummaryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanage-budgetestimatesummary";//此处需要根据实际修改

    @Autowired
    private IEstimatesummaryService service;
    @Autowired
    private IDesignestimateService designestimateService;
    @Autowired
    private IDesignestimatedetailService designestimatedetailService;


    @Autowired
    private IRecordestimatesummaryService recordestimatesummaryService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EstimatesummaryVO> saveOrUpdate(@RequestBody EstimatesummaryVO saveorUpdateVO) {
        EstimatesummaryEntity entity = BeanMapper.map(saveorUpdateVO, EstimatesummaryEntity.class);
        //项目唯一性
        QueryWrapper<EstimatesummaryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        if(saveorUpdateVO.getId() != null && saveorUpdateVO.getId() != 0){
            queryWrapper.ne("id", saveorUpdateVO.getId());
        }
        List<EstimatesummaryEntity> pro = service.list(queryWrapper);
        if (pro.size() > 0) {
            throw new BusinessException("该项目已经创建一个设计概算汇总，不允许重复创建!");
        }

        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        EstimatesummaryVO vo = BeanMapper.map(entity, EstimatesummaryVO.class);

        List<EstimatesummarydetailVO> estimatesummarydetailVOList = vo.getEstimatesummarydetailEntities();
        vo.setEstimatesummarydetailEntities(handleChildren(estimatesummarydetailVOList));
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EstimatesummaryVO> queryDetail(Long id) {
        EstimatesummaryEntity entity = service.selectById(id);
        EstimatesummaryVO vo = BeanMapper.map(entity, EstimatesummaryVO.class);

        //构建树
        List<EstimatesummarydetailVO> estimatesummarydetailVOList = vo.getEstimatesummarydetailEntities();
        vo.setEstimatesummarydetailEntities(handleChildren(estimatesummarydetailVOList));

        //当前单据变更过则显示变更记录
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper<RecordestimatesummaryEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("budgetestimatesummary_id", vo.getId());
            List<RecordestimatesummaryEntity> records = recordestimatesummaryService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordestimatesummaryVOList(BeanMapper.mapList(records, RecordestimatesummaryVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EstimatesummaryVO> vos) {
        service.removeByIds(vos.stream().map(EstimatesummaryVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EstimatesummaryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<EstimatesummaryEntity> page = service.queryPage(param, false);
        IPage<EstimatesummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EstimatesummaryVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<EstimatesummaryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<EstimatesummaryVO> estimatesummaryVOList = BeanMapper.mapList(list, EstimatesummaryVO.class);
        for (int i = 0; i < estimatesummaryVOList.size(); i++) {
            EstimatesummaryVO estimatesummaryVO = estimatesummaryVOList.get(i);
            estimatesummaryVO.setSort(String.valueOf(i + 1));
            if (estimatesummaryVO.getCreateTime() != null) {
                estimatesummaryVO.setCreateTimeShow(DateUtils.dateSimple2(estimatesummaryVO.getCreateTime()));
            }
            String billStateStr = estimatesummaryVO.getBillState().toString();
            String changeState = estimatesummaryVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                estimatesummaryVO.setBillStateStr(billStateStr);
            }

            if (changeState != null) {
                if ("1".equals(changeState)) {//1:未变更
                    changeState = "未变更";
                } else if ("2".equals(changeState)) {//2:变更中
                    changeState = "变更中";
                } else if ("3".equals(changeState)) {//3:已变更
                    changeState = "已变更";
                }

                estimatesummaryVO.setChangeState(changeState);
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", estimatesummaryVOList);
        ExcelExport.getInstance().export("Estimatesummary-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refEstimatesummaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EstimatesummaryVO>> refEstimatesummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<EstimatesummaryEntity> page = service.queryPage(param, false);
        IPage<EstimatesummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), EstimatesummaryVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param projectId 项目id
     * @param id 单据id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<EstimatesummarydetailVO>> queryDetailList(Long id, Long projectId) {
        List<EstimatesummarydetailVO> voList = new ArrayList<>();

        //校验项目唯一性
        QueryWrapper<DesignestimateEntity> queryWrapperProject = new QueryWrapper<>();
        queryWrapperProject.eq("project_id", projectId);
        queryWrapperProject.eq("dr", 0);
        if(id != null && id != 0){
            queryWrapperProject.ne("id", id);
        }
        List<DesignestimateEntity> entityList = designestimateService.list(queryWrapperProject);
        if(entityList != null && entityList.size() > 0){
            throw new BusinessException("该项目已经创建一个设计概算汇总，不允许重复创建");
        }


        //根据项目id查询设计概算表数据
        QueryWrapper<DesignestimateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 1, 3);//审批通过的
        DesignestimateEntity entity = designestimateService.getOne(queryWrapper);
        if (entity == null) {
            throw new BusinessException("您选择的项目没有设计概算,请选择别的项目");
        }

        QueryWrapper<DesignestimatedetailEntity> queryDetailWrapper = new QueryWrapper<>();
        queryDetailWrapper.eq("mid", entity.getId());
        List<DesignestimatedetailEntity> estimatesummarydetailList = designestimatedetailService.list(queryDetailWrapper);
        for (DesignestimatedetailEntity item :
                estimatesummarydetailList) {
            EstimatesummarydetailVO estimatesummarydetailVO = new EstimatesummarydetailVO();
            estimatesummarydetailVO.setId(item.getId());
            estimatesummarydetailVO.setMid(item.getMid());
            estimatesummarydetailVO.setInventoryCode(item.getSonItemCode());
            estimatesummarydetailVO.setEngineeringName(item.getSonItemName());
            estimatesummarydetailVO.setTid(item.getTid());
            estimatesummarydetailVO.setTpid(item.getTpid());
            voList.add(estimatesummarydetailVO);
        }
        return CommonResponse.success(handleChildren(voList));
    }

    /**
     * 对子表做排序、构建树等处理
     *
     * @param voList
     */
    private List<EstimatesummarydetailVO> handleChildren(List<EstimatesummarydetailVO> voList) {
        //按子目编码排序
        Collections.sort(voList, new Comparator<EstimatesummarydetailVO>() {
            @Override
            public int compare(EstimatesummarydetailVO o1, EstimatesummarydetailVO o2) {
                return o1.getInventoryCode().compareTo(o2.getInventoryCode());
            }
        });

        //构建树
        voList = createTreeData(voList);

        return voList;
    }

    public static List<EstimatesummarydetailVO> createTreeData(List<EstimatesummarydetailVO> list) {
        List<EstimatesummarydetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, EstimatesummarydetailVO> listMap = new HashMap<>();
        for (EstimatesummarydetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            EstimatesummarydetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            EstimatesummarydetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<EstimatesummarydetailVO> child = (List<EstimatesummarydetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<EstimatesummarydetailVO> children = new ArrayList<>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
