package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.record.bean.RecodematerialrequirementsEntity;
import com.ejianc.business.record.service.IRecodematerialrequirementsService;
import com.ejianc.business.record.vo.RecodematerialrequirementsVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.bean.MaterialrequirementsEntity;
import com.ejianc.business.bedget.service.IMaterialrequirementsService;
import com.ejianc.business.bedget.vo.MaterialrequirementsVO;

/**
 * 物资需求总计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialrequirements")
public class MaterialrequirementsController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanager-materialrequirements";//此处需要根据实际修改

    @Autowired
    private IMaterialrequirementsService service;
    @Autowired
    private IRecodematerialrequirementsService recodematerialrequirementsService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialrequirementsVO> saveOrUpdate(@RequestBody MaterialrequirementsVO saveorUpdateVO) {
    	MaterialrequirementsEntity entity = BeanMapper.map(saveorUpdateVO, MaterialrequirementsEntity.class);
        QueryWrapper<MaterialrequirementsEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        List<MaterialrequirementsEntity> pro = service.list(queryWrapper);

        if(entity.getId() == null || entity.getId() == 0){//新增
            if(pro.size() > 0){
                throw new BusinessException("该项目已经创建一个物资需求总计划，不允许重复创建!");
            }
        }else {//更新
            if(pro.size() > 0){
                for (int i = 0; i < pro.size(); i++) {
                    if(!entity.getId().equals(pro.get(i).getId())){
                        throw new BusinessException("该单据已存在，不允许重复创建!");
                    }
                }
            }
        }
    	checkBillCodeUniq(entity);
    	service.saveOrUpdate(entity, false);
    	MaterialrequirementsVO vo = BeanMapper.map(entity, MaterialrequirementsVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 单据编码唯一性校验
     * @param entity
     */
    private MaterialrequirementsEntity checkBillCodeUniq(MaterialrequirementsEntity entity) {
        if(entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //单据编码唯一性
            QueryWrapper<MaterialrequirementsEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            List<MaterialrequirementsEntity> proBillCode = service.list(queryWrapperBillCode);
            if(proBillCode != null && proBillCode.size() > 0){
                for (int i = 0; i < proBillCode.size(); i++) {
                    MaterialrequirementsEntity materialrequirementsEntity = proBillCode.get(i);
                    if(!materialrequirementsEntity.getId().equals(entity.getId())){
                        throw new BusinessException("单据编码已存在，请重新录入!");
                    }
                }
            }
        }
        return entity;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialrequirementsVO> queryDetail(Long id) {
    	MaterialrequirementsEntity entity = service.selectById(id);
    	MaterialrequirementsVO vo = BeanMapper.map(entity, MaterialrequirementsVO.class);

        //当前单据变更过则显示变更记录
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecodematerialrequirementsEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", vo.getId());
            List<RecodematerialrequirementsEntity> records = recodematerialrequirementsService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                vo.setRecodematerialrequirementsList(BeanMapper.mapList(records, RecodematerialrequirementsVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialrequirementsVO> vos) {
        service.removeByIds(vos.stream().map(MaterialrequirementsVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialrequirementsVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("project_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("create_user_code");
        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<MaterialrequirementsEntity> page = service.queryPage(param,false);
        IPage<MaterialrequirementsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialrequirementsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("project_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("create_user_code");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaterialrequirementsEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<MaterialrequirementsVO> materialrequirementsVOList = BeanMapper.mapList(list, MaterialrequirementsVO.class);
        for (int i = 0; i < materialrequirementsVOList.size(); i++) {
            MaterialrequirementsVO materialrequirementsVO = materialrequirementsVOList.get(i);
            materialrequirementsVO.setSort(String.valueOf(i+1));
            if (materialrequirementsVO.getCreateTime()!=null){
                materialrequirementsVO.setCreateTimeShow(DateUtils.dateSimple2(materialrequirementsVO.getCreateTime()));
            }

            String billStateStr = materialrequirementsVO.getBillState().toString();
            String changeState = materialrequirementsVO.getChangeState();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                materialrequirementsVO.setBillStateStr(billStateStr);
            }

            if (changeState != null){
                if("1".equals(changeState)){//1:未变更
                    changeState = "未变更";
                }else if("2".equals(changeState)){//2:变更中
                    changeState = "变更中";
                }else if("3".equals(changeState)){//3:已变更
                    changeState = "已变更";
                }

                materialrequirementsVO.setChangeState(changeState);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", materialrequirementsVOList);
        ExcelExport.getInstance().export("Materialrequirements-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialrequirementsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialrequirementsVO>> refMaterialrequirementsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialrequirementsEntity> page = service.queryPage(param,false);
        IPage<MaterialrequirementsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialrequirementsVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
