package com.ejianc.business.bedget.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.vo.ConsdrawbudgetVO;
import com.ejianc.business.bedget.vo.ConsdrawbudgetdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 施工图预算清单导入导出
 */
@Controller
@RequestMapping("consdrawbudgetExport")
public class ExeclConsdrawbudgetController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IConsdrawbudgetdetailService consdrawbudgetdetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadConsdrawbudget")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "consdrawbudgetdetail-import.xlsx", "施工图预算清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportConsdrawbudget", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ConsdrawbudgetdetailVO> successList = new ArrayList<>();
        List<ConsdrawbudgetdetailVO> errorList = new ArrayList<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    ConsdrawbudgetdetailVO consdrawbudgetdetailVO = new ConsdrawbudgetdetailVO();
                    consdrawbudgetdetailVO.setId(IdWorker.getId());//id
                    consdrawbudgetdetailVO.setSort(datas.get(0)); // 序号
                    consdrawbudgetdetailVO.setSection(StringUtils.isNotBlank(datas.get(1))? datas.get(1):null); // 区段
                    consdrawbudgetdetailVO.setSubitemCode(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 子目编码
                    consdrawbudgetdetailVO.setSubitemName(StringUtils.isNotBlank(datas.get(3))?datas.get(3):null); // 子目名称
                    consdrawbudgetdetailVO.setCharacterDescrip(StringUtils.isNotBlank(datas.get(4))?datas.get(4):null); // 子目特征描述
                    consdrawbudgetdetailVO.setEstimateUnit(StringUtils.isNotBlank(datas.get(5))?datas.get(5):null); // 计量单位
                    consdrawbudgetdetailVO.setEngineeQuatity(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):null); // 工程量
                    consdrawbudgetdetailVO.setUnitLaborCost(StringUtils.isNotBlank(datas.get(7))?new BigDecimal(datas.get(7)):null); // 人工费(单价)
                    consdrawbudgetdetailVO.setUnitMaterialCost(StringUtils.isNotBlank(datas.get(8))?new BigDecimal(datas.get(8)):null); // 材料费(单价)
                    consdrawbudgetdetailVO.setUnitMachineryCost(StringUtils.isNotBlank(datas.get(9))?new BigDecimal(datas.get(9)):null); // 机械费(单价)
                    consdrawbudgetdetailVO.setUnitBusinessManagerCost(StringUtils.isNotBlank(datas.get(10))?new BigDecimal(datas.get(10)):null); // 企业管理费(单价)
                    consdrawbudgetdetailVO.setUnitProfit(StringUtils.isNotBlank(datas.get(11))?new BigDecimal(datas.get(11)):null); // 利润(单价)
                    consdrawbudgetdetailVO.setComprehensiveUnitPrice(StringUtils.isNotBlank(datas.get(12))?new BigDecimal(datas.get(12)):null); // 综合单价
                    consdrawbudgetdetailVO.setTotalLaborCost(StringUtils.isNotBlank(datas.get(13))?new BigDecimal(datas.get(13)):null); // 人工费(综合)
                    consdrawbudgetdetailVO.setTotalMaterialCost(StringUtils.isNotBlank(datas.get(14))?new BigDecimal(datas.get(14)):null); // 材料费(综合)
                    consdrawbudgetdetailVO.setTotalMachineryCost(StringUtils.isNotBlank(datas.get(15))?new BigDecimal(datas.get(15)):null); // 机械费(综合)
                    consdrawbudgetdetailVO.setTotalBusinessManagerCost(StringUtils.isNotBlank(datas.get(16))?new BigDecimal(datas.get(16)):null); // 企业管理费(综合)
                    consdrawbudgetdetailVO.setTotalProfit(StringUtils.isNotBlank(datas.get(17))?new BigDecimal(datas.get(17)):null); // 利润(综合)
                    consdrawbudgetdetailVO.setSumTotalPrice(StringUtils.isNotBlank(datas.get(18))?new BigDecimal(datas.get(18)):null); // 合价
                    consdrawbudgetdetailVO.setSocialSecurity(StringUtils.isNotBlank(datas.get(19))?new BigDecimal(datas.get(19)):null); // 社保
                    consdrawbudgetdetailVO.setHousing(StringUtils.isNotBlank(datas.get(20))?new BigDecimal(datas.get(20)):null); // 住房
                    consdrawbudgetdetailVO.setReserved1(StringUtils.isNotBlank(datas.get(21))?new BigDecimal(datas.get(21)):null); // 预留1
                    consdrawbudgetdetailVO.setReserved2(StringUtils.isNotBlank(datas.get(22))?new BigDecimal(datas.get(22)):null); // 预留2
                    consdrawbudgetdetailVO.setReserved3(StringUtils.isNotBlank(datas.get(23))?new BigDecimal(datas.get(23)):null); // 预留3
                    consdrawbudgetdetailVO.setTax(StringUtils.isNotBlank(datas.get(24))?new BigDecimal(datas.get(24)):null); // 税金
                    consdrawbudgetdetailVO.setProvisionalEstimate(StringUtils.isNotBlank(datas.get(25))?new BigDecimal(datas.get(25)):null); // 暂估价
                    /*if(StringUtils.isEmpty(datas.get(0))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(1))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("名称不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(2))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("单位不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(3))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("投标工程量不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(4))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("建筑面积(m²)不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(5))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("投标指标不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(6))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("(计划成本)限额设计指标不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }*/
                    successList.add(consdrawbudgetdetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportConsdrawbudgetFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody ConsdrawbudgetVO consdrawbudgetVO, HttpServletResponse response) {
        QueryWrapper<ConsdrawbudgetdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", consdrawbudgetVO.getId());
        queryWrapper.eq("dr", 0);
        List<ConsdrawbudgetdetailEntity> list = consdrawbudgetdetailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("consdrawbudgetdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportConsdrawbudgetFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<ConsdrawbudgetdetailVO> list, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("consdrawbudgetdetail-export.xlsx", beans, response);
    }

}
