package com.ejianc.business.bedget.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotaldetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.service.IConsdrawbudgettotaldetailService;
import com.ejianc.business.bedget.vo.ConsdrawbudgetVO;
import com.ejianc.business.bedget.vo.ConsdrawbudgettotalVO;
import com.ejianc.business.bedget.vo.ConsdrawbudgettotaldetailVO;
import com.ejianc.business.bedget.vo.ConsdrawbudgettotaldetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 施工图预算汇总清单导入导出
 */
@Controller
@RequestMapping("consdrawtotalExport")
public class ExeclConsdrawbudgettotalController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IConsdrawbudgettotaldetailService consdrawbudgettotaldetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadConsdrawtotal")
    @ResponseBody
    public void downloadConsdrawtotal(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "consdrawbudgettotaldetail-import.xlsx", "施工图预算汇总清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportConsdrawtotal", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawtotal(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ConsdrawbudgettotaldetailVO> successList = new ArrayList<>();
        List<ConsdrawbudgettotaldetailVO> errorList = new ArrayList<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    ConsdrawbudgettotaldetailVO consdrawbudgettotaldetailVO = new ConsdrawbudgettotaldetailVO();
                    consdrawbudgettotaldetailVO.setId(IdWorker.getId());//id
                    consdrawbudgettotaldetailVO.setCode(datas.get(0)); // 编码
                    consdrawbudgettotaldetailVO.setSection(StringUtils.isNotBlank(datas.get(1))? datas.get(1):null); // 区段
                    consdrawbudgettotaldetailVO.setProjectUnitName(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 单位工程名称
                    consdrawbudgettotaldetailVO.setGarbageConsumption(StringUtils.isNotBlank(datas.get(3))?new BigDecimal(datas.get(3)):null); // 其中：施工垃圾场外晕和消纳费
                    consdrawbudgettotaldetailVO.setUnilateralMeasuresCost(StringUtils.isNotBlank(datas.get(4))?new BigDecimal(datas.get(4)):null); // 单方措施项目合价
                    consdrawbudgettotaldetailVO.setOtherItems(StringUtils.isNotBlank(datas.get(5))?new BigDecimal(datas.get(5)):null); // 其他项目
                    consdrawbudgettotaldetailVO.setProjectScale(StringUtils.isNotBlank(datas.get(6))?new BigDecimal(datas.get(6)):null); // 工程规模

                    /*if(StringUtils.isEmpty(datas.get(0))) {
                        consdrawbudgettotaldetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(ConsdrawbudgettotaldetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(1))) {
                        consdrawbudgettotaldetailVO.setErrorMsg("名称不能为空！");
                        errorList.add(ConsdrawbudgettotaldetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(2))) {
                        consdrawbudgettotaldetailVO.setErrorMsg("单位不能为空！");
                        errorList.add(ConsdrawbudgettotaldetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(3))) {
                        consdrawbudgettotaldetailVO.setErrorMsg("投标工程量不能为空！");
                        errorList.add(ConsdrawbudgettotaldetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(4))) {
                        consdrawbudgettotaldetailVO.setErrorMsg("建筑面积(m²)不能为空！");
                        errorList.add(ConsdrawbudgettotaldetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(5))) {
                        consdrawbudgettotaldetailVO.setErrorMsg("投标指标不能为空！");
                        errorList.add(ConsdrawbudgettotaldetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(6))) {
                        consdrawbudgettotaldetailVO.setErrorMsg("(计划成本)限额设计指标不能为空！");
                        errorList.add(ConsdrawbudgettotaldetailVO);
                        continue;
                    }*/
                    successList.add(consdrawbudgettotaldetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportConsdrawtotalFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawtotalFromDatabase(@RequestBody ConsdrawbudgettotalVO consdrawbudgettotalVO, HttpServletResponse response) {
        QueryWrapper<ConsdrawbudgettotaldetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", consdrawbudgettotalVO.getId());
        queryWrapper.eq("dr", 0);
        List<ConsdrawbudgettotaldetailEntity> list = consdrawbudgettotaldetailService.list(queryWrapper);
        for(int i=0;i<list.size();i++){
            ConsdrawbudgettotaldetailEntity  temp = list.get(i);
            temp.setSort(String.valueOf(i + 1));
            list.set(i,temp);
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("consdrawbudgettotaldetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportConsdrawtotalFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawtotalFromPage(@RequestBody List<ConsdrawbudgettotaldetailVO> list, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        for(int i=0;i<list.size();i++){
            ConsdrawbudgettotaldetailVO  temp = list.get(i);
            temp.setSort(String.valueOf(i + 1));
            list.set(i,temp);
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("consdrawbudgettotaldetail-export.xlsx", beans, response);
    }

}
