package com.ejianc.business.bedget.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotadesigndetailEntity;
import com.ejianc.business.bedget.service.IQuotadesigndetailService;
import com.ejianc.business.bedget.vo.QuotaanalysisdetailVO;
import com.ejianc.business.bedget.vo.QuotadesignVO;
import com.ejianc.business.bedget.vo.QuotadesigndetailVO;
import com.ejianc.business.utils.StringFormatUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 限额设计清单导入导出
 */
@Controller
@RequestMapping("quotadesignExport")
public class ExeclQuotadesignController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IQuotadesigndetailService quotadesigndetailService;


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadQuotadesign")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "quotadesigndetail-import.xlsx", "限额设计清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportQuotadesign", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<QuotadesigndetailVO> successList = new ArrayList<>();
        List<QuotadesigndetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Map<String, QuotadesigndetailVO> map = new HashMap<>();

        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 2; i < result.size(); i++) {
                    List<String> datas = result.get(i);

                    String sonItemCode = datas.get(0);
                    String engineering = datas.get(4);
                    String labor = datas.get(5);
                    String material = datas.get(6);
                    String mechanical = datas.get(7);
                    String management = datas.get(8);
                    String profit = datas.get(9);
                    String unitPrice = datas.get(10);
                    String shutLabor = datas.get(11);
                    String shutMaterial = datas.get(12);
                    String shutMechanical = datas.get(13);
                    String shutManagement = datas.get(14);
                    String shutProfit = datas.get(15);
                    String shutPrice = datas.get(16);
                    String clubInsurance = datas.get(17);
                    String housing = datas.get(18);
                    String reserved1 = datas.get(19);
                    String reserved2 = datas.get(20);
                    String reserved3 = datas.get(21);
                    String tax = datas.get(22);
                    String estimation = datas.get(23);
                    QuotadesigndetailVO quotadesigndetailVO = new QuotadesigndetailVO();
                    quotadesigndetailVO.setId(IdWorker.getId());//id
                    quotadesigndetailVO.setTid(String.valueOf(IdWorker.getId()));//tid
                    quotadesigndetailVO.setSonItemCode(StringUtils.isNotBlank(sonItemCode) ? sonItemCode : null); // 子目编码
                    quotadesigndetailVO.setSonItemName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 子目名称
                    quotadesigndetailVO.setSonItemDescribe(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 子目特征描述
                    quotadesigndetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 计量单位

                    //必填项校验
                    if (quotadesigndetailVO.getSonItemCode() == null || TextUtils.isEmpty(quotadesigndetailVO.getSonItemCode())) {
                        quotadesigndetailVO.setErrorMsg("子目编码不能为空！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }
                    if (quotadesigndetailVO.getSonItemName() == null || TextUtils.isEmpty(quotadesigndetailVO.getSonItemName())) {
                        quotadesigndetailVO.setErrorMsg("子目名称不能为空！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }

                    String innercode = quotadesigndetailVO.getSonItemCode();
                    quotadesigndetailVO.setInnercode(innercode);
                    if("01".equals(quotadesigndetailVO.getSonItemCode())&&quotadesigndetailVO.getSonItemName().contains("装饰")){
                        innercode = "a1";
                    }
                    //判断是否是装饰工程的子节点编码
                    if (quotadesigndetailVO.getSonItemCode().length() >= 4) {
                        //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
                        String code = quotadesigndetailVO.getSonItemCode().substring(0, 4);
                        if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
                            //若是的话，将内码改为a1xx
                            innercode = "a1" + quotadesigndetailVO.getSonItemCode().substring(2, quotadesigndetailVO.getSonItemCode().length());
                        }
                    }
                    quotadesigndetailVO.setInnercode(innercode);

                    Long pid = null;
                    if (innercode.length() == 2) {
                        //最上级
                    } else if (innercode.length() == 4) {
                        String pcode = innercode.substring(0, 2);
                        //有父节点
                        pid = this.setPid(pcode, map);

                    } else if (innercode.length() == 6) {
                        String pcode = innercode.substring(0, 4);
                        //有父节点
                        pid = this.setPid(pcode, map);
                    } else if (innercode.length() > 6) {
                        String pcode = innercode.substring(0, 6);
                        //有父节点
                        pid = this.setPid(pcode, map);
                    }

                    if (pid != null) {
                        quotadesigndetailVO.setTpid(pid.toString());
                    } else {
                        quotadesigndetailVO.setTpid("");
                    }

                    //1、校验编码是否符合规则--2、4、6、9、9以上
                    if (sonItemCode == null || !(sonItemCode.length() == 2 || sonItemCode.length() == 4 || sonItemCode.length() == 6 || sonItemCode.length() >= 9)) {
                        quotadesigndetailVO.setErrorMsg("子目编码必须符合：2位、4位、6位、9位或9位以上中任意一规则");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }

                    //重复性校验
                    QuotadesigndetailVO mapVO = map.get(quotadesigndetailVO.getInnercode());
                    if(mapVO == null){
                        map.put(quotadesigndetailVO.getInnercode(), quotadesigndetailVO);
                    }else {
                        quotadesigndetailVO.setErrorMsg("子目编码已存在");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }

                    //格式校验
                    if(!TextUtils.isEmpty(engineering) && !StringFormatUtil.validateNumber(engineering)){
                        quotadesigndetailVO.setErrorMsg("工程量格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setEngineering(StringUtils.isNotBlank(engineering) ? new BigDecimal(engineering) : null); // 工程量
                    }

                    if(!TextUtils.isEmpty(labor) && !StringFormatUtil.validateNumber(labor)){
                        quotadesigndetailVO.setErrorMsg("人工费（单价）格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setLabor(StringUtils.isNotBlank(labor) ? new BigDecimal(labor) : null); // 人工费(单价)
                    }

                    if(!TextUtils.isEmpty(material) && !StringFormatUtil.validateNumber(material)){
                        quotadesigndetailVO.setErrorMsg("材料费（单价）格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setMaterial(StringUtils.isNotBlank(material) ? new BigDecimal(material) : null); // 材料费(单价)
                    }

                    if(!TextUtils.isEmpty(mechanical) && !StringFormatUtil.validateNumber(mechanical)){
                        quotadesigndetailVO.setErrorMsg("机械费（单价）格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setMechanical(StringUtils.isNotBlank(mechanical) ? new BigDecimal(mechanical) : null); // 机械费(单价)
                    }

                    if(!TextUtils.isEmpty(management) && !StringFormatUtil.validateNumber(management)){
                        quotadesigndetailVO.setErrorMsg("企业管理费（单价）格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setManagement(StringUtils.isNotBlank(management) ? new BigDecimal(management) : null); // 企业管理费(单价)
                    }

                    if(!TextUtils.isEmpty(profit) && !StringFormatUtil.validateNumber(profit)){
                        quotadesigndetailVO.setErrorMsg("利润（单价）格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setProfit(StringUtils.isNotBlank(profit) ? new BigDecimal(profit) : null); // 利润(单价)
                    }

                    if(!TextUtils.isEmpty(unitPrice) && !StringFormatUtil.validateNumber(unitPrice)){
                        quotadesigndetailVO.setErrorMsg("综合单价格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setUnitPrice(StringUtils.isNotBlank(unitPrice) ? new BigDecimal(unitPrice) : null); // 综合单价
                    }
                    if(!TextUtils.isEmpty(shutLabor) && !StringFormatUtil.validateNumber(shutLabor)){
                        quotadesigndetailVO.setErrorMsg("人工费（合价）格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setShutLabor(StringUtils.isNotBlank(shutLabor) ? new BigDecimal(shutLabor) : null); // 人工费(综合)
                    }
                    if(!TextUtils.isEmpty(shutMaterial) && !StringFormatUtil.validateNumber(shutMaterial)){
                        quotadesigndetailVO.setErrorMsg("材料费（合价）格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setShutMaterial(StringUtils.isNotBlank(shutMaterial) ? new BigDecimal(shutMaterial) : null); // 材料费(综合)
                    }

                    if(!TextUtils.isEmpty(shutMechanical) && !StringFormatUtil.validateNumber(shutMechanical)){
                        quotadesigndetailVO.setErrorMsg("机械费（合价）格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setShutMechanical(StringUtils.isNotBlank(shutMechanical) ? new BigDecimal(shutMechanical) : null); // 机械费(综合)
                    }

                    if(!TextUtils.isEmpty(shutManagement) && !StringFormatUtil.validateNumber(shutManagement)){
                        quotadesigndetailVO.setErrorMsg("企业管理费（合价）格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setShutManagement(StringUtils.isNotBlank(shutManagement) ? new BigDecimal(shutManagement) : null); // 企业管理费
                    }

                    if(!TextUtils.isEmpty(shutProfit) && !StringFormatUtil.validateNumber(shutProfit)){
                        quotadesigndetailVO.setErrorMsg("利润（合价）格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setShutProfit(StringUtils.isNotBlank(shutProfit) ? new BigDecimal(shutProfit) : null); // 利润
                    }

                    if(!TextUtils.isEmpty(shutPrice) && !StringFormatUtil.validateNumber(shutPrice)){
                        quotadesigndetailVO.setErrorMsg("合价格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setShutPrice(StringUtils.isNotBlank(shutPrice) ? new BigDecimal(shutPrice) : null); // 合价
                    }

                    if(!TextUtils.isEmpty(clubInsurance) && !StringFormatUtil.validateNumber(clubInsurance)){
                        quotadesigndetailVO.setErrorMsg("社保格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setClubInsurance(StringUtils.isNotBlank(clubInsurance) ? new BigDecimal(clubInsurance) : null); // 社保
                    }

                    if(!TextUtils.isEmpty(housing) && !StringFormatUtil.validateNumber(housing)){
                        quotadesigndetailVO.setErrorMsg("住房格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setHousing(StringUtils.isNotBlank(housing) ? new BigDecimal(housing) : null); // 住房
                    }

                    if(!TextUtils.isEmpty(reserved1) && !StringFormatUtil.validateNumber(reserved1)){
                        quotadesigndetailVO.setErrorMsg("预留1格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setReserved1(StringUtils.isNotBlank(reserved1) ? new BigDecimal(reserved1) : null); //预留1
                    }

                    if(!TextUtils.isEmpty(reserved2) && !StringFormatUtil.validateNumber(reserved2)){
                        quotadesigndetailVO.setErrorMsg("预留2格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setReserved2(StringUtils.isNotBlank(reserved2) ? new BigDecimal(reserved2) : null); //预留2
                    }

                    if(!TextUtils.isEmpty(reserved3) && !StringFormatUtil.validateNumber(reserved3)){
                        quotadesigndetailVO.setErrorMsg("预留3格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setReserved3(StringUtils.isNotBlank(reserved3) ? new BigDecimal(reserved3) : null); // 预留3
                    }

                    if(!TextUtils.isEmpty(tax) && !StringFormatUtil.validateNumber(tax)){
                        quotadesigndetailVO.setErrorMsg("税金格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setTax(StringUtils.isNotBlank(tax) ? new BigDecimal(tax) : null); // 税金
                    }

                    if(!TextUtils.isEmpty(estimation) && !StringFormatUtil.validateNumber(estimation)){
                        quotadesigndetailVO.setErrorMsg("暂估价格式不正确！");
                        errorList.add(quotadesigndetailVO);
                        continue;
                    }else {
                        quotadesigndetailVO.setEstimation(StringUtils.isNotBlank(estimation) ? new BigDecimal(estimation) : null); // 暂估价
                    }

                    successList.add(quotadesigndetailVO);
                }
            }
        }

        //按子目编码排序
        Collections.sort(successList, new Comparator<QuotadesigndetailVO>() {
            @Override
            public int compare(QuotadesigndetailVO o1, QuotadesigndetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });

        //构建树
        List<QuotadesigndetailVO> resList = createTreeData(successList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        QuotadesignVO resVo = new QuotadesignVO();
        json.put("total", getTotalAmount(resList, resVo));

        return CommonResponse.success(json);
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, QuotadesigndetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            if (pcode.length() == 2) {
                //最上级
                return null;
            } else if (pcode.length() == 4) {
                String ppcode = pcode.substring(0, 2);
                return this.setPid(ppcode, map);
            } else if (pcode.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode, map);
            } else if (pcode.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode, map);
            } else {
                return null;
            }
        }
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<QuotadesigndetailVO> createTreeData(List<QuotadesigndetailVO> list) {
        List<QuotadesigndetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, QuotadesigndetailVO> listMap = new HashMap<>();
        for (QuotadesigndetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            QuotadesigndetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            QuotadesigndetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<QuotadesigndetailVO> child = (List<QuotadesigndetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<QuotadesigndetailVO> children = new ArrayList<QuotadesigndetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    private QuotadesignVO getTotalAmount(List<QuotadesigndetailVO> vos, QuotadesignVO resVo) {
        BigDecimal costTotal = new BigDecimal(0);
        BigDecimal laborTotal = new BigDecimal(0);
        BigDecimal materialTotal = new BigDecimal(0);
        BigDecimal mechanicalTotal = new BigDecimal(0);
        BigDecimal profitsTotal = new BigDecimal(0);
        BigDecimal managementTotal = new BigDecimal(0);
        BigDecimal feesTotal = new BigDecimal(0);
        BigDecimal taxTotal = new BigDecimal(0);

        for (QuotadesigndetailVO vo : vos) {
            if (vo.getShutPrice() != null) {
                costTotal = costTotal.add(vo.getShutPrice());
            }
            if (vo.getShutLabor() != null) {
                laborTotal = laborTotal.add(vo.getShutLabor());
            }
            if (vo.getShutMaterial() != null) {
                materialTotal = materialTotal.add(vo.getShutMaterial());
            }
            if (vo.getShutMechanical() != null) {
                mechanicalTotal = mechanicalTotal.add(vo.getShutMechanical());
            }
            if (vo.getShutProfit() != null) {
                profitsTotal = profitsTotal.add(vo.getShutProfit());
            }
            if (vo.getShutManagement() != null) {
                managementTotal = managementTotal.add(vo.getShutManagement());
            }
            if (vo.getTax() != null) {
                taxTotal = taxTotal.add(vo.getTax());
            }

            //规费合计
            if (vo.getClubInsurance() != null) {
                feesTotal = feesTotal.add(vo.getClubInsurance());
            }
            if (vo.getHousing() != null) {
                feesTotal = feesTotal.add(vo.getHousing());
            }
            if (vo.getReserved1() != null) {
                feesTotal = feesTotal.add(vo.getReserved1());
            }
            if (vo.getReserved2() != null) {
                feesTotal = feesTotal.add(vo.getReserved2());
            }
            if (vo.getReserved3() != null) {
                feesTotal = feesTotal.add(vo.getReserved3());
            }
        }

        resVo.setCostTotal(costTotal);
        resVo.setLaborTotal(laborTotal);
        resVo.setMaterialTotal(materialTotal);
        resVo.setMechanicalTotal(mechanicalTotal);
        resVo.setProfitsTotal(profitsTotal);
        resVo.setManagementTotal(managementTotal);
        resVo.setFeesTotal(feesTotal);
        resVo.setTaxTotal(taxTotal);
        return resVo;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @returnq
     */
    @RequestMapping(value = "/excelExportQuotadesignFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody QuotadesignVO quotadesignVO, HttpServletResponse response) {
        QueryWrapper<QuotadesigndetailEntity> queryWrapper;
        queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", quotadesignVO.getId());
        queryWrapper.eq("dr", 0);
        queryWrapper.orderByAsc("son_item_code");
        List<QuotadesigndetailEntity> list = quotadesigndetailService.list(queryWrapper);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("quotadesigndetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportQuotadesignFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<QuotadesigndetailVO> list, HttpServletResponse response) {
        List<QuotadesigndetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                QuotadesigndetailVO quotadesigndetailVO = list.get(i);
                concatList.add(quotadesigndetailVO);
            }
        }

        //children拍平
        List<QuotadesigndetailVO> allList = handleList(list, concatList);
        //按序号排序
        Collections.sort(allList, new Comparator<QuotadesigndetailVO>() {
            @Override
            public int compare(QuotadesigndetailVO o1, QuotadesigndetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("quotadesigndetail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<QuotadesigndetailVO> handleList(List<QuotadesigndetailVO> list, List<QuotadesigndetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            QuotadesigndetailVO quotadesigndetailVO = list.get(i);
            List<QuotadesigndetailVO> children = quotadesigndetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }

}
