package com.ejianc.business.bedget.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.bean.SubpackagedetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.service.ISubpackagedetailService;
import com.ejianc.business.bedget.vo.*;
import com.ejianc.business.utils.StringFormatUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 分包施工导入导出
 */
@Controller
@RequestMapping("subpackageExport")
public class ExeclSubpackageController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISubpackagedetailService subpackagedetailService;


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadSubpackage")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "subpackagedetail-import.xlsx", "施工图预算清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportSubpackage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SubpackagedetailVO> successList = new ArrayList<>();
        List<SubpackagedetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Map<String, SubpackagedetailVO> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 2; i < result.size(); i++) {
                    List<String> datas = result.get(i);

                    String sort = datas.get(0);// 序号
                    String section = datas.get(1);// 区段
                    String subtitleCode = datas.get(2); // 子目编码
                    String subtitleName = datas.get(3); // 子目名称
                    String subtitleFeature = datas.get(4);  // 子目特征描述
                    String measuringUnit = datas.get(5);// 计量单位
                    String quantities = datas.get(6); // 工程量
                    String artificialUnitPrice = datas.get(7); // 人工费(单价)
                    String materialsUnitPrice = datas.get(8); // 材料费(单价)
                    String mechanicalUnitPrice = datas.get(9); // 机械费(单价)
                    String enterpriseManageUnitPrice = datas.get(10); // 企业管理费(单价)
                    String profitsUnitPrice = datas.get(11); // 利润(单价)
                    String feesUnitPrice = datas.get(12); //  规费
                    String taxUnitPrice = datas.get(13); //  税金
                    String comprehensiveUnitPrice = datas.get(14);  // 综合单价
                    String artificialTotal = datas.get(15); // 人工费(综合)
                    String materialsTotal = datas.get(16); // 材料费(综合)
                    String mechanicalTotal = datas.get(17);  // 机械费(综合)
                    String enterpriseManageTotal = datas.get(18); // 企业管理费
                    String profitsTotal = datas.get(19);  // 利润
                    String feesTotal = datas.get(20); //  规费
                    String taxTotal = datas.get(21); //  税金
                    String comprehensiveTotal = datas.get(22); // 合价
                    String subpackageBudgetTotal = datas.get(23); // 分包施工图预算量合计
                    String subpackageQuantities = datas.get(24); // 工程量
                    String subpackageMeasuringUnit = datas.get(25); //计量单位
                    String excludingTaxUnitPrice = datas.get(26); //除税单价
                    String includingTaxUnitPrice = datas.get(27); //含税单价
                    String excludingTaxTotal = datas.get(28); // 除税合价
                    String includingTaxTotal = datas.get(29); // 含税合价

                    SubpackagedetailVO subpackagedetailVO = new SubpackagedetailVO();
                    subpackagedetailVO.setId(IdWorker.getId());//id
                    subpackagedetailVO.setTid(String.valueOf(IdWorker.getId()));//tid
                    subpackagedetailVO.setSubtitleCode(StringUtils.isNotBlank(subtitleCode) ? subtitleCode : null); // 子目编码
                    subpackagedetailVO.setSubtitleName(StringUtils.isNotBlank(subtitleName) ? subtitleName : null); // 子目名称
                    subpackagedetailVO.setSubtitleFeature(StringUtils.isNotBlank(subtitleFeature) ? subtitleFeature : null); // 子目特征描述
                    subpackagedetailVO.setMeasuringUnit(StringUtils.isNotBlank(measuringUnit) ? measuringUnit : null); // 计量单位

                    if(StringUtils.isEmpty(sort) || sort == null){
                        subpackagedetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setSort(sort);
                    }

                    if(StringUtils.isEmpty(section) || section == null){
                        subpackagedetailVO.setErrorMsg("区段不能为空！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setSection(section);
                    }
                    //必填项校验
                    if (subpackagedetailVO.getSubtitleCode() == null || TextUtils.isEmpty(subpackagedetailVO.getSubtitleCode())) {
                        subpackagedetailVO.setErrorMsg("子目编码不能为空！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }
                    if (subpackagedetailVO.getSubtitleName() == null || TextUtils.isEmpty(subpackagedetailVO.getSubtitleName())) {
                        subpackagedetailVO.setErrorMsg("子目名称不能为空！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }

                    String innercode = subpackagedetailVO.getSubtitleCode();
                    subpackagedetailVO.setInnercode(innercode);
                    if("01".equals(subpackagedetailVO.getSubtitleCode())&&subpackagedetailVO.getSubtitleName().contains("装饰")){
                        innercode = "a1";
                    }
                    //判断是否是装饰工程的子节点编码
                    if (subpackagedetailVO.getSubtitleCode().length() >= 4) {
                        //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
                        String code = subpackagedetailVO.getSubtitleCode().substring(0, 4);
                        if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
                            //若是的话，将内码改为a1xx
                            innercode = "a1" + subpackagedetailVO.getSubtitleCode().substring(2, subpackagedetailVO.getSubtitleCode().length());
                        }
                    }
                    subpackagedetailVO.setInnercode(innercode);

                    Long pid = null;
                    if (innercode.length() == 2) {
                        //最上级
                    } else if (innercode.length() == 4) {
                        String pcode = innercode.substring(0, 2);
                        //有父节点
                        pid = this.setPid(pcode, map);

                    } else if (innercode.length() == 6) {
                        String pcode = innercode.substring(0, 4);
                        //有父节点
                        pid = this.setPid(pcode, map);
                    } else if (innercode.length() > 6) {
                        String pcode = innercode.substring(0, 6);
                        //有父节点
                        pid = this.setPid(pcode, map);
                    }

                    if (pid != null) {
                        subpackagedetailVO.setTpid(pid.toString());
                    } else {
                        subpackagedetailVO.setTpid("");
                    }

                    //1、校验编码是否符合规则--2、4、6、9、9以上
                    if (subtitleCode == null || !(subtitleCode.length() == 2 || subtitleCode.length() == 4 || subtitleCode.length() == 6 || subtitleCode.length() >= 9)) {
                        subpackagedetailVO.setErrorMsg("子目编码必须符合：2位、4位、6位、9位或9位以上中任意一规则");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }

                    //重复性校验
                    SubpackagedetailVO mapVO = map.get(subpackagedetailVO.getInnercode());
                    if(mapVO == null){
                        map.put(subpackagedetailVO.getInnercode(), subpackagedetailVO);
                    }else {
                        subpackagedetailVO.setErrorMsg("子目编码已存在");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }

                    //格式校验
                    if(!TextUtils.isEmpty(quantities) && !NumberUtil.isNumber(quantities)){
                        subpackagedetailVO.setErrorMsg("工程量格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setQuantities(StringUtils.isNotBlank(quantities) ? new BigDecimal(quantities) : null);
                    }

                    if(!TextUtils.isEmpty(artificialUnitPrice) && !NumberUtil.isNumber(artificialUnitPrice)){
                        subpackagedetailVO.setErrorMsg("人工费(单价)格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setArtificialUnitPrice(StringUtils.isNotBlank(artificialUnitPrice) ? new BigDecimal(artificialUnitPrice) : null);
                    }


                    if(!TextUtils.isEmpty(materialsUnitPrice) && !NumberUtil.isNumber(materialsUnitPrice)){
                        subpackagedetailVO.setErrorMsg("材料费(单价)格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setMaterialsUnitPrice(StringUtils.isNotBlank(materialsUnitPrice) ? new BigDecimal(materialsUnitPrice) : null);
                    }

                    if(!TextUtils.isEmpty(mechanicalUnitPrice) && !NumberUtil.isNumber(mechanicalUnitPrice)){
                        subpackagedetailVO.setErrorMsg("机械费(单价)格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setMechanicalUnitPrice(StringUtils.isNotBlank(mechanicalUnitPrice) ? new BigDecimal(mechanicalUnitPrice) : null);
                    }

                    if(!TextUtils.isEmpty(enterpriseManageUnitPrice) && !NumberUtil.isNumber(enterpriseManageUnitPrice)){
                        subpackagedetailVO.setErrorMsg("企业管理费(单价)格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setEnterpriseManageUnitPrice(StringUtils.isNotBlank(enterpriseManageUnitPrice) ? new BigDecimal(enterpriseManageUnitPrice) : null);
                    }

                    if(!TextUtils.isEmpty(profitsUnitPrice) && !NumberUtil.isNumber(profitsUnitPrice)){
                        subpackagedetailVO.setErrorMsg("利润(单价)格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setProfitsUnitPrice(StringUtils.isNotBlank(profitsUnitPrice) ? new BigDecimal(profitsUnitPrice) : null);
                    }

                    if(!TextUtils.isEmpty(feesUnitPrice) && !NumberUtil.isNumber(feesUnitPrice)){
                        subpackagedetailVO.setErrorMsg("规费格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setFeesUnitPrice(StringUtils.isNotBlank(feesUnitPrice) ? new BigDecimal(feesUnitPrice) : null);
                    }

                    if(!TextUtils.isEmpty(taxUnitPrice) && !NumberUtil.isNumber(taxUnitPrice)){
                        subpackagedetailVO.setErrorMsg("税金格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setTaxUnitPrice(StringUtils.isNotBlank(taxUnitPrice) ? new BigDecimal(taxUnitPrice) : null);
                    }

                    if(!TextUtils.isEmpty(comprehensiveUnitPrice) && !NumberUtil.isNumber(comprehensiveUnitPrice)){
                        subpackagedetailVO.setErrorMsg("综合单价格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setComprehensiveUnitPrice(StringUtils.isNotBlank(comprehensiveUnitPrice) ? new BigDecimal(comprehensiveUnitPrice) : null);
                    }

                    if(!TextUtils.isEmpty(artificialTotal) && !NumberUtil.isNumber(artificialTotal)){
                        subpackagedetailVO.setErrorMsg("人工费(综合)格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setArtificialTotal(StringUtils.isNotBlank(artificialTotal) ? new BigDecimal(artificialTotal) : null);
                    }

                    if(!TextUtils.isEmpty(materialsTotal) && !NumberUtil.isNumber(materialsTotal)){
                        subpackagedetailVO.setErrorMsg("材料费(综合)格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setMaterialsTotal(StringUtils.isNotBlank(materialsTotal) ? new BigDecimal(materialsTotal) : null);
                    }

                    if(!TextUtils.isEmpty(mechanicalTotal) && !NumberUtil.isNumber(mechanicalTotal)){
                        subpackagedetailVO.setErrorMsg("机械费(综合)格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setMechanicalTotal(StringUtils.isNotBlank(mechanicalTotal) ? new BigDecimal(mechanicalTotal) : null);
                    }

                    if(!TextUtils.isEmpty(enterpriseManageTotal) && !NumberUtil.isNumber(enterpriseManageTotal)){
                        subpackagedetailVO.setErrorMsg("企业管理费(综合)格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setEnterpriseManageTotal(StringUtils.isNotBlank(enterpriseManageTotal) ? new BigDecimal(enterpriseManageTotal) : null);
                    }

                    if(!TextUtils.isEmpty(profitsTotal) && !NumberUtil.isNumber(profitsTotal)){
                        subpackagedetailVO.setErrorMsg("利润格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setProfitsTotal(StringUtils.isNotBlank(profitsTotal) ? new BigDecimal(profitsTotal) : null);
                    }

                    if(!TextUtils.isEmpty(feesTotal) && !NumberUtil.isNumber(feesTotal)){
                        subpackagedetailVO.setErrorMsg("规费格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setFeesTotal(StringUtils.isNotBlank(feesTotal) ? new BigDecimal(feesTotal) : null);
                    }

                    if(!TextUtils.isEmpty(taxTotal) && !NumberUtil.isNumber(taxTotal)){
                        subpackagedetailVO.setErrorMsg("税金格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setTaxTotal(StringUtils.isNotBlank(taxTotal) ? new BigDecimal(taxTotal) : null);
                    }

                    if(!TextUtils.isEmpty(comprehensiveTotal) && !NumberUtil.isNumber(comprehensiveTotal)){
                        subpackagedetailVO.setErrorMsg("合价格式不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setComprehensiveTotal(StringUtils.isNotBlank(comprehensiveTotal) ? new BigDecimal(comprehensiveTotal) : null);
                    }

                    if(!TextUtils.isEmpty(subpackageBudgetTotal) && !NumberUtil.isNumber(subpackageBudgetTotal)){
                        subpackagedetailVO.setErrorMsg("分包施工图预算量合计不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setSubpackageBudgetTotal(StringUtils.isNotBlank(subpackageBudgetTotal) ? new BigDecimal(subpackageBudgetTotal) : null);
                    }

                    if(!TextUtils.isEmpty(subpackageQuantities) && !NumberUtil.isNumber(subpackageQuantities)){
                        subpackagedetailVO.setErrorMsg("工程量合计不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setSubpackageQuantities(StringUtils.isNotBlank(subpackageQuantities) ? new BigDecimal(subpackageQuantities) : null);
                    }

                    if(!TextUtils.isEmpty(excludingTaxUnitPrice) && !NumberUtil.isNumber(excludingTaxUnitPrice)){
                        subpackagedetailVO.setErrorMsg("除税单价不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setExcludingTaxUnitPrice(StringUtils.isNotBlank(excludingTaxUnitPrice) ? new BigDecimal(excludingTaxUnitPrice) : null);
                    }

                    if(!TextUtils.isEmpty(includingTaxUnitPrice) && !NumberUtil.isNumber(includingTaxUnitPrice)){
                        subpackagedetailVO.setErrorMsg("含税单价不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setIncludingTaxUnitPrice(StringUtils.isNotBlank(includingTaxUnitPrice) ? new BigDecimal(includingTaxUnitPrice) : null);
                    }

                    if(!TextUtils.isEmpty(excludingTaxTotal) && !NumberUtil.isNumber(excludingTaxTotal)){
                        subpackagedetailVO.setErrorMsg("除税合价不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setExcludingTaxTotal(StringUtils.isNotBlank(excludingTaxTotal) ? new BigDecimal(excludingTaxTotal) : null);
                    }

                    if(!TextUtils.isEmpty(includingTaxTotal) && !NumberUtil.isNumber(includingTaxTotal)){
                        subpackagedetailVO.setErrorMsg("含税合价不正确！");
                        errorList.add(subpackagedetailVO);
                        continue;
                    }else {
                        subpackagedetailVO.setIncludingTaxTotal(StringUtils.isNotBlank(includingTaxTotal) ? new BigDecimal(includingTaxTotal) : null);
                    }

                    successList.add(subpackagedetailVO);
                }
            }
        }

        //按子目编码排序
        Collections.sort(successList, new Comparator<SubpackagedetailVO>() {
            @Override
            public int compare(SubpackagedetailVO o1, SubpackagedetailVO o2) {
                return o1.getSubtitleCode().compareTo(o2.getSubtitleCode());
            }
        });

        //构建树
        List<SubpackagedetailVO> resList = createTreeData(successList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        SubpackageVO resVo = new SubpackageVO();
        json.put("total", getTotalAmount(resList, resVo));

        return CommonResponse.success(json);
    }

    private SubpackageVO getTotalAmount(List<SubpackagedetailVO> vos, SubpackageVO resVo) {
        BigDecimal exTaxTotal = new BigDecimal(0);
        BigDecimal inTaxTotal = new BigDecimal(0);

        for (SubpackagedetailVO vo : vos) {
            if (vo.getExcludingTaxTotal() != null) {
                exTaxTotal = exTaxTotal.add(vo.getExcludingTaxTotal());
            }
            if (vo.getIncludingTaxTotal() != null) {
                inTaxTotal = inTaxTotal.add(vo.getIncludingTaxTotal());
            }
        }

        resVo.setExcludingTaxTotal(exTaxTotal);
        resVo.setIncludingTaxTotal(inTaxTotal);
        return resVo;
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, SubpackagedetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            if (pcode.length() == 2) {
                //最上级
                return null;
            } else if (pcode.length() == 4) {
                String ppcode = pcode.substring(0, 2);
                return this.setPid(ppcode, map);
            } else if (pcode.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode, map);
            } else if (pcode.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode, map);
            } else {
                return null;
            }
        }
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<SubpackagedetailVO> createTreeData(List<SubpackagedetailVO> list) {
        List<SubpackagedetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, SubpackagedetailVO> listMap = new HashMap<>();
        for (SubpackagedetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            SubpackagedetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            SubpackagedetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<SubpackagedetailVO> child = (List<SubpackagedetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<SubpackagedetailVO> children = new ArrayList<SubpackagedetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubpackageFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody SubpackageVO subpackageVO, HttpServletResponse response) {
        QueryWrapper<SubpackagedetailEntity> queryWrapper;
        queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", subpackageVO.getId());
        queryWrapper.eq("dr", 0);
        List<SubpackagedetailEntity> list = subpackagedetailService.list(queryWrapper);
        List<SubpackagedetailVO> subpackagedetailVOList = BeanMapper.mapList(list, SubpackagedetailVO.class);
        if (subpackagedetailVOList != null && subpackagedetailVOList.size() > 0) {
            for (int i = 0; i < subpackagedetailVOList.size(); i++) {
                SubpackagedetailVO subpackagedetailVO = subpackagedetailVOList.get(i);
                subpackagedetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subpackagedetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubpackageFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<SubpackagedetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                SubpackagedetailVO subpackagedetailVO = list.get(i);
                subpackagedetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subpackagedetail-export.xlsx", beans, response);
    }

}
