package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.ejianc.business.bedget.bean.ConsdrawbudgettotalEntity;
import com.ejianc.business.bedget.bean.SubpackagematerialanalysisEntity;
import com.ejianc.business.bedget.service.ISubpackagematerialanalysisService;
import com.ejianc.business.change.bean.ChangesubpachagematerialanalysisEntity;
import com.ejianc.business.change.service.IChangesubpachagematerialanalysisService;
import com.ejianc.business.change.vo.ChangeconsdrawbudgettotalVO;
import com.ejianc.business.change.vo.ChangeconsdrawbudgettotaldetailVO;
import com.ejianc.business.change.vo.ChangesubpachagematerialanalysisVO;
import com.ejianc.business.change.vo.ChangesubpackmateanalydetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;



/**
 * 分包施工图预算材料分析变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changesubpachagematerialanalysis")
public class ChangesubpachagematerialanalysisController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanager-changesubpachagematerialanalysis";//此处需要根据实际修改

    @Autowired
    private IChangesubpachagematerialanalysisService service;
    @Autowired
    private ISubpackagematerialanalysisService subpackagematerialanalysisService;



    /**
     * 初始化更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetailBySubpackagematerialanalysisId")
    @ResponseBody
    public CommonResponse<ChangesubpachagematerialanalysisVO> queryDetailBySubpackagematerialanalysisId(@RequestParam(value = "subpackagematerialanalysisId") Long subpackagematerialanalysisId) {
        SubpackagematerialanalysisEntity subpackagematerialanalysisEntity = subpackagematerialanalysisService.selectById(subpackagematerialanalysisId);
        ChangesubpachagematerialanalysisVO changeVO = BeanMapper.map(subpackagematerialanalysisEntity, ChangesubpachagematerialanalysisVO.class);
        Long id = IdWorker.getId();
        changeVO.setOriginalId(subpackagematerialanalysisId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        //限额设计指标分析清单
        List<ChangesubpackmateanalydetailVO> changesubpackagematerialanalysisdetailEntities = changeVO.getSubpackagematerialanalysisdetailEntites();
        if(changesubpackagematerialanalysisdetailEntities!=null&&changesubpackagematerialanalysisdetailEntities.size()>0){
            List<ChangesubpackmateanalydetailVO> changedesignestimatedetailVOS = new ArrayList<>();
            for(ChangesubpackmateanalydetailVO entity : changesubpackagematerialanalysisdetailEntities){
                ChangesubpackmateanalydetailVO vo = BeanMapper.map(entity, ChangesubpackmateanalydetailVO.class);
                vo.setMid(subpackagematerialanalysisId);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changedesignestimatedetailVOS.add(vo);
            }
             changeVO.setSubpackagematerialanalysisdetailEntites(changesubpackagematerialanalysisdetailEntities);
        }

        return CommonResponse.success("查询详情成功！", changeVO);

    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangesubpachagematerialanalysisVO> saveChange(@RequestBody ChangesubpachagematerialanalysisVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangesubpachagematerialanalysisVO> saveOrUpdate(@RequestBody ChangesubpachagematerialanalysisVO saveorUpdateVO) {
    	ChangesubpachagematerialanalysisEntity entity = BeanMapper.map(saveorUpdateVO, ChangesubpachagematerialanalysisEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ChangesubpachagematerialanalysisVO vo = BeanMapper.map(entity, ChangesubpachagematerialanalysisVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangesubpachagematerialanalysisVO> queryDetail(Long id) {
    	ChangesubpachagematerialanalysisEntity entity = service.selectById(id);
    	ChangesubpachagematerialanalysisVO vo = BeanMapper.map(entity, ChangesubpachagematerialanalysisVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangesubpachagematerialanalysisVO> vos) {
        service.removeByIds(vos.stream().map(ChangesubpachagematerialanalysisVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangesubpachagematerialanalysisVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangesubpachagematerialanalysisEntity> page = service.queryPage(param,false);
        IPage<ChangesubpachagematerialanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangesubpachagematerialanalysisVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangesubpachagematerialanalysisEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Changesubpachagematerialanalysis-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refChangesubpachagematerialanalysisData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangesubpachagematerialanalysisVO>> refChangesubpachagematerialanalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangesubpachagematerialanalysisEntity> page = service.queryPage(param,false);
        IPage<ChangesubpachagematerialanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangesubpachagematerialanalysisVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
