package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

import com.ejianc.business.change.bean.ChangematerialanalysisdetailEntity;
import com.ejianc.business.change.service.IChangematerialanalysisdetailService;
import com.ejianc.business.change.vo.ChangematerialanalysisVO;
import com.ejianc.business.change.vo.ChangematerialanalysisdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 施工图预算材料分析清单变更导入导出
 */
@Controller
@RequestMapping("changeMaterialanalysisExport")
public class ExeclChangeMaterialanalysisController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangematerialanalysisdetailService changematerialanalysisdetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadmaterialanalysis")
    @ResponseBody
    public void downloadmaterialanalysis(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "materialanalysisdetail-import.xlsx", "施工图预算材料分析清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportmaterialanalysis", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportmaterialanalysis(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangematerialanalysisdetailVO> successList = new ArrayList<>();
        List<ChangematerialanalysisdetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 3; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    ChangematerialanalysisdetailVO changematerialanalysisdetailVO = new ChangematerialanalysisdetailVO();
                    changematerialanalysisdetailVO.setId(IdWorker.getId());//id
                    changematerialanalysisdetailVO.setSort(datas.get(0)); // 序号
                    changematerialanalysisdetailVO.setMaterialsName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 物资名称
                    changematerialanalysisdetailVO.setSpec(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 规格型号
                    changematerialanalysisdetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 计量单位
                    changematerialanalysisdetailVO.setQuantitiesBase(StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) : null); // 分包基础清单工程量
                    changematerialanalysisdetailVO.setMaterialWasteRateBase(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); // 合同约定基础用料损耗率
                    changematerialanalysisdetailVO.setMaterialWasteBase(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : null); // 基础用料损耗量
                    changematerialanalysisdetailVO.setMaterialDosageBase(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); // 基础材料用量
                    changematerialanalysisdetailVO.setQuantitiesMain(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 分包主体清单工程量
                    changematerialanalysisdetailVO.setMaterialWasteRateDecorate(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 合同约定装修用料损耗率
                    changematerialanalysisdetailVO.setMaterialWasteMain(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null); // 主体用料损耗量
                    changematerialanalysisdetailVO.setMaterialDosageMain(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); // 主体材料用量
                    changematerialanalysisdetailVO.setQuantitiesDecorate(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null); // 分包装修清单工程量
                    changematerialanalysisdetailVO.setMaterialWasteRateMain(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) : null); // 合同约定主体用料损耗率
                    changematerialanalysisdetailVO.setMaterialWasteDecorate(StringUtils.isNotBlank(datas.get(14)) ? new BigDecimal(datas.get(14)) : null); // 装修用料损耗量
                    changematerialanalysisdetailVO.setMaterialDosageDecorate(StringUtils.isNotBlank(datas.get(15)) ? new BigDecimal(datas.get(15)) : null); // 装修材料用量
                    changematerialanalysisdetailVO.setSubtotal(StringUtils.isNotBlank(datas.get(16)) ? new BigDecimal(datas.get(16)) : null); // 小计
                    changematerialanalysisdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(17)) ? datas.get(17) : null); // 备注
                    /*if(StringUtils.isEmpty(datas.get(0))) {
                        materialanalysisdetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(1))) {
                        materialanalysisdetailVO.setErrorMsg("名称不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(2))) {
                        materialanalysisdetailVO.setErrorMsg("单位不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(3))) {
                        materialanalysisdetailVO.setErrorMsg("投标工程量不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(4))) {
                        materialanalysisdetailVO.setErrorMsg("建筑面积(m²)不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(5))) {
                        materialanalysisdetailVO.setErrorMsg("投标指标不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(6))) {
                        materialanalysisdetailVO.setErrorMsg("(计划成本)限额设计指标不能为空！");
                        errorList.add(materialanalysisdetailVO);
                        continue;
                    }*/
                    successList.add(changematerialanalysisdetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportmaterialanalysisFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportmaterialanalysisFromDatabase(@RequestBody ChangematerialanalysisVO changematerialanalysisVO, HttpServletResponse response) {
        QueryWrapper<ChangematerialanalysisdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", changematerialanalysisVO.getId());
        queryWrapper.eq("dr", 0);
        List<ChangematerialanalysisdetailEntity> list = changematerialanalysisdetailService.list(queryWrapper);
        List<ChangematerialanalysisdetailVO> changematerialanalysisdetailVOList = BeanMapper.mapList(list, ChangematerialanalysisdetailVO.class);
        if (changematerialanalysisdetailVOList != null && changematerialanalysisdetailVOList.size() > 0) {
            for (int i = 0; i < changematerialanalysisdetailVOList.size(); i++) {
                ChangematerialanalysisdetailVO vo = changematerialanalysisdetailVOList.get(i);
                vo.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", changematerialanalysisdetailVOList);
        ExcelExport.getInstance().export("materialanalysisdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportmaterialanalysisFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportmaterialanalysisFromPage(@RequestBody List<ChangematerialanalysisdetailVO> list, HttpServletResponse response) {
        if (list != null) {
            for (int i = 0; i < list.size(); i++) {
                ChangematerialanalysisdetailVO changematerialanalysisdetailVO = list.get(i);
                changematerialanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialanalysisdetail-export.xlsx", beans, response);
    }

}
