package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ContrastanalysisEntity;
import com.ejianc.business.bedget.bean.QuotaanalysisEntity;
import com.ejianc.business.bedget.service.IContrastanalysisService;
import com.ejianc.business.bedget.service.IQuotaanalysisService;
import com.ejianc.business.change.bean.ChangeContrastanalysistEntity;
import com.ejianc.business.change.bean.ChangeQuotaanalysisEntity;
import com.ejianc.business.change.mapper.ChangeContrastanalysistEntiyMapper;
import com.ejianc.business.change.service.IChangeContrastanalysistService;
import com.ejianc.business.change.vo.ChangeContrastanalysistVO;
import com.ejianc.business.change.vo.ChangeQuotaanalysisVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;


/**
 * 对比分析变更表
 * 
 * @author generator
 * 
 */
@Service("changeContrastanalysistEntiyService")
public class ChangeContrastanalysistServiceImpl extends BaseServiceImpl<ChangeContrastanalysistEntiyMapper, ChangeContrastanalysistEntity> implements IChangeContrastanalysistService {

    @Autowired
    private IContrastanalysisService contrastanalysisService;
    @Override
    public CommonResponse<ChangeContrastanalysistVO> saveChange(ChangeContrastanalysistVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeContrastanalysistEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeContrastanalysistEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeContrastanalysistEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeContrastanalysistEntity> queryWrapper = new QueryWrapper<ChangeContrastanalysistEntity>();
        queryWrapper.eq("contrastanalysis_id", saveOrUpdateVO.getContrastanalysisId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeContrastanalysistEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangeContrastanalysistVO vo = BeanMapper.map(entity, ChangeContrastanalysistVO.class);
        vo.setContrastanalysisdetailEntities(saveOrUpdateVO.getContrastanalysisdetailEntities());
        vo.setRecordContrastanalysistList(saveOrUpdateVO.getRecordContrastanalysistList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            ContrastanalysisEntity contrastanalysisEntity = contrastanalysisService.selectById(vo.getContrastanalysisId());
            contrastanalysisEntity.setChangeState("2");//状态改为变更中
            contrastanalysisEntity.setChangeId(vo.getId());
            contrastanalysisService.saveOrUpdate(contrastanalysisEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
}
