/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.service.IMaterialanalysisdetailService;
import com.ejianc.business.bedget.vo.MaterialanalysisVO;
import com.ejianc.business.bedget.vo.MaterialanalysisdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"materialanalysisExport"})
public class ExeclMaterialanalysisController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialanalysisdetailService materialanalysisdetailService;

    @RequestMapping(value={"/downloadmaterialanalysis"})
    @ResponseBody
    public void downloadmaterialanalysis(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"materialanalysisdetail-import.xlsx", (String)"\u65bd\u5de5\u56fe\u9884\u7b97\u6750\u6599\u5206\u6790\u6e05\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportmaterialanalysis"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportmaterialanalysis(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MaterialanalysisdetailVO> successList = new ArrayList<MaterialanalysisdetailVO>();
        ArrayList errorList = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 3; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MaterialanalysisdetailVO materialanalysisdetailVO = new MaterialanalysisdetailVO();
                materialanalysisdetailVO.setId(IdWorker.getId());
                materialanalysisdetailVO.setSort((String)datas.get(0));
                materialanalysisdetailVO.setMaterialsName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                materialanalysisdetailVO.setSpec(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                materialanalysisdetailVO.setMeasuringUnit(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                materialanalysisdetailVO.setQuantitiesBase(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new BigDecimal((String)datas.get(4)) : null);
                materialanalysisdetailVO.setMaterialWasteRateBase(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                materialanalysisdetailVO.setMaterialWasteBase(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : null);
                materialanalysisdetailVO.setMaterialDosageBase(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : null);
                materialanalysisdetailVO.setQuantitiesMain(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                materialanalysisdetailVO.setMaterialWasteRateDecorate(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                materialanalysisdetailVO.setMaterialWasteMain(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null);
                materialanalysisdetailVO.setMaterialDosageMain(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : null);
                materialanalysisdetailVO.setQuantitiesDecorate(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? new BigDecimal((String)datas.get(12)) : null);
                materialanalysisdetailVO.setMaterialWasteRateMain(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13))) ? new BigDecimal((String)datas.get(13)) : null);
                materialanalysisdetailVO.setMaterialWasteDecorate(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14))) ? new BigDecimal((String)datas.get(14)) : null);
                materialanalysisdetailVO.setMaterialDosageDecorate(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15))) ? new BigDecimal((String)datas.get(15)) : null);
                materialanalysisdetailVO.setSubtotal(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(16))) ? new BigDecimal((String)datas.get(16)) : null);
                materialanalysisdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(17))) ? (String)datas.get(17) : null);
                successList.add(materialanalysisdetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportmaterialanalysisFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportmaterialanalysisFromDatabase(@RequestBody MaterialanalysisVO materialanalysisVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)materialanalysisVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.materialanalysisdetailService.list((Wrapper)queryWrapper);
        List materialanalysisdetailVOList = BeanMapper.mapList((Iterable)list, MaterialanalysisdetailVO.class);
        if (materialanalysisdetailVOList != null && materialanalysisdetailVOList.size() > 0) {
            for (int i = 0; i < materialanalysisdetailVOList.size(); ++i) {
                MaterialanalysisdetailVO materialanalysisdetailVO = (MaterialanalysisdetailVO)((Object)materialanalysisdetailVOList.get(i));
                materialanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", materialanalysisdetailVOList);
        ExcelExport.getInstance().export("materialanalysisdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportmaterialanalysisFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportmaterialanalysisFromPage(@RequestBody List<MaterialanalysisdetailVO> list, HttpServletResponse response) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                MaterialanalysisdetailVO materialanalysisdetailVO = list.get(i);
                materialanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List<MaterialanalysisdetailVO>> beans = new HashMap<String, List<MaterialanalysisdetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialanalysisdetail-export.xlsx", beans, response);
    }
}

