package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.*;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.vo.ConsdrawbudgettotaldetailVO;
import com.ejianc.business.bedget.vo.QuotasummarydetailVO;
import com.ejianc.business.record.bean.RecordconsdrawbudgettotalEntity;
import com.ejianc.business.record.bean.RecordestimatesummaryEntity;
import com.ejianc.business.record.service.IRecordconsdrawbudgettotalService;
import com.ejianc.business.record.service.IRecordestimatesummaryService;
import com.ejianc.business.record.vo.RecordconsdrawbudgettotalVO;
import com.ejianc.business.record.vo.RecordestimatesummaryVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.service.IConsdrawbudgettotalService;
import com.ejianc.business.bedget.vo.ConsdrawbudgettotalVO;

/**
 * 施工预算图汇总表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("consdrawtotal")
public class ConsdrawbudgettotalController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanage-consdrawbudget-total";//此处需要根据实际修改

    @Autowired
    private IConsdrawbudgettotalService service;
    @Autowired
    private IConsdrawbudgetService consdrawbudgetService;
    @Autowired
    private IConsdrawbudgetdetailService consdrawbudgetdetailService;

    @Autowired
    private IRecordconsdrawbudgettotalService recordconsdrawbudgettotalService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConsdrawbudgettotalVO> saveOrUpdate(@RequestBody ConsdrawbudgettotalVO saveorUpdateVO) {
    	ConsdrawbudgettotalEntity entity = BeanMapper.map(saveorUpdateVO, ConsdrawbudgettotalEntity.class);
        QueryWrapper<ConsdrawbudgettotalEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        List<ConsdrawbudgettotalEntity> pro = service.list(queryWrapper);
        if(pro.size() > 0){
            throw new BusinessException("该项目已经创建一个施工预算图汇总，不允许重复创建!");
        }
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setChangeState("1");//未变
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ConsdrawbudgettotalVO vo = BeanMapper.map(entity, ConsdrawbudgettotalVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConsdrawbudgettotalVO> queryDetail(Long id) {
    	ConsdrawbudgettotalEntity entity = service.selectById(id);
    	ConsdrawbudgettotalVO vo = BeanMapper.map(entity, ConsdrawbudgettotalVO.class);
        if(!"1".equals(vo.getChangeState())){
            QueryWrapper<RecordconsdrawbudgettotalEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("consdrawbudgettotal_id", vo.getId());
            List<RecordconsdrawbudgettotalEntity> records = recordconsdrawbudgettotalService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                 vo.setRecordconsdrawbudgettotalVOS(BeanMapper.mapList(records, RecordconsdrawbudgettotalVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConsdrawbudgettotalVO> vos) {
        service.removeByIds(vos.stream().map(ConsdrawbudgettotalVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConsdrawbudgettotalVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ConsdrawbudgettotalEntity> page = service.queryPage(param,false);
        IPage<ConsdrawbudgettotalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConsdrawbudgettotalVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ConsdrawbudgettotalEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Consdrawbudgettotal-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refConsdrawbudgettotalData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConsdrawbudgettotalVO>> refConsdrawbudgettotalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ConsdrawbudgettotalEntity> page = service.queryPage(param,false);
        IPage<ConsdrawbudgettotalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConsdrawbudgettotalVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryDetail 查询详情
     * @param projectId
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ConsdrawbudgettotaldetailVO>> queryDetailList(Long projectId) {
        List<ConsdrawbudgettotaldetailVO> vo = new ArrayList<>();
        //根据项目id查询限施工图预算表id
        QueryWrapper<ConsdrawbudgetEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id",projectId);
        queryWrapper.eq("dr", 0);
        ConsdrawbudgetEntity entity = consdrawbudgetService.getOne(queryWrapper);
        if(entity == null){
            throw  new BusinessException("您选择的项目没有施工图预算,请选择别的项目!");
        }else{
            //根据主表id和tpid为空 查询子表第一层数据
            QueryWrapper<ConsdrawbudgetdetailEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("mid",entity.getId());
            queryWrapper1.eq("dr", 0);
            queryWrapper1.eq("tpid", "");
            int sort = 0;
            List<ConsdrawbudgetdetailEntity> list = consdrawbudgetdetailService.list(queryWrapper1);
            if(list == null){
                throw  new BusinessException("您选择的项目没有清单,请选择别的项目!");
            }else{
                for(ConsdrawbudgetdetailEntity consdrawbudgetdetailEntity : list){
                    sort += 1;
                    //循环将第一层数据的值赋值给清单
                    ConsdrawbudgettotaldetailVO consdrawbudgettotaldetailVO = new ConsdrawbudgettotaldetailVO();
                    consdrawbudgettotaldetailVO.setSort(String.valueOf(sort));
                    consdrawbudgettotaldetailVO.setCode(consdrawbudgetdetailEntity.getSubitemCode());
                    consdrawbudgettotaldetailVO.setSection(consdrawbudgetdetailEntity.getSection());
                    consdrawbudgettotaldetailVO.setProjectUnitName(consdrawbudgetdetailEntity.getSubitemName());
                    consdrawbudgettotaldetailVO.setUnitLaborCost(consdrawbudgetdetailEntity.getTotalLaborCost());
                    consdrawbudgettotaldetailVO.setUnitMaterialCost(consdrawbudgetdetailEntity.getTotalMaterialCost());
                    consdrawbudgettotaldetailVO.setUnitMachineryCost(consdrawbudgetdetailEntity.getTotalMachineryCost());
                    consdrawbudgettotaldetailVO.setUnitBusinessManagerCost(consdrawbudgetdetailEntity.getTotalBusinessManagerCost());
                    consdrawbudgettotaldetailVO.setUnitProfit(consdrawbudgetdetailEntity.getTotalProfit());
                    consdrawbudgettotaldetailVO.setItemsSubTotal(consdrawbudgetdetailEntity.getSumTotalPrice());
                    consdrawbudgettotaldetailVO.setFees(consdrawbudgetdetailEntity.getSocialSecurity().add(consdrawbudgetdetailEntity.getHousing())
                            .add(consdrawbudgetdetailEntity.getReserved1()).add(consdrawbudgetdetailEntity.getReserved2())
                            .add(consdrawbudgetdetailEntity.getReserved3()));
                    consdrawbudgettotaldetailVO.setTax(consdrawbudgetdetailEntity.getTax());
                    consdrawbudgettotaldetailVO.setTid(consdrawbudgetdetailEntity.getTid());
                    consdrawbudgettotaldetailVO.setTpid(consdrawbudgetdetailEntity.getTpid());
                    consdrawbudgettotaldetailVO.setRowState("add");
                    //根据主表id和第一层数据的父id查询第二层数据
                    QueryWrapper<ConsdrawbudgetdetailEntity> queryWrapper2 = new QueryWrapper<>();
                    queryWrapper2.eq("mid",entity.getId());
                    queryWrapper2.eq("dr", 0);
                    queryWrapper2.eq("tpid", consdrawbudgetdetailEntity.getTid());
                    List<ConsdrawbudgetdetailEntity> list1 = consdrawbudgetdetailService.list(queryWrapper2);
                    if(list1 != null){
                        int sortItem = 0;
                        for(ConsdrawbudgetdetailEntity  consdrawbudgetdetailEntity1: list1){
                            sortItem += 1;
                            List<ConsdrawbudgettotaldetailVO> consdrawbudgettotaldetailVOs = new ArrayList<>();
                            ConsdrawbudgettotaldetailVO consdrawbudgettotaldetailVO1 = new ConsdrawbudgettotaldetailVO();
                            consdrawbudgettotaldetailVO1.setSort(sort + "." + sortItem);
                            consdrawbudgettotaldetailVO1.setProjectUnitName(consdrawbudgetdetailEntity1.getSubitemName());
                            consdrawbudgettotaldetailVO1.setUnitLaborCost(consdrawbudgetdetailEntity1.getTotalLaborCost());
                            consdrawbudgettotaldetailVO1.setUnitMaterialCost(consdrawbudgetdetailEntity1.getTotalMaterialCost());
                            consdrawbudgettotaldetailVO1.setUnitMachineryCost(consdrawbudgetdetailEntity1.getTotalMachineryCost());
                            consdrawbudgettotaldetailVO1.setUnitBusinessManagerCost(consdrawbudgetdetailEntity1.getTotalBusinessManagerCost());
                            consdrawbudgettotaldetailVO1.setUnitProfit(consdrawbudgetdetailEntity1.getTotalProfit());
                            consdrawbudgettotaldetailVO1.setItemsSubTotal(consdrawbudgetdetailEntity1.getComprehensiveTotalPrice());
                            consdrawbudgettotaldetailVO1.setFees(consdrawbudgetdetailEntity1.getSocialSecurity().add(consdrawbudgetdetailEntity1.getHousing())
                                    .add(consdrawbudgetdetailEntity1.getReserved1()).add(consdrawbudgetdetailEntity1.getReserved2())
                                    .add(consdrawbudgetdetailEntity1.getReserved3()));
                            consdrawbudgettotaldetailVO1.setTax(consdrawbudgetdetailEntity1.getTax());
                            consdrawbudgettotaldetailVO1.setTid(consdrawbudgetdetailEntity1.getTid());
                            consdrawbudgettotaldetailVO1.setTpid(consdrawbudgetdetailEntity1.getTpid());
                            consdrawbudgettotaldetailVO1.setRowState("add");
                            consdrawbudgettotaldetailVOs.add(consdrawbudgettotaldetailVO1);
                            //将第二层数据添加到第一层数据下
                            consdrawbudgettotaldetailVO.setChildren(consdrawbudgettotaldetailVOs);
                        }
                    }
                    vo.add(consdrawbudgettotaldetailVO);
                }
            }
        }

        return CommonResponse.success(vo);

    }


}
