package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.MaterialrequirementsEntity;
import com.ejianc.business.bedget.bean.SubpackageEntity;
import com.ejianc.business.bedget.service.IMaterialrequirementsService;
import com.ejianc.business.record.bean.RecordmaterialanalysisEntity;
import com.ejianc.business.record.bean.RecordsubpackagematerialanalysisEntity;
import com.ejianc.business.record.service.IRecordsubpackagematerialanalysisService;
import com.ejianc.business.record.vo.RecordmaterialanalysisVO;
import com.ejianc.business.record.vo.RecordsubpackagematerialanalysisVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.bean.SubpackagematerialanalysisEntity;
import com.ejianc.business.bedget.service.ISubpackagematerialanalysisService;
import com.ejianc.business.bedget.vo.SubpackagematerialanalysisVO;

/**
 * 分包施工图预算材料分析
 *
 * @author generator
 */
@Controller
@RequestMapping("subpackagematerialanalysis")
public class SubpackagematerialanalysisController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanager-subpackagematerialanalysis";//此处需要根据实际修改

    @Autowired
    private ISubpackagematerialanalysisService service;
    @Autowired
    private IMaterialrequirementsService materialrequirementsService;//需求总计划service

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubpackagematerialanalysisVO> saveOrUpdate(@RequestBody SubpackagematerialanalysisVO saveorUpdateVO) {
        SubpackagematerialanalysisEntity entity = BeanMapper.map(saveorUpdateVO, SubpackagematerialanalysisEntity.class);

        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        /**
         * 查询当前项目对应的物资需求总计划
         * 当前项目下的分包材料预算总和不得超过需求总计划合计汇总数量
         */
        QueryWrapper<MaterialrequirementsEntity> queryWrapper1 = new QueryWrapper<>();
        //查询当前项目下已提交、审批中、审批通过的分包材料预算
        queryWrapper1.eq("project_id", entity.getProjectId());
        queryWrapper1.eq("dr", "0");
        List<MaterialrequirementsEntity> materialrequirementsEntityList = materialrequirementsService.list(queryWrapper1);
        if (materialrequirementsEntityList.size() == 0) {
            throw new BusinessException("当前项目未创建物资需求总计划！");
        } else {
            //获取当前物资需求总计划
            MaterialrequirementsEntity materialrequirementsEntity = materialrequirementsEntityList.get(0);
            //需求总计划合计数量
            Double total = materialrequirementsEntity.getTotal();
            //当前数量
            Double totals = entity.getTotal();
            //查询当前项目其他分包材料预算数量
            QueryWrapper<SubpackagematerialanalysisEntity> queryWrapper2 = new QueryWrapper<>();
            queryWrapper2.eq("project_id", entity.getProjectId());
            queryWrapper2.eq("dr", "0");
            queryWrapper2.ne("id", entity.getId());
            List<SubpackagematerialanalysisEntity> pro3 = service.list(queryWrapper2);
            for (SubpackagematerialanalysisEntity subpackagematerialanalysisEntity : pro3) {
                totals += subpackagematerialanalysisEntity.getTotal();
            }
            if (totals > total) {
                throw new BusinessException("已超出需求总计划数量，请检查！");
            }
        }
        service.saveOrUpdate(entity, false);
        SubpackagematerialanalysisVO vo = BeanMapper.map(entity, SubpackagematerialanalysisVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Autowired
    private IRecordsubpackagematerialanalysisService recordsubpackagematerialanalysisService;

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubpackagematerialanalysisVO> queryDetail(Long id) {
        SubpackagematerialanalysisEntity entity = service.selectById(id);
        SubpackagematerialanalysisVO vo = BeanMapper.map(entity, SubpackagematerialanalysisVO.class);
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper<RecordsubpackagematerialanalysisEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", vo.getId());
            List<RecordsubpackagematerialanalysisEntity> records = recordsubpackagematerialanalysisService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordsubpackagematerialanalysisVOS(BeanMapper.mapList(records, RecordsubpackagematerialanalysisVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubpackagematerialanalysisVO> vos) {
        service.removeByIds(vos.stream().map(SubpackagematerialanalysisVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubpackagematerialanalysisVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SubpackagematerialanalysisEntity> page = service.queryPage(param, false);
        IPage<SubpackagematerialanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubpackagematerialanalysisVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubpackagematerialanalysisEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Subpackagematerialanalysis-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubpackagematerialanalysisData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubpackagematerialanalysisVO>> refSubpackagematerialanalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                                 String condition,
                                                                                                 String searchObject,
                                                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubpackagematerialanalysisEntity> page = service.queryPage(param, false);
        IPage<SubpackagematerialanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubpackagematerialanalysisVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
