package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.SubpackageEntity;
import com.ejianc.business.bedget.bean.SubpackagedetailEntity;
import com.ejianc.business.bedget.bean.SubpackagematerialanalysisEntity;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.business.bedget.service.ISubpackagedetailService;
import com.ejianc.business.bedget.vo.SubpackagedetailVO;
import com.ejianc.business.record.bean.RecordsubpackageEntity;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.bean.SubpackagetotalEntity;
import com.ejianc.business.bedget.service.ISubpackagetotalService;
import com.ejianc.business.bedget.vo.SubpackagetotalVO;

/**
 * 分包施工图预算汇总
 *
 * @author generator
 */
@Controller
@RequestMapping("subpackagetotal")
public class SubpackagetotalController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanager-subpackagetotal";//此处需要根据实际修改

    @Autowired
    private ISubpackagetotalService service;
    @Autowired
    private ISubpackageService subpackageService;
    @Autowired
    private ISubpackagedetailService subpackagedetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubpackagetotalVO> saveOrUpdate(@RequestBody SubpackagetotalVO saveorUpdateVO) {
        SubpackagetotalEntity entity = BeanMapper.map(saveorUpdateVO, SubpackagetotalEntity.class);
        QueryWrapper<SubpackagetotalEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", entity.getProjectId());
        queryWrapper.eq("dr", "0");
        List<SubpackagetotalEntity> pro = service.list(queryWrapper);
        if (pro.size() > 0) {
            throw new BusinessException("该项目已经创建一个分包施工图预算汇总，不允许重复创建!");
        }
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        SubpackagetotalVO vo = BeanMapper.map(entity, SubpackagetotalVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubpackagetotalVO> queryDetail(Long id) {
        SubpackagetotalEntity entity = service.selectById(id);
        SubpackagetotalVO vo = BeanMapper.map(entity, SubpackagetotalVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubpackagetotalVO> vos) {
        service.removeByIds(vos.stream().map(SubpackagetotalVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubpackagetotalVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SubpackagetotalEntity> page = service.queryPage(param, false);
        IPage<SubpackagetotalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubpackagetotalVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubpackagetotalEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Subpackagetotal-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubpackagetotalData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubpackagetotalVO>> refSubpackagetotalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubpackagetotalEntity> page = service.queryPage(param, false);
        IPage<SubpackagetotalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubpackagetotalVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @Description 根据项目id 查询分包施工图预算子表信息
     */
    @RequestMapping(value = "/selectList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SubpackagetotalVO>> selectList(Long projectid, Long contract) {
        List<SubpackagetotalVO> vo = new ArrayList<>();
        QueryWrapper<SubpackageEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        if (projectid != null) {
            queryWrapper.eq("project_id", projectid);
        }

        if (contract != null) {
            queryWrapper.eq("contract", contract);
        }

        List<SubpackageEntity> records = subpackageService.list(queryWrapper);
        for (SubpackageEntity entity : records) {
            QueryWrapper<SubpackagedetailEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("dr", 0);
            queryWrapper1.eq("mid", entity.getId());
            List<SubpackagedetailEntity> records1 = subpackagedetailService.list(queryWrapper1);
            for (SubpackagedetailEntity entity1 : records1) {
                SubpackagetotalVO subpackagetotalVO = new SubpackagetotalVO();
                subpackagetotalVO.setSubtitleCode(entity1.getSubtitleCode());
                subpackagetotalVO.setSubtitleName(entity1.getSubtitleName());
                subpackagetotalVO.setSubtitleFeature(entity1.getSubtitleFeature());
                subpackagetotalVO.setArtificialTotal(entity1.getArtificialTotal());
                subpackagetotalVO.setMaterialsTotal(entity1.getMaterialsTotal());
                subpackagetotalVO.setMechanicalTotal(entity1.getMechanicalTotal());
                subpackagetotalVO.setEnterpriseManageTotal(entity1.getEnterpriseManageTotal());
                subpackagetotalVO.setProfitsTotal(entity1.getProfitsTotal());
                subpackagetotalVO.setFeesTotal(entity1.getFeesTotal());
                subpackagetotalVO.setTaxTotal(entity1.getTaxTotal());
                subpackagetotalVO.setComprehensiveTotal(entity1.getComprehensiveTotal());
                subpackagetotalVO.setExcludingTaxTotal(entity1.getExcludingTaxTotal());
                subpackagetotalVO.setIncludingTaxTotal(entity1.getIncludingTaxTotal());
                vo.add(subpackagetotalVO);
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param
     * @Description 自动任务执行--每月1号00：00：00执行，保存当前数据快照
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveSnapshotData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> saveSnapshotData() {
        return service.saveSnapshotData();
    }

    /**
     * @Description saveOrUpdate 手动保存当前的数据到es
     */
    @RequestMapping(value = "/saveESData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> saveESData() {
        SimpleDateFormat format1 = new SimpleDateFormat("YYYY-MM-dd hh:mm:ss");
        String curDate = format1.format(new Date());
        return service.saveESData("劳务分包预算汇总（手动）" + curDate);
    }

    @RequestMapping(value = "/queryReportList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubpackagetotalVO>> queryReportList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        return CommonResponse.success(service.queryEsByPage(param));
    }


    /**
     * @param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/esExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse esExcelExport(HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
       /* List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);*/
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        /*param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));*/
        QueryParam param = new QueryParam();
        IPage<SubpackagetotalVO> page = service.queryEsByPage(param);
        //todo:字段翻译等等
        List<SubpackagetotalVO> list = new ArrayList<>();
        for (int i = 0; i < page.getRecords().size() ; i++) {
            SubpackagetotalVO vo = page.getRecords().get(i);
            vo.setSort(String.valueOf(i+1));
            list.add(vo);
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Subpackagetotal-export.xlsx", beans, response);
        return CommonResponse.success();
    }

    /**
     * 查询所有的ES快照版本
     */
    @RequestMapping(value = "/queryEsSnap", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse queryEsSnap() {
        List<String> list = service.queryEsSnap();
        return CommonResponse.success(list);
    }


    /**
     * @param projectId
     * @Description 查询往期
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubpackagetotalVO> pastData(Long projectId, Date deadline) {
        Date deadlineRes = deadline;

        if (deadline == null) {
            deadlineRes = new Date(System.currentTimeMillis());
        }

        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(projectId, deadlineRes));
    }

    @RequestMapping(value = "/selectEsList", method = RequestMethod.GET)
    @ResponseBody
    public  IPage<SubpackagetotalVO> selectEsList(String projectId, String contract) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectId");
        fuzzyFields.add("contract");
        param.setSearchText(contract);
        IPage<SubpackagetotalVO> subpackagetotalVOIPage = service.queryEsByPage(param);
        return subpackagetotalVOIPage;
    }

    private SubpackagetotalVO getPastTotalData(Long projectId, Date deadlineRes) {
        return new SubpackagetotalVO();
    }


}
