package com.ejianc.business.bedget.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.vo.ConsdrawbudgetVO;
import com.ejianc.business.bedget.vo.ConsdrawbudgetdetailVO;
import com.ejianc.business.bedget.vo.QuotadesigndetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 施工图预算清单导入导出
 */
@Controller
@RequestMapping("consdrawbudgetExport")
public class ExeclConsdrawbudgetController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IConsdrawbudgetdetailService consdrawbudgetdetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadConsdrawbudget")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "consdrawbudgetdetail-import.xlsx", "施工图预算清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportConsdrawbudget", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ConsdrawbudgetdetailVO> successList = new ArrayList<>();
        List<ConsdrawbudgetdetailVO> errorList = new ArrayList<>();
        Map<String, ConsdrawbudgetdetailVO> map = new HashMap<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 2; i < result.size(); i++) {
                    List<String> datas = result.get(i);

                    String subitemCode = datas.get(0);
                    String section = datas.get(1);
                    String subitemName = datas.get(2);

                    String engineeQuatity = datas.get(5);
                    String unitLaborCost = datas.get(6);
                    String unitmaterialCost = datas.get(7);
                    String unitMachineryCost = datas.get(8);
                    String unitBusinessManagerCost = datas.get(9);
                    String unitProfit = datas.get(10);
                    String comprehensiveUnitPrice = datas.get(11);
                    String totalLaborCost = datas.get(12);
                    String totalMaterialCost = datas.get(13);
                    String totalMachineryCost = datas.get(14);
                    String totalBusinessManagerCost = datas.get(15);
                    String totalProfit = datas.get(16);
                    String sumTotalPrice = datas.get(17);
                    String socialSecurity = datas.get(18);
                    String housing = datas.get(19);
                    String reserved1 = datas.get(20);
                    String reserved2 = datas.get(21);
                    String reserved3 = datas.get(22);
                    String tax = datas.get(23);
                    String provisionalEstimate = datas.get(24);

                    ConsdrawbudgetdetailVO consdrawbudgetdetailVO = new ConsdrawbudgetdetailVO();
                    consdrawbudgetdetailVO.setId(IdWorker.getId());//id
                    consdrawbudgetdetailVO.setTid(String.valueOf(IdWorker.getId()));//tid

                    consdrawbudgetdetailVO.setSubitemCode(StringUtils.isNotBlank(subitemCode) ? subitemCode : null); // 子目编码
                    consdrawbudgetdetailVO.setSection(StringUtils.isNotBlank(section) ? section : null); // 区段
                    consdrawbudgetdetailVO.setSubitemName(StringUtils.isNotBlank(subitemName) ? subitemName : null); // 子目名称
                    consdrawbudgetdetailVO.setCharacterDescrip(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 子目特征描述
                    consdrawbudgetdetailVO.setEstimateUnit(StringUtils.isNotBlank(datas.get(4)) ? datas.get(4) : null); // 计量单位

                    //必填项校验
                    if (subitemCode == null || TextUtils.isEmpty(subitemCode)) {
                        consdrawbudgetdetailVO.setErrorMsg("子目编码不能为空！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }
                    if (section == null || TextUtils.isEmpty(section)) {
                        consdrawbudgetdetailVO.setErrorMsg("区段不能为空！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }
                    if (subitemName == null || TextUtils.isEmpty(subitemName)) {
                        consdrawbudgetdetailVO.setErrorMsg("子目名称不能为空！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }

                    consdrawbudgetdetailVO.setInnercode(subitemCode + "_" + section);//子目编码、区段、确定唯一性
                    if ("01".equals(subitemCode) && subitemName.contains("装饰")) {
                        consdrawbudgetdetailVO.setInnercode("a1" + "_" + consdrawbudgetdetailVO.getSection());
                    }
                    //判断是否是装饰工程的子节点编码
                    if (subitemCode.length() >= 4) {
                        //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
                        String code = subitemCode.substring(0, 4);
                        if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
	    		            //若是的话，将内码改为a1xx
                            consdrawbudgetdetailVO.setInnercode("a1" + subitemCode.substring(2, subitemCode.length()) + "_" + section);
                        }
                    }
                    //1、校验编码是否符合规则--2、4、6、9、9以上
                    if (subitemCode == null || !(subitemCode.length() == 2 || subitemCode.length() == 4 || subitemCode.length() == 6 || subitemCode.length() >= 9)) {
                        consdrawbudgetdetailVO.setErrorMsg("子目编码必须符合：2位、4位、6位、9位或9位以上中任意一规则");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }

                    //重复性校验
                    ConsdrawbudgetdetailVO mapVO = map.get(consdrawbudgetdetailVO.getInnercode());
                    if(mapVO == null){
                        map.put(consdrawbudgetdetailVO.getInnercode(), consdrawbudgetdetailVO);
                    }else {
                        consdrawbudgetdetailVO.setErrorMsg("子目编码已存在");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }

                    //设置父级id
                    String innercode = consdrawbudgetdetailVO.getInnercode();
                    String[] innercodeSubArr = innercode.split("_");
                    String innercodeSub = "";
                    String sectionSuf = "";
                    if (innercodeSubArr.length > 1) {
                        innercodeSub = innercodeSubArr[0];
                        sectionSuf = "_" + innercodeSubArr[1];
                    }

                    Long pid = null;
                    if (innercodeSub.length() == 2) {
                        //最上级
                    } else if (innercodeSub.length() == 4) {
                        String pcode = innercodeSub.substring(0, 2) + sectionSuf;
                        //有父节点
                        pid = this.setPid(pcode, map);
                    } else if (innercodeSub.length() == 6) {
                        String pcode = innercodeSub.substring(0, 4) + sectionSuf;
                        //有父节点
                        pid = this.setPid(pcode, map);
                    } else if (innercodeSub.length() > 6) {
                        String pcode = innercodeSub.substring(0, 6) + sectionSuf;
                        //有父节点
                        pid = this.setPid(pcode, map);
                    }

                    if (pid != null) {
                        consdrawbudgetdetailVO.setTpid(pid.toString());
                    } else {
                        consdrawbudgetdetailVO.setTpid("");
                    }

                    //格式校验
                    if(!TextUtils.isEmpty(engineeQuatity) && !NumberUtil.isNumber(engineeQuatity)){
                        consdrawbudgetdetailVO.setErrorMsg("工程量格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setEngineeQuatity(StringUtils.isNotBlank(engineeQuatity) ? new BigDecimal(engineeQuatity) : null); // 工程量
                    }

                    if(!TextUtils.isEmpty(unitLaborCost) && !NumberUtil.isNumber(unitLaborCost)){
                        consdrawbudgetdetailVO.setErrorMsg("人工费（单价）格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setUnitLaborCost(StringUtils.isNotBlank(unitLaborCost) ? new BigDecimal(unitLaborCost) : null); // 人工费(单价)
                    }

                    if(!TextUtils.isEmpty(unitmaterialCost) && !NumberUtil.isNumber(unitmaterialCost)){
                        consdrawbudgetdetailVO.setErrorMsg("材料费（单价）格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setUnitMaterialCost(StringUtils.isNotBlank(unitmaterialCost) ? new BigDecimal(unitmaterialCost) : null); // 材料费(单价)
                    }

                    if(!TextUtils.isEmpty(unitMachineryCost) && !NumberUtil.isNumber(unitMachineryCost)){
                        consdrawbudgetdetailVO.setErrorMsg("机械费（单价）格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setUnitMachineryCost(StringUtils.isNotBlank(unitMachineryCost) ? new BigDecimal(unitMachineryCost) : null); // 机械费(单价)
                    }

                    if(!TextUtils.isEmpty(unitBusinessManagerCost) && !NumberUtil.isNumber(unitBusinessManagerCost)){
                        consdrawbudgetdetailVO.setErrorMsg("企业管理费（单价）格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setUnitBusinessManagerCost(StringUtils.isNotBlank(unitBusinessManagerCost) ? new BigDecimal(unitBusinessManagerCost) : null); // 企业管理费(单价)
                    }

                    if(!TextUtils.isEmpty(unitProfit) && !NumberUtil.isNumber(unitProfit)){
                        consdrawbudgetdetailVO.setErrorMsg("利润（单价）格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setUnitProfit(StringUtils.isNotBlank(unitProfit) ? new BigDecimal(unitProfit) : null); // 利润(单价)
                    }

                    if(!TextUtils.isEmpty(comprehensiveUnitPrice) && !NumberUtil.isNumber(comprehensiveUnitPrice)){
                        consdrawbudgetdetailVO.setErrorMsg("综合单价格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setComprehensiveUnitPrice(StringUtils.isNotBlank(comprehensiveUnitPrice) ? new BigDecimal(comprehensiveUnitPrice) : null); // 综合单价
                    }
                    if(!TextUtils.isEmpty(totalLaborCost) && !NumberUtil.isNumber(totalLaborCost)){
                        consdrawbudgetdetailVO.setErrorMsg("人工费（合价）格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setTotalLaborCost(StringUtils.isNotBlank(totalLaborCost) ? new BigDecimal(totalLaborCost) : null); // 人工费(综合)
                    }
                    if(!TextUtils.isEmpty(totalMaterialCost) && !NumberUtil.isNumber(totalMaterialCost)){
                        consdrawbudgetdetailVO.setErrorMsg("材料费（合价）格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setTotalMaterialCost(StringUtils.isNotBlank(totalMaterialCost) ? new BigDecimal(totalMaterialCost) : null); // 材料费(综合)
                    }

                    if(!TextUtils.isEmpty(totalMachineryCost) && !NumberUtil.isNumber(totalMachineryCost)){
                        consdrawbudgetdetailVO.setErrorMsg("机械费（合价）格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setTotalMachineryCost(StringUtils.isNotBlank(totalMachineryCost) ? new BigDecimal(totalMachineryCost) : null); // 机械费(综合)
                    }

                    if(!TextUtils.isEmpty(totalBusinessManagerCost) && !NumberUtil.isNumber(totalBusinessManagerCost)){
                        consdrawbudgetdetailVO.setErrorMsg("企业管理费（合价）格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setTotalBusinessManagerCost(StringUtils.isNotBlank(totalBusinessManagerCost) ? new BigDecimal(totalBusinessManagerCost) : null); // 企业管理费(综合)
                    }

                    if(!TextUtils.isEmpty(totalProfit) && !NumberUtil.isNumber(totalProfit)){
                        consdrawbudgetdetailVO.setErrorMsg("利润（合价）格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setTotalProfit(StringUtils.isNotBlank(datas.get(17)) ? new BigDecimal(datas.get(17)) : null); // 利润(综合)
                    }

                    if(!TextUtils.isEmpty(sumTotalPrice) && !NumberUtil.isNumber(sumTotalPrice)){
                        consdrawbudgetdetailVO.setErrorMsg("合价格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setSumTotalPrice(StringUtils.isNotBlank(sumTotalPrice) ? new BigDecimal(sumTotalPrice) : null); // 合价
                    }

                    if(!TextUtils.isEmpty(socialSecurity) && !NumberUtil.isNumber(socialSecurity)){
                        consdrawbudgetdetailVO.setErrorMsg("社保格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setSocialSecurity(StringUtils.isNotBlank(socialSecurity) ? new BigDecimal(socialSecurity) : null); // 社保
                    }

                    if(!TextUtils.isEmpty(housing) && !NumberUtil.isNumber(housing)){
                        consdrawbudgetdetailVO.setErrorMsg("住房格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setHousing(StringUtils.isNotBlank(housing) ? new BigDecimal(housing) : null); // 住房
                    }

                    if(!TextUtils.isEmpty(reserved1) && !NumberUtil.isNumber(reserved1)){
                        consdrawbudgetdetailVO.setErrorMsg("预留1格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setReserved1(StringUtils.isNotBlank(reserved1) ? new BigDecimal(reserved1) : null); // 预留1
                    }

                    if(!TextUtils.isEmpty(reserved2) && !NumberUtil.isNumber(reserved2)){
                        consdrawbudgetdetailVO.setErrorMsg("预留2格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setReserved2(StringUtils.isNotBlank(reserved2) ? new BigDecimal(reserved2) : null); // 预留2
                    }

                    if(!TextUtils.isEmpty(reserved3) && !NumberUtil.isNumber(reserved3)){
                        consdrawbudgetdetailVO.setErrorMsg("预留3格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setReserved3(StringUtils.isNotBlank(reserved3) ? new BigDecimal(reserved3) : null); // 预留3
                    }

                    if(!TextUtils.isEmpty(tax) && !NumberUtil.isNumber(tax)){
                        consdrawbudgetdetailVO.setErrorMsg("税金格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setTax(StringUtils.isNotBlank(tax) ? new BigDecimal(tax) : null); // 税金
                    }

                    if(!TextUtils.isEmpty(provisionalEstimate) && !NumberUtil.isNumber(provisionalEstimate)){
                        consdrawbudgetdetailVO.setErrorMsg("暂估价格式不正确！");
                        errorList.add(consdrawbudgetdetailVO);
                        continue;
                    }else {
                        consdrawbudgetdetailVO.setProvisionalEstimate(StringUtils.isNotBlank(provisionalEstimate) ? new BigDecimal(provisionalEstimate) : null); // 暂估价
                    }
                    
                    successList.add(consdrawbudgetdetailVO);
                }
            }
        }
        //按子目编码排序
        Collections.sort(successList, new Comparator<ConsdrawbudgetdetailVO>() {
            @Override
            public int compare(ConsdrawbudgetdetailVO o1, ConsdrawbudgetdetailVO o2) {
                return (o1.getSubitemCode()+o1.getSection()).compareTo(o2.getSubitemCode()+o2.getSection());
            }
        });

        //构建树
        List<ConsdrawbudgetdetailVO> resList = createTreeData(successList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        ConsdrawbudgetVO resVo = new ConsdrawbudgetVO();
        json.put("total", getTotalAmount(resList, resVo));

        return CommonResponse.success(json);
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<ConsdrawbudgetdetailVO> createTreeData(List<ConsdrawbudgetdetailVO> list) {
        List<ConsdrawbudgetdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ConsdrawbudgetdetailVO> listMap = new HashMap<>();
        for (ConsdrawbudgetdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ConsdrawbudgetdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ConsdrawbudgetdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ConsdrawbudgetdetailVO> child = (List<ConsdrawbudgetdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ConsdrawbudgetdetailVO> children = new ArrayList<ConsdrawbudgetdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    private ConsdrawbudgetVO getTotalAmount(List<ConsdrawbudgetdetailVO> vos, ConsdrawbudgetVO resVo) {
        BigDecimal conDrawBudgetTotal = new BigDecimal(0);
        BigDecimal feesTotal = new BigDecimal(0);
        BigDecimal taxTotal = new BigDecimal(0);
        BigDecimal provisionalEstimateTotal = new BigDecimal(0);

        for (ConsdrawbudgetdetailVO vo : vos) {
            if (vo.getSumTotalPrice() != null) {
                conDrawBudgetTotal = conDrawBudgetTotal.add(vo.getSumTotalPrice());
            }

            if (vo.getTax() != null) {
                taxTotal = taxTotal.add(vo.getTax());
            }

            //规费合计
            if (vo.getSocialSecurity() != null) {
                feesTotal = feesTotal.add(vo.getSocialSecurity());
            }
            if (vo.getHousing() != null) {
                feesTotal = feesTotal.add(vo.getHousing());
            }
            if (vo.getReserved1() != null) {
                feesTotal = feesTotal.add(vo.getReserved1());
            }
            if (vo.getReserved2() != null) {
                feesTotal = feesTotal.add(vo.getReserved2());
            }
            if (vo.getReserved3() != null) {
                feesTotal = feesTotal.add(vo.getReserved3());
            }

            if (vo.getProvisionalEstimate() != null) {
                provisionalEstimateTotal = provisionalEstimateTotal.add(vo.getProvisionalEstimate());
            }
        }

        resVo.setConDrawBudgetTotal(conDrawBudgetTotal);
        resVo.setProvisionalEstimateTotal(provisionalEstimateTotal);
        resVo.setFeesTotal(feesTotal);
        resVo.setTaxTotal(taxTotal);
        return resVo;
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, ConsdrawbudgetdetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if (pcodeSubArr.length > 1) {
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportConsdrawbudgetFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody ConsdrawbudgetVO consdrawbudgetVO, HttpServletResponse response) {
        QueryWrapper<ConsdrawbudgetdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", consdrawbudgetVO.getId());
        queryWrapper.eq("dr", 0);
        queryWrapper.orderByAsc("subitem_code");
        queryWrapper.orderByAsc("section");
        List<ConsdrawbudgetdetailEntity> list = consdrawbudgetdetailService.list(queryWrapper);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("consdrawbudgetdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportConsdrawbudgetFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<ConsdrawbudgetdetailVO> list, HttpServletResponse response) {
        List<ConsdrawbudgetdetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                ConsdrawbudgetdetailVO consdrawbudgetdetailVO = list.get(i);
                concatList.add(consdrawbudgetdetailVO);
            }
        }

        //children拍平
        List<ConsdrawbudgetdetailVO> allList = handleList(list, concatList);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("consdrawbudgetdetail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<ConsdrawbudgetdetailVO> handleList(List<ConsdrawbudgetdetailVO> list, List<ConsdrawbudgetdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            ConsdrawbudgetdetailVO consdrawbudgetdetailVO = list.get(i);
            List<ConsdrawbudgetdetailVO> children = consdrawbudgetdetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
