package com.ejianc.business.bedget.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.SubpackageEntity;
import com.ejianc.business.bedget.bean.SubpackagedetailEntity;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.business.bedget.service.ISubpackagedetailService;
import com.ejianc.business.bedget.vo.SubpackagetotalVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bedget.mapper.SubpackagetotalMapper;
import com.ejianc.business.bedget.bean.SubpackagetotalEntity;
import com.ejianc.business.bedget.service.ISubpackagetotalService;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 分包施工图预算汇总
 * 
 * @author generator
 * 
 */
@Service("subpackagetotalService")
public class SubpackagetotalServiceImpl extends BaseServiceImpl<SubpackagetotalMapper, SubpackagetotalEntity> implements ISubpackagetotalService{

    //日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ISubpackagetotalService service;

    @Autowired
    private RestHighLevelClient client;

    @Autowired
    private ISubpackageService subpackageService;

    @Autowired
    private ISubpackagedetailService subpackagedetailService;


    private final static String ESSignStatistic = "ejc_budgetmanage_subpackagetotal";

    @Override
    public CommonResponse<String> saveSnapshotData() {
        String curDate = this.getLastMonth();
        //劳务分包汇总统计
        new Thread(() -> {
            try {
                service.saveESData("劳务分包预算汇总报表" + curDate);
            } catch (Exception e) {
                logger.error("劳务分包预算汇总报表数据异常，", e);
            }
        }).start();

        return CommonResponse.success("保存快照成功");
    }

    @Override
    public CommonResponse<String> saveESData(String reportName) {
        //构建es请求
        BulkRequest bulkRequest = new BulkRequest();
        long versionId = IdWorker.getId();
        SimpleDateFormat format1 = new SimpleDateFormat("YYYY-MM-dd hh:mm:ss");
        String curDate = format1.format(new Date());
        //获取当前mysql数据
        QueryWrapper queryParam = new QueryWrapper<>();
        queryParam.eq("dr",0);
        List<SubpackageEntity> list = subpackageService.list(queryParam);
        for (SubpackageEntity entity : list) {
            QueryWrapper<SubpackagedetailEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("dr",0);
            wrapper.eq("mid",entity.getId());
            List<SubpackagedetailEntity> subpackagedetailEntityList = subpackagedetailService.list();
            for (SubpackagedetailEntity subpackagedetailEntity : subpackagedetailEntityList) {
                try {
                    SubpackagetotalVO vo = BeanMapper.map(entity, SubpackagetotalVO.class);
                    Map<String, Object> dataMap = BeanMapper.map(vo, Map.class);
                    dataMap.put("reportId", subpackagedetailEntity.getId().toString());
                    dataMap.put("snapShotTime", curDate);
                    dataMap.put("snapShotVersion", versionId);
                    dataMap.put("projectid",entity.getProjectId());
                    dataMap.put("contract",entity.getContract());
                    dataMap.put("subtitleCode",subpackagedetailEntity.getSubtitleCode());
                    dataMap.put("subtitleName",subpackagedetailEntity.getSubtitleName());
                    dataMap.put("subtitleFeature",subpackagedetailEntity.getSubtitleFeature());
                    dataMap.put("artificialTotal",subpackagedetailEntity.getArtificialTotal());
                    dataMap.put("materialsTotal",subpackagedetailEntity.getMaterialsTotal());
                    dataMap.put("mechanicalTotal",subpackagedetailEntity.getMechanicalTotal());
                    dataMap.put("enterpriseManageTotal",subpackagedetailEntity.getEnterpriseManageTotal());
                    dataMap.put("profitsTotal",subpackagedetailEntity.getProfitsTotal());
                    dataMap.put("feesTotal",subpackagedetailEntity.getFeesTotal());
                    dataMap.put("taxTotal",subpackagedetailEntity.getTaxTotal());
                    dataMap.put("comprehensiveTotal",subpackagedetailEntity.getComprehensiveTotal());
                    dataMap.put("excludingTaxTotal",subpackagedetailEntity.getExcludingTaxTotal());
                    dataMap.put("includingTaxTotal",subpackagedetailEntity.getIncludingTaxTotal());

                    IndexRequest indexRequest = new IndexRequest(ESSignStatistic);
                    indexRequest.source(dataMap, XContentType.JSON);
                    bulkRequest.add(indexRequest);
                } catch (Exception e) {
                    logger.error("生成劳务分包预算汇总数据异常，", e);
                    throw new BusinessException("生成劳务分包预算汇总数据异常");
                }
            }
        }

        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            client.bulk(bulkRequest, RequestOptions.DEFAULT);
        } catch (IOException e) {
            logger.info("生成ES数据失败:---->" + e.getMessage());
            throw new BusinessException("生成ES数据失败:---->" + e.getMessage());
        }

        logger.info("***********生成劳务分包预算汇总---执行完成 *********** ");
        return CommonResponse.success("生成劳务分包预算汇总成功");
    }

    @Override
    public IPage<SubpackagetotalVO> queryEsByPage(QueryParam param) {
        // 搜索请求对象
        SearchRequest searchRequest = new SearchRequest(ESSignStatistic);
        // 指定类型
        searchRequest.searchType(SearchType.DEFAULT);

        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Integer pageIndex = param.getPageIndex();
        Integer pageSize = param.getPageSize();
        sourceBuilder.from(pageIndex <= 0 ? 0 : (pageIndex - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(60, TimeUnit.SECONDS)); //设置超时时间
        sourceBuilder.sort("snapShotTime", SortOrder.ASC); // 第二排序规则

        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        List<String> fields = param.getFuzzyFields();
        if (fields.size() > 0 && fields != null) {
            for (String field : fields) {
                boolBuilder.should(QueryBuilders.termQuery(field,param.getParams().get(field).getValue()));
               /* boolBuilder.must(QueryBuilders.matchPhrasePrefixQuery("snapShotVersion",param.getSearchText()));
                boolBuilder.must(QueryBuilders.matchPhrasePrefixQuery("contractName", param.getSearchText()));
                boolBuilder.must(QueryBuilders.matchPhrasePrefixQuery("billCode", param.getSearchText()));
                boolBuilder.must(QueryBuilders.matchPhrasePrefixQuery("projectId", param.getSearchText()));
                boolBuilder.must(QueryBuilders.matchPhrasePrefixQuery("projectid", param.getSearchText()));
                boolBuilder.must(QueryBuilders.matchPhrasePrefixQuery("projectName", param.getSearchText()));
                boolBuilder.must(QueryBuilders.matchPhrasePrefixQuery("subtitle_name", param.getSearchText()));
                boolBuilder.must(QueryBuilders.matchPhrasePrefixQuery("subtitle_feature", param.getSearchText()));
                boolBuilder.must(QueryBuilders.matchPhrasePrefixQuery("subtitle_code", param.getSearchText()));
                boolBuilder.must(QueryBuilders.matchPhrasePrefixQuery("contract", param.getSearchText()));
                boolBuilder.must(QueryBuilders.matchPhrasePrefixQuery("subtitle_code", param.getSearchText()));
                boolBuilder.must(QueryBuilders.matchPhrasePrefixQuery("version", param.getSearchText()));
*/
            }
            // 向搜索请求对象中设置搜索源
            searchRequest.source(sourceBuilder);
        }
        try {
            SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            // 搜索结果
            SearchHits hits = searchResponse.getHits();
            Integer count = 0;
            Integer idCount = 1;
            // 得到匹配度高的文档
            SearchHit[] searchHits = hits.getHits();
            if (searchHits.length <= 0) {
                return null;
            }
            Page<SubpackagetotalVO> voPage = new Page<>();
            ArrayList<SubpackagetotalVO> list = new ArrayList<>();
            for (SearchHit hit : searchHits) {
                idCount++;
                JSONObject json = new JSONObject(hit.getSourceAsMap());
                SubpackagetotalVO vo = JSONObject.toJavaObject(json, SubpackagetotalVO.class);
                vo.setId(Long.valueOf(idCount));
                if (vo.getSnapShotTime() != null) {
                    vo.setSnapShotTime(DateUtil.date(vo.getSnapShotTime()));
                }
                list.add(vo);
                count++;
            }
            voPage.setTotal(count);
            voPage.setSize(pageSize);
            voPage.setPages(pageIndex <= 0 ? 0 : (pageIndex - 1) * pageSize);
            return voPage.setRecords(list);
        } catch (IOException e) {
            throw new RuntimeException("ES查询异常" + e);
        }
    }

    @Override
    public List<String> queryEsSnap() {
        // 搜索请求对象
        SearchRequest searchRequest = new SearchRequest(ESSignStatistic);
        // 指定类型
        searchRequest.searchType(SearchType.DFS_QUERY_THEN_FETCH);

        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query(QueryBuilders.matchAllQuery());
        sourceBuilder.fetchSource(new String[]{"snapShotVersion"}, new String[]{});
        // 向搜索请求对象中设置搜索源
        searchRequest.source(sourceBuilder);
        // 执行搜索,向ES发起http请求
        SearchResponse searchResponse = null;
        ArrayList<String> list = new ArrayList<>();
        try {
            searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            SearchHit[] searchHits = hits.getHits();
            for (SearchHit hit : searchHits) {
                // 源文档内容
                Map<String, Object> sourceAsMap = hit.getSourceAsMap();
                String versionName = (String) sourceAsMap.get("snapShotVersion");
                list.add(hit.getId());
                list.add(versionName);
            }
        } catch (IOException e) {
            throw new RuntimeException("ES查询失败" + e);
        }
        // 搜索结果
        return list;
    }

    //获取上一个月字符串
    public String getLastMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date); // 设置为当前时间
        calendar.set(Calendar.MONTH, calendar.get(Calendar.MONTH) - 1); // 设置为上一个月
        date = calendar.getTime();
        String accDate = format.format(date);
        return accDate;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
