package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.ejianc.business.bedget.bean.MaterialrequirementsEntity;
import com.ejianc.business.bedget.bean.MaterialrequirementsdetailEntity;
import com.ejianc.business.bedget.bean.QuotaanalysisEntity;
import com.ejianc.business.bedget.bean.QuotaanalysisdetailEntity;
import com.ejianc.business.bedget.service.IMaterialrequirementsService;
import com.ejianc.business.change.bean.ChangematerialrequirementsEntity;
import com.ejianc.business.change.service.IChangematerialrequirementsService;
import com.ejianc.business.change.vo.ChangeQuotaanalysisVO;
import com.ejianc.business.change.vo.ChangeQuotaanalysisdetailVO;
import com.ejianc.business.change.vo.ChangematerialrequirementsVO;
import com.ejianc.business.change.vo.ChangematerialrequirementsdetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;



/**
 * 物资需求总计划变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changematerialrequirements")
public class ChangematerialrequirementsController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IChangematerialrequirementsService service;
    @Autowired
    private IMaterialrequirementsService materialrequirementsService;

    /**
     * 初始化更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetailBymaterialrequirementsId")
    @ResponseBody
    public CommonResponse<ChangematerialrequirementsVO> queryDetailBymaterialrequirementsId(@RequestParam(value = "materialrequirementsId") Long materialrequirementsId) {
        MaterialrequirementsEntity materialrequirementsVO = materialrequirementsService.selectById(materialrequirementsId);
        ChangematerialrequirementsVO changeVO = BeanMapper.map(materialrequirementsVO, ChangematerialrequirementsVO.class);
        Long id = IdWorker.getId();
        changeVO.setOriginalId(materialrequirementsId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        //子表
        List<MaterialrequirementsdetailEntity> materialrequirementsdetailList = materialrequirementsVO.getMaterialrequirementsdetailEntities();
        if(materialrequirementsdetailList!=null&&materialrequirementsdetailList.size()>0){
            List<ChangematerialrequirementsdetailVO> changematerialrequirementsdetailVO = new ArrayList<>();
            for(MaterialrequirementsdetailEntity entity : materialrequirementsdetailList){
                ChangematerialrequirementsdetailVO vo = BeanMapper.map(entity, ChangematerialrequirementsdetailVO.class);
                vo.setMid(id);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changematerialrequirementsdetailVO.add(vo);
            }
            changeVO.setMaterialrequirementsdetailEntities(changematerialrequirementsdetailVO);
        }

        return CommonResponse.success("查询详情成功！", changeVO);

    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangematerialrequirementsVO> saveOrUpdate(@RequestBody ChangematerialrequirementsVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangematerialrequirementsVO> queryDetail(Long id) {
    	ChangematerialrequirementsEntity entity = service.selectById(id);
    	ChangematerialrequirementsVO vo = BeanMapper.map(entity, ChangematerialrequirementsVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangematerialrequirementsVO> vos) {
        service.removeByIds(vos.stream().map(ChangematerialrequirementsVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangematerialrequirementsVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangematerialrequirementsEntity> page = service.queryPage(param,false);
        IPage<ChangematerialrequirementsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangematerialrequirementsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangematerialrequirementsEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Changematerialrequirements-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refChangematerialrequirementsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangematerialrequirementsVO>> refChangematerialrequirementsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangematerialrequirementsEntity> page = service.queryPage(param,false);
        IPage<ChangematerialrequirementsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangematerialrequirementsVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
