package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.vo.ConsdrawbudgetVO;
import com.ejianc.business.change.bean.ChangematerialrequirementsdetailEntity;
import com.ejianc.business.change.service.IChangematerialrequirementsdetailService;
import com.ejianc.business.change.vo.ChangematerialrequirementsdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 物资需求总计划变更导入导出
 */
@Controller
@RequestMapping("changematerialrequirementsExport")
public class ExcelChangeMaterialrequirementsController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangematerialrequirementsdetailService changematerialrequirementsdetailService;



    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadmaterialrequirements")
    @ResponseBody
    public void downloadMaterialrequirement(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "materialrequirementdetail-import.xlsx", "物资需求总计划清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportmaterialrequirements", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterialrequirement(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangematerialrequirementsdetailVO> successList = new ArrayList<>();
        List<ChangematerialrequirementsdetailVO> errorList = new ArrayList<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    ChangematerialrequirementsdetailVO changematerialrequirementsdetailVO = new ChangematerialrequirementsdetailVO();
                    changematerialrequirementsdetailVO.setId(IdWorker.getId());//id
                    changematerialrequirementsdetailVO.setName(StringUtils.isNotBlank(datas.get(0))? datas.get(0):null); // 物资名称
                    changematerialrequirementsdetailVO.setSpec(StringUtils.isNotBlank(datas.get(1))? datas.get(1):null); // 物资规格
                    changematerialrequirementsdetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(2))? datas.get(2):null); // 计量单位
                    changematerialrequirementsdetailVO.setBase(StringUtils.isNotBlank(datas.get(3))? datas.get(3):null); // 基础
                    changematerialrequirementsdetailVO.setMain(StringUtils.isNotBlank(datas.get(4))? new BigDecimal(datas.get(4)):null); // 主体
                    changematerialrequirementsdetailVO.setDecorate(StringUtils.isNotBlank(datas.get(5))? new BigDecimal(datas.get(5)):null); // 装修
                    changematerialrequirementsdetailVO.setOtherNum(StringUtils.isNotBlank(datas.get(6))? new BigDecimal(datas.get(6)):null); // 其它数量
                    changematerialrequirementsdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(7))? datas.get(7):null); // 备注
                    /*if(StringUtils.isEmpty(datas.get(0))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(1))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("名称不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(2))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("单位不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(3))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("投标工程量不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(4))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("建筑面积(m²)不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(5))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("投标指标不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(6))) {
                        ConsdrawbudgetdetailVO.setErrorMsg("(计划成本)限额设计指标不能为空！");
                        errorList.add(ConsdrawbudgetdetailVO);
                        continue;
                    }*/
                    successList.add(changematerialrequirementsdetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportmaterialrequirementsFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody ConsdrawbudgetVO consdrawbudgetVO, HttpServletResponse response) {
        QueryWrapper<ChangematerialrequirementsdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", consdrawbudgetVO.getId());
        queryWrapper.eq("dr", 0);
        List<ChangematerialrequirementsdetailEntity> list = changematerialrequirementsdetailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialrequirementsdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportmaterialrequirementsFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<ChangematerialrequirementsdetailVO> list, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialrequirementsdetail-export.xlsx", beans, response);
    }
}
