package com.ejianc.business.change.excel;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.SubpackagematerialanalysisdetailEntity;
import com.ejianc.business.bedget.vo.SubpackagematerialanalysisVO;
import com.ejianc.business.bedget.vo.SubpackagematerialanalysisdetailVO;
import com.ejianc.business.change.bean.ChangesubpackmateanalydetailEntity;
import com.ejianc.business.change.service.IChangesubpackmateanalydetailService;
import com.ejianc.business.change.vo.ChangesubpachagematerialanalysisVO;
import com.ejianc.business.change.vo.ChangesubpackmateanalydetailVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 分包施工图预算材料分析变更导入导出
 */
@Controller
@RequestMapping("changeSubpackageMaterialanalysisExport")
public class ExcelChangeSubpackageMaterialanalysisController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IChangesubpackmateanalydetailService changesubpackmateanalydetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
       @RequestMapping(value = "/downloadSubpackagematerialanalysis")
    @ResponseBody
    public void downloadSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "subpackagematerialanalysisdetail-import .xlsx", "物资需求总计划清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportSubpackagematerialanalysis", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportSubpackageMaterialanalysis(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangesubpackmateanalydetailVO> successList = new ArrayList<>();
        List<ChangesubpackmateanalydetailVO> errorList = new ArrayList<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        HashMap<String, String> map = new HashMap<>();

        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    ChangesubpackmateanalydetailVO changesubpackmateanalydetailVO = new ChangesubpackmateanalydetailVO();
                    changesubpackmateanalydetailVO.setId(IdWorker.getId());//id
                    changesubpackmateanalydetailVO.setSort(datas.get(0)); // 序号
                    changesubpackmateanalydetailVO.setMaterialsCode(StringUtils.isNotBlank(datas.get(1))? datas.get(1):null); // 物资编码
                    changesubpackmateanalydetailVO.setMaterialsName(StringUtils.isNotBlank(datas.get(2))? datas.get(2):null); // 物资名称
                    changesubpackmateanalydetailVO.setSpec(StringUtils.isNotBlank(datas.get(3))? datas.get(3):null); // 规格型号
                    changesubpackmateanalydetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(4))? datas.get(4):null); // 计量单位
                    changesubpackmateanalydetailVO.setQuantitiesBase(StringUtils.isNotBlank(datas.get(5))? new BigDecimal(datas.get(5)):null); // 分包基础清单工程量
                    changesubpackmateanalydetailVO.setMaterialWasteRateBase(StringUtils.isNotBlank(datas.get(6))? new BigDecimal(datas.get(6)):null); // 合同约定基础用料损耗率
                    changesubpackmateanalydetailVO.setQuantitiesMain(StringUtils.isNotBlank(datas.get(7))? new BigDecimal(datas.get(7)):null); // 分包主体清单工程量
                    changesubpackmateanalydetailVO.setMaterialWasteRateMain(StringUtils.isNotBlank(datas.get(8))? new BigDecimal(datas.get(8)):null); // 合同约定主体用料损耗率
                    changesubpackmateanalydetailVO.setQuantitiesDecorate(StringUtils.isNotBlank(datas.get(9))? new BigDecimal(datas.get(9)):null); // 分包装修清单工程量
                    changesubpackmateanalydetailVO.setMaterialWasteRateDecorate(StringUtils.isNotBlank(datas.get(10))? new BigDecimal(datas.get(10)):null); // 合同约定装修用料损耗率
                    changesubpackmateanalydetailVO.setRemarks(StringUtils.isNotBlank(datas.get(11))? datas.get(11):null); // 备注
                    CommonResponse<MaterialVO> back0 = shareMaterialApi.queryMaterialByCode(datas.get(1));
                    if(back0.getData() == null){
                        changesubpackmateanalydetailVO.setErrorMessage("物资编码未在库中,请检查！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(1))) {
                        changesubpackmateanalydetailVO.setErrorMessage("物资编码不能为空！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(2))) {
                        changesubpackmateanalydetailVO.setErrorMessage("物资名称不能为空！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(3))) {
                        changesubpackmateanalydetailVO.setErrorMessage("规格型号不能为空！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(4))) {
                        changesubpackmateanalydetailVO.setErrorMessage("计量单位不能为空！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(5))) {
                        changesubpackmateanalydetailVO.setErrorMessage("分包基础清单工程量不能为空！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(6))) {
                        changesubpackmateanalydetailVO.setErrorMessage("合同约定基础用料损耗率不能为空！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(7))) {
                        changesubpackmateanalydetailVO.setErrorMessage("分包主体清单工程量不能为空！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(8))) {
                        changesubpackmateanalydetailVO.setErrorMessage("合同约定主体用料损耗率不能为空！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(9))) {
                        changesubpackmateanalydetailVO.setErrorMessage("分包装修清单工程量不能为空！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(datas.get(10))) {
                        changesubpackmateanalydetailVO.setErrorMessage("合同约定装修用料损耗率不能为空！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }
                    if(!NumberUtil.isNumber(String.valueOf(datas.get(5)))){
                        changesubpackmateanalydetailVO.setErrorMessage("分包基础清单工程量输入格式错误！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }else{
                        changesubpackmateanalydetailVO.setQuantitiesBase(StringUtils.isNotBlank(datas.get(5))? new BigDecimal(datas.get(5)):null); // 其它数量
                    }
                    if(!NumberUtil.isNumber(String.valueOf(datas.get(6)))){
                        changesubpackmateanalydetailVO.setErrorMessage("合同约定基础用料损耗率输入格式错误！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }else{
                        changesubpackmateanalydetailVO.setMaterialWasteRateBase(StringUtils.isNotBlank(datas.get(6))? new BigDecimal(datas.get(6)):null); // 其它数量
                    }
                    if(!NumberUtil.isNumber(String.valueOf(datas.get(7)))){
                        changesubpackmateanalydetailVO.setErrorMessage("分包主体清单工程量输入格式错误！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }else{
                        changesubpackmateanalydetailVO.setQuantitiesMain(StringUtils.isNotBlank(datas.get(7))? new BigDecimal(datas.get(7)):null); // 其它数量
                    }
                    if(!NumberUtil.isNumber(String.valueOf(datas.get(8)))){
                        changesubpackmateanalydetailVO.setErrorMessage("合同约定主体用料损耗率输入格式错误！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }else{
                        changesubpackmateanalydetailVO.setMaterialWasteRateMain(StringUtils.isNotBlank(datas.get(8))? new BigDecimal(datas.get(8)):null); // 其它数量
                    }
                    if(!NumberUtil.isNumber(String.valueOf(datas.get(9)))){
                        changesubpackmateanalydetailVO.setErrorMessage("分包装修清单工程量输入格式错误！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }else{
                        changesubpackmateanalydetailVO.setQuantitiesDecorate(StringUtils.isNotBlank(datas.get(9))? new BigDecimal(datas.get(9)):null); // 其它数量
                    }
                    if(!NumberUtil.isNumber(String.valueOf(datas.get(10)))){
                        changesubpackmateanalydetailVO.setErrorMessage("合同约定装修用料损耗率输入格式错误！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }else{
                        changesubpackmateanalydetailVO.setMaterialWasteRateDecorate(StringUtils.isNotBlank(datas.get(10))? new BigDecimal(datas.get(10)):null); // 其它数量
                    }

                    String data0 = map.get(datas.get(1));
                    if(map.get(data0)!=null && StringUtils.isNotEmpty(data0) && data0.equals(datas.get(1))){
                        changesubpackmateanalydetailVO.setErrorMessage("物资编码重复,请检查！");
                        errorList.add(changesubpackmateanalydetailVO);
                        continue;
                    }else{
                        map.put(datas.get(1),datas.get(1));
                    }
                    //基础用料损耗量
                    BigDecimal materialWasteBase = new BigDecimal(datas.get(5)).multiply(new BigDecimal(datas.get(6)));
                    changesubpackmateanalydetailVO.setMaterialWasteBase(materialWasteBase);
                    //基础材料用量
                    BigDecimal materialDosageBase = new BigDecimal(datas.get(5)).add(materialWasteBase);
                    changesubpackmateanalydetailVO.setMaterialDosageBase(materialDosageBase);
                    //主体用料损耗量
                    BigDecimal materialWasteMain = new BigDecimal(datas.get(7)).multiply(new BigDecimal(datas.get(8)));
                    changesubpackmateanalydetailVO.setMaterialWasteMain(materialWasteMain);
                    //主体材料用量
                    BigDecimal materialDosageMain = new BigDecimal(datas.get(7)).add(materialWasteMain);
                    changesubpackmateanalydetailVO.setMaterialDosageMain(materialDosageMain);
                    //装修用料损耗量
                    BigDecimal materialWasteDecorate = new BigDecimal(datas.get(9)).multiply(new BigDecimal(datas.get(10)));
                    changesubpackmateanalydetailVO.setMaterialWasteDecorate(materialWasteDecorate);
                    //装修材料用量
                    BigDecimal materialDosageDecorate = new BigDecimal(datas.get(9)).add(materialWasteDecorate);
                    changesubpackmateanalydetailVO.setMaterialDosageDecorate(materialDosageDecorate);
                    //小计
                    BigDecimal subtotal = materialDosageBase.add(materialDosageMain).add(materialDosageDecorate);
                    changesubpackmateanalydetailVO.setSubtotal(subtotal);
                    successList.add(changesubpackmateanalydetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubpackagematerialanalysisFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromDatabase(@RequestBody ChangesubpachagematerialanalysisVO changesubpachagematerialanalysisVO, HttpServletResponse response) {
        QueryWrapper<ChangesubpackmateanalydetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", changesubpachagematerialanalysisVO.getId());
        queryWrapper.eq("dr", 0);
        List<ChangesubpackmateanalydetailEntity> list = changesubpackmateanalydetailService.list(queryWrapper);
        List<ChangesubpackmateanalydetailVO> changesubpackmateanalydetailVOList = BeanMapper.mapList(list, ChangesubpackmateanalydetailVO.class);
        if (changesubpackmateanalydetailVOList != null && changesubpackmateanalydetailVOList.size() > 0) {
            for (int i = 0; i < changesubpackmateanalydetailVOList.size(); i++) {
                ChangesubpackmateanalydetailVO changesubpackmateanalydetailVO = changesubpackmateanalydetailVOList.get(i);
                changesubpackmateanalydetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subpackagematerialanalysisdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubpackagematerialanalysisFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSubpackageMaterialanalysisFromPage(@RequestBody List<ChangesubpackmateanalydetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                ChangesubpackmateanalydetailVO changesubpackmateanalydetailVO = list.get(i);
                changesubpackmateanalydetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subpackagematerialanalysisdetail-export.xlsx", beans, response);
    }
}
