package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.*;
import com.ejianc.business.bedget.service.IQuotaanalysisService;
import com.ejianc.business.change.bean.ChangeQuotaanalysisEntity;
import com.ejianc.business.change.bean.ChangeQuotaanalysisdetailEntity;
import com.ejianc.business.change.service.IChangeQuotaanalysisService;
import com.ejianc.business.record.bean.RecordQuotaanalysisEntity;
import com.ejianc.business.record.bean.RecordQuotaanalysisdetailEntity;
import com.ejianc.business.record.service.IRecordQuotaanalysisService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.slf4j.Logger;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changeQuotaanalysis") 
public class ChangeQuotaanalysisBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Quotaanalysis = "zjkj-quotaanalysis";//限额设计指标分析
	private static final String QuotaanalysisT_CHANGE = "zjkj-quotaanalysisChange";//限额设计指标分析变更
	private static final String Quotaanalysis_RECORD = "zjkj-quotaanalysisRecord";//限额设计指标分析变更记录

	//单据类型
	private static final String Quotaanalysis_BILLTYPE_CODE = "BT202202000006";//限额设计指标分析
	private static final String Quotaanalysis_CHANGE_BILLTYPE_CODE = "BT202202000007";//限额设计指标分析变更
	private static final String Quotaanalysis_RECORD_BILLTYPE_CODE = "BT202202000008";//限额设计指标分析变更记录


	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangeQuotaanalysisService changeQuotaanalysisService;
	@Autowired
	private IQuotaanalysisService quotaanalysisService;
	@Autowired
	private IRecordQuotaanalysisService recordQuotaanalysisService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前单据信息、变更信息
		ChangeQuotaanalysisEntity changeEntity = changeQuotaanalysisService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getId());
		QuotaanalysisEntity quotaanalysisEntity = quotaanalysisService.selectById(changeEntity.getOriginalId());
		logger.info("原始单据id=" + quotaanalysisEntity.getId() + "主单据创建人" + quotaanalysisEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordQuotaanalysisEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("original_id", quotaanalysisEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordQuotaanalysisService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordQuotaanalysisEntity recordQuotaanalysisEntity = BeanMapper.map(quotaanalysisEntity, RecordQuotaanalysisEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordQuotaanalysisEntity);
		recordQuotaanalysisEntity.setBillState(null);
		recordQuotaanalysisEntity.setOriginalId(quotaanalysisEntity.getId());
		recordQuotaanalysisEntity.setQuotaanalysisCode(quotaanalysisEntity.getBillCode()+"-"+(count+1));
		recordQuotaanalysisEntity.setId(recordId);
		recordQuotaanalysisEntity.setBillCode(quotaanalysisEntity.getBillCode());
		recordQuotaanalysisEntity.setChangeReason(changeEntity.getChangeReason());
		recordQuotaanalysisEntity.setEffectDate(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<QuotaanalysisdetailEntity> quotaanalysisdetailEntities = quotaanalysisEntity.getQuotaanalysisdetailEntities();
		if(quotaanalysisdetailEntities!=null&&quotaanalysisdetailEntities.size()>0){
			List<RecordQuotaanalysisdetailEntity> recordQuotaanalysisdetailEntities = new ArrayList<>();
			for(QuotaanalysisdetailEntity entity : quotaanalysisdetailEntities){
				RecordQuotaanalysisdetailEntity reEntity = BeanMapper.map(entity, RecordQuotaanalysisdetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setId(IdWorker.getId());
				reEntity.setOriginalId(entity.getId());
				recordQuotaanalysisdetailEntities.add(reEntity);
			}
			recordQuotaanalysisEntity.setQuotaanalysisdetailEntities(recordQuotaanalysisdetailEntities);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Quotaanalysis_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Quotaanalysis_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(quotaanalysisEntity.getId().toString(), sourceBillType, Quotaanalysis , recordId.toString(), targetBillType, Quotaanalysis_RECORD);
		recordQuotaanalysisService.saveOrUpdate(recordQuotaanalysisEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + quotaanalysisEntity.getCreateUserCode());
		//3、修改当前单据状态
		QuotaanalysisEntity newQuotaanalysisEntity = BeanMapper.map(changeEntity, QuotaanalysisEntity.class);
		newQuotaanalysisEntity.setChangeState("3");//状态改为已变更
		newQuotaanalysisEntity.setChangeId(null);
		newQuotaanalysisEntity.setBillState(quotaanalysisEntity.getBillState());
		newQuotaanalysisEntity.setId(quotaanalysisEntity.getId());
		newQuotaanalysisEntity.setCreateTime(quotaanalysisEntity.getCreateTime());
		newQuotaanalysisEntity.setCreateUserCode(quotaanalysisEntity.getCreateUserCode());
		newQuotaanalysisEntity.setTenantId(quotaanalysisEntity.getTenantId());
		newQuotaanalysisEntity.setVersion(quotaanalysisEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangeQuotaanalysisdetailEntity> changeQuotaanalysisdetailList = changeEntity.getChangeQuotaanalysisdetailEntities();
		if(changeQuotaanalysisdetailList != null && changeQuotaanalysisdetailList.size()>0){
			List<QuotaanalysisdetailEntity> newQuotaanalysisdetailList = BeanMapper.mapList(changeQuotaanalysisdetailList, QuotaanalysisdetailEntity.class);

			//原始单据子表
			if(quotaanalysisdetailEntities != null && quotaanalysisdetailEntities.size() > 0){
				QuotaanalysisdetailEntity originalQuotaanalysisdetailInfo = quotaanalysisdetailEntities.get(0);

				for (int i = 0; i < changeQuotaanalysisdetailList.size(); i++) {
					ChangeQuotaanalysisdetailEntity changeQuotaanalysisdetail = changeQuotaanalysisdetailList.get(i);
					QuotaanalysisdetailEntity newQuotaanalysisdetail = newQuotaanalysisdetailList.get(i);

					boolean isChangeUpdate = false;//true 变更更新数据 false 变更新增数据
					for (int j = 0; j < quotaanalysisdetailEntities.size(); j++) {
						QuotaanalysisdetailEntity originalQuotaanalysisdetail = quotaanalysisdetailEntities.get(j);
						if(originalQuotaanalysisdetail.getId().equals(changeQuotaanalysisdetail.getOriginalId())){

							newQuotaanalysisdetail.setId(originalQuotaanalysisdetail.getId());
							newQuotaanalysisdetail.setCreateTime(originalQuotaanalysisdetailInfo.getCreateTime());
							newQuotaanalysisdetail.setCreateUserCode(originalQuotaanalysisdetailInfo.getCreateUserCode());

							newQuotaanalysisdetail.setUpdateTime(changeQuotaanalysisdetail.getUpdateTime());
							newQuotaanalysisdetail.setUpdateUserCode(changeQuotaanalysisdetail.getCreateUserCode());

							isChangeUpdate = true;
							break;
						}
					}

					if(!isChangeUpdate){//变更新增
						newQuotaanalysisdetail.setCreateTime(changeQuotaanalysisdetail.getUpdateTime());
						newQuotaanalysisdetail.setCreateUserCode(changeQuotaanalysisdetail.getCreateUserCode());
					}

					newQuotaanalysisdetail.setBillState(originalQuotaanalysisdetailInfo.getBillState());
					newQuotaanalysisdetail.setTenantId(originalQuotaanalysisdetailInfo.getTenantId());
					newQuotaanalysisdetail.setVersion(originalQuotaanalysisdetailInfo.getVersion());
				}
			}
			//原始单与变更单对比后（新增）
			newQuotaanalysisEntity.setQuotaanalysisdetailEntities(newQuotaanalysisdetailList);

			//原始单与变更单对比后（删除）
			List<QuotaanalysisdetailEntity> deleteDatas = new ArrayList<>();
			for (int i = 0; i < quotaanalysisdetailEntities.size(); i++) {
				QuotaanalysisdetailEntity quotaanalysisdetail = quotaanalysisdetailEntities.get(i);
				boolean isSame = false;
				for (int j = 0; j < newQuotaanalysisdetailList.size(); j++) {
					QuotaanalysisdetailEntity newDetail = newQuotaanalysisdetailList.get(j);
					if(quotaanalysisdetail.getId().equals(newDetail.getId())) {
						isSame = true;
					}
				}
				if(!isSame){//变更已删除行
					quotaanalysisdetail.setRowState("del");
					deleteDatas.add(quotaanalysisdetail);
				}
			}

			if(deleteDatas.size() > 0){
				newQuotaanalysisdetailList.addAll(deleteDatas);
				newQuotaanalysisEntity.setQuotaanalysisdetailEntities(newQuotaanalysisdetailList);
			}
		}
		logger.info("---------保存--------");
		quotaanalysisService.saveOrUpdate(newQuotaanalysisEntity, false);

		sourceBillType = Quotaanalysis_CHANGE_BILLTYPE_CODE;
		targetBillType = Quotaanalysis_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, QuotaanalysisT_CHANGE, quotaanalysisEntity.getId().toString(), targetBillType, Quotaanalysis);
		recordQuotaanalysisService.saveOrUpdate(recordQuotaanalysisEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
