package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotalEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotaldetailEntity;
import com.ejianc.business.bedget.bean.SubpackagematerialanalysisEntity;
import com.ejianc.business.bedget.bean.SubpackagematerialanalysisdetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgettotalService;
import com.ejianc.business.bedget.service.ISubpackagematerialanalysisService;
import com.ejianc.business.change.bean.ChangeconsdrawbudgettotalEntity;
import com.ejianc.business.change.bean.ChangeconsdrawbudgettotaldetailEntity;
import com.ejianc.business.change.bean.ChangesubpachagematerialanalysisEntity;
import com.ejianc.business.change.bean.ChangesubpackmateanalydetailEntity;
import com.ejianc.business.change.service.IChangeconsdrawbudgettotalService;
import com.ejianc.business.change.service.IChangesubpachagematerialanalysisService;
import com.ejianc.business.change.service.IChangesubpackageService;
import com.ejianc.business.record.bean.RecordconsdrawbudgettotalEntity;
import com.ejianc.business.record.bean.RecordconsdrawbudgettotaldetailEntity;
import com.ejianc.business.record.bean.RecordsubpackagematerialanalysisEntity;
import com.ejianc.business.record.bean.RecordsubpackmateanalydetailEntity;
import com.ejianc.business.record.service.IRecordsubpackagematerialanalysisService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changesubpachagematerialanalysis") 
public class ChangesubpachagematerialanalysisBpmServiceImpl implements ICommonBusinessService {
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	private Logger logger = LoggerFactory.getLogger(this.getClass());
	//业务类型
	private static final String Subpackagematerialanalysis = "zjkj-designestimate";//限额设计指标分析
	private static final String Subpackagematerialanalysis_CHANGE = "zjkj-designestimateChange";//限额设计指标分析变更
	private static final String Subpackagematerialanalysis_RECORD = "zjkj-designestimateRecord";//限额设计指标分析变更记录

	//单据类型
	private static final String Subpackagematerialanalysis_BILLTYPE_CODE = "BT202202000030";//限额设计指标分析
	private static final String Subpackagematerialanalysis_CHANGE_BILLTYPE_CODE = "BT202202000031";//限额设计指标分析变更
	private static final String Subpackagematerialanalysis_RECORD_BILLTYPE_CODE = "BT202202000032";//限额设计指标分析变更记录
	@Autowired
	private IChangesubpachagematerialanalysisService  changesubpachagematerialanalysisService;
	@Autowired
	private ISubpackagematerialanalysisService subpackagematerialanalysisService;
	@Autowired
	private IRecordsubpackagematerialanalysisService recordsubpackagematerialanalysisService;

	@Autowired
	private IAttachmentApi attachmentApi;
	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		logger.info("---------进来啦--------");
		//TODO
		//1、获取目前单据信息、变更信息
		ChangesubpachagematerialanalysisEntity changeEntity = changesubpachagematerialanalysisService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getOriginalId());
		SubpackagematerialanalysisEntity consdrawbudgettotalEntity = subpackagematerialanalysisService.selectById(changeEntity.getOriginalId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordsubpackagematerialanalysisEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("original_id", consdrawbudgettotalEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordsubpackagematerialanalysisService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordsubpackagematerialanalysisEntity recordconsdrawbudgettotalEntity = BeanMapper.map(consdrawbudgettotalEntity, RecordsubpackagematerialanalysisEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordconsdrawbudgettotalEntity);
		recordconsdrawbudgettotalEntity.setBillState(null);
		recordconsdrawbudgettotalEntity.setOriginalId(consdrawbudgettotalEntity.getId());
		recordconsdrawbudgettotalEntity.setSubpackagematerialanalysisCode(consdrawbudgettotalEntity.getBillCode()+"-"+(count+1));
		recordconsdrawbudgettotalEntity.setId(recordId);
		recordconsdrawbudgettotalEntity.setBillCode(consdrawbudgettotalEntity.getBillCode());
		recordconsdrawbudgettotalEntity.setChangeReason(changeEntity.getChangeReason());
		recordconsdrawbudgettotalEntity.setEffectDate(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<SubpackagematerialanalysisdetailEntity> quotaanalysisdetailEntities = consdrawbudgettotalEntity.getSubpackagematerialanalysisdetailEntities();
		if(quotaanalysisdetailEntities!=null&&quotaanalysisdetailEntities.size()>0){
			List<RecordsubpackmateanalydetailEntity> recorddesignestimatedetailEntities = new ArrayList<>();
			for(SubpackagematerialanalysisdetailEntity entity : quotaanalysisdetailEntities){
				RecordsubpackmateanalydetailEntity reEntity = BeanMapper.map(entity, RecordsubpackmateanalydetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setId(recordId);
				recorddesignestimatedetailEntities.add(reEntity);
				entity.setRowState("del");
			}
			recordconsdrawbudgettotalEntity.setSubpackagematerialanalysisdetailEntites(recorddesignestimatedetailEntities);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		sourceBillType = Subpackagematerialanalysis_BILLTYPE_CODE;
		String targetBillType = "";
		targetBillType = Subpackagematerialanalysis_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(consdrawbudgettotalEntity.getId().toString(), sourceBillType, Subpackagematerialanalysis , recordId.toString(), targetBillType, Subpackagematerialanalysis_RECORD);
		recordsubpackagematerialanalysisService.saveOrUpdate(recordconsdrawbudgettotalEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + recordconsdrawbudgettotalEntity.getCreateUserCode());
		//3、修改当前单据状态
		SubpackagematerialanalysisEntity consdrawbudgettotalEntity1 = BeanMapper.map(changeEntity, SubpackagematerialanalysisEntity.class);
		consdrawbudgettotalEntity1.setChangeState("3");//状态改为已变更
		consdrawbudgettotalEntity1.setChangeId(null);
		consdrawbudgettotalEntity1.setBillState(consdrawbudgettotalEntity.getBillState());
		consdrawbudgettotalEntity1.setId(consdrawbudgettotalEntity.getId());
		consdrawbudgettotalEntity1.setCreateTime(consdrawbudgettotalEntity.getCreateTime());
		consdrawbudgettotalEntity1.setCreateUserCode(consdrawbudgettotalEntity.getCreateUserCode());
		consdrawbudgettotalEntity1.setTenantId(consdrawbudgettotalEntity.getTenantId());
		consdrawbudgettotalEntity1.setVersion(consdrawbudgettotalEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangesubpackmateanalydetailEntity> changedesignestimatedetailEntities = changeEntity.getSubpackagematerialanalysisdetailEntites();
		if(changedesignestimatedetailEntities!=null&&changedesignestimatedetailEntities.size()>0){
			List<SubpackagematerialanalysisdetailEntity> newDesignestimatedetailEntity = BeanMapper.mapList(changedesignestimatedetailEntities, SubpackagematerialanalysisdetailEntity.class);
			newDesignestimatedetailEntity.addAll(quotaanalysisdetailEntities);
			consdrawbudgettotalEntity1.setSubpackagematerialanalysisdetailEntities(newDesignestimatedetailEntity);
		}
		logger.info("---------保存--------");
		subpackagematerialanalysisService.saveOrUpdate(consdrawbudgettotalEntity1, false);

		sourceBillType = Subpackagematerialanalysis_CHANGE_BILLTYPE_CODE;
		targetBillType = Subpackagematerialanalysis_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Subpackagematerialanalysis_CHANGE, consdrawbudgettotalEntity.getId().toString(), targetBillType, Subpackagematerialanalysis);
		recordsubpackagematerialanalysisService.saveOrUpdate(recordconsdrawbudgettotalEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}


}
