package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotaanalysisEntity;
import com.ejianc.business.bedget.bean.QuotadesignEntity;
import com.ejianc.business.bedget.bean.SubpackageEntity;
import com.ejianc.business.bedget.service.IQuotaanalysisService;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.business.bedget.vo.SubpackageVO;
import com.ejianc.business.change.bean.ChangeQuotaanalysisEntity;
import com.ejianc.business.change.bean.ChangequotadesignEntity;
import com.ejianc.business.change.bean.ChangesubpackageEntity;
import com.ejianc.business.change.mapper.ChangesubpackageMapper;
import com.ejianc.business.change.service.IChangesubpackageService;
import com.ejianc.business.change.vo.ChangeQuotaanalysisVO;
import com.ejianc.business.change.vo.ChangequotadesignVO;
import com.ejianc.business.change.vo.ChangesubpackageVO;
import com.ejianc.business.record.bean.RecordquotadesignEntity;
import com.ejianc.business.record.bean.RecordsubpackageEntity;
import com.ejianc.business.record.service.IRecordsubpackageService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;
import java.util.stream.Collectors;


/**
 * 分包施工图预算变更
 * 
 * @author generator
 * 
 */
@Service("changesubpackageService")
public class ChangesubpackageServiceImpl extends BaseServiceImpl<ChangesubpackageMapper, ChangesubpackageEntity> implements IChangesubpackageService {

    @Autowired
    private ISubpackageService subpackageService;
    @Autowired
    private IRecordsubpackageService recordsubpackageService;
    @Override
    public CommonResponse<ChangesubpackageVO> saveChange(ChangesubpackageVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangesubpackageEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangesubpackageEntity entity = BeanMapper.map(saveOrUpdateVO, ChangesubpackageEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangesubpackageEntity> queryWrapper = new QueryWrapper<ChangesubpackageEntity>();
        queryWrapper.eq("original_id", saveOrUpdateVO.getOriginalId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangesubpackageEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangesubpackageVO vo = BeanMapper.map(entity, ChangesubpackageVO.class);
        vo.setSubpackagedetailEntities(saveOrUpdateVO.getSubpackagedetailEntities());
        vo.setRecordsubpackageList(saveOrUpdateVO.getRecordsubpackageList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            SubpackageEntity subpackageEntity = subpackageService.selectById(vo.getOriginalId());
            subpackageEntity.setChangeState("2");//状态改为变更中
            subpackageEntity.setChangeId(vo.getId());
            subpackageService.saveOrUpdate(subpackageEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @Override
    public CommonResponse<String> delete(List<SubpackageVO> vos) {
        for(SubpackageVO vo : vos){
            ChangesubpackageEntity changesubpackageEntity = this.getById(vo.getId());
            SubpackageEntity subpackageEntity = subpackageService.selectById(changesubpackageEntity.getOriginalId());
            QueryWrapper<RecordsubpackageEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", subpackageEntity.getId());
            List<RecordsubpackageEntity> records = recordsubpackageService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                subpackageEntity.setChangeState("3");//状态改为已变更
            }else{
                subpackageEntity.setChangeState("1");//状态改为未变更
            }
            subpackageEntity.setChangeId(null);
            subpackageService.saveOrUpdate(subpackageEntity, false);
        }
        this.removeByIds(vos.stream().map(SubpackageVO::getId).collect(Collectors.toList()),true);

        return CommonResponse.success("删除成功！");
    }
}
