/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.DesignestimateEntity;
import com.ejianc.business.bedget.service.IDesignestimateService;
import com.ejianc.business.bedget.vo.DesignestimateVO;
import com.ejianc.business.bedget.vo.DesignestimatedetailVO;
import com.ejianc.business.record.service.IRecorddesignestimateService;
import com.ejianc.business.record.vo.RecorddesignestimateVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"designestimate"})
public class DesignestimateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "budgetmanage-designestimate";
    @Autowired
    private IDesignestimateService service;
    @Autowired
    private IRecorddesignestimateService recorddesignestimateService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DesignestimateVO> saveOrUpdate(@RequestBody DesignestimateVO saveorUpdateVO) {
        List pro;
        DesignestimateEntity entity = (DesignestimateEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), DesignestimateEntity.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        queryWrapper.eq((Object)"dr", (Object)"0");
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() != 0L) {
            queryWrapper.ne((Object)"id", (Object)saveorUpdateVO.getId());
        }
        if ((pro = this.service.list((Wrapper)queryWrapper)).size() > 0) {
            throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u8bbe\u8ba1\u6982\u7b97\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa!");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setChangeState("1");
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        DesignestimateVO vo = (DesignestimateVO)((Object)BeanMapper.map((Object)((Object)entity), DesignestimateVO.class));
        List<DesignestimatedetailVO> designestimatedetailVOList = vo.getDesignestimatedetailEntities();
        List<DesignestimatedetailVO> resDesignestimatedetailVOList = DesignestimateController.createTreeData(designestimatedetailVOList);
        vo.setDesignestimatedetailEntities(resDesignestimatedetailVOList);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryProject(Long id, Long projectId) {
        List entityList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        if (id != null && id != 0L) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        if ((entityList = this.service.list((Wrapper)queryWrapper)) != null && entityList.size() > 0) {
            return CommonResponse.success((String)"\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u8bbe\u8ba1\u6982\u7b97\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9879\u76ee!", (Object)"0");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)"1");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DesignestimateVO> queryDetail(Long id) {
        DesignestimateEntity entity = (DesignestimateEntity)((Object)this.service.selectById(id));
        DesignestimateVO vo = (DesignestimateVO)((Object)BeanMapper.map((Object)((Object)entity), DesignestimateVO.class));
        List<DesignestimatedetailVO> designestimatedetailVOList = vo.getDesignestimatedetailEntities();
        Collections.sort(designestimatedetailVOList, new Comparator<DesignestimatedetailVO>(){

            @Override
            public int compare(DesignestimatedetailVO o1, DesignestimatedetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });
        List<DesignestimatedetailVO> resDesignestimatedetailVOList = DesignestimateController.createTreeData(designestimatedetailVOList);
        vo.setDesignestimatedetailEntities(resDesignestimatedetailVOList);
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"designestimate_id", (Object)vo.getId());
            List records = this.recorddesignestimateService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecorddesignestimateList(BeanMapper.mapList((Iterable)records, RecorddesignestimateVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DesignestimateVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DesignestimateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DesignestimateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List designestimateVOList = BeanMapper.mapList((Iterable)list, DesignestimateVO.class);
        for (int i = 0; i < designestimateVOList.size(); ++i) {
            DesignestimateVO designestimateVO = (DesignestimateVO)((Object)designestimateVOList.get(i));
            designestimateVO.setSort(Long.parseLong(String.valueOf(i + 1)));
            if (designestimateVO.getCreateTime() != null) {
                designestimateVO.setCreateTimeShow(DateUtils.dateSimple2(designestimateVO.getCreateTime()));
            }
            String billStateStr = designestimateVO.getBillState().toString();
            String changeState = designestimateVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                designestimateVO.setBillStateStr(billStateStr);
            }
            if (changeState == null) continue;
            if ("1".equals(changeState)) {
                changeState = "\u672a\u53d8\u66f4";
            } else if ("2".equals(changeState)) {
                changeState = "\u53d8\u66f4\u4e2d";
            } else if ("3".equals(changeState)) {
                changeState = "\u5df2\u53d8\u66f4";
            }
            designestimateVO.setChangeState(changeState);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", designestimateVOList);
        ExcelExport.getInstance().export("Designestimate-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDesignestimateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DesignestimateVO>> refDesignestimateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DesignestimateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public static List<DesignestimatedetailVO> createTreeData(List<DesignestimatedetailVO> list) {
        ArrayList<DesignestimatedetailVO> resp = new ArrayList<DesignestimatedetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, DesignestimatedetailVO> listMap = new HashMap<String, DesignestimatedetailVO>();
        for (DesignestimatedetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            DesignestimatedetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            DesignestimatedetailVO parent = (DesignestimatedetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<DesignestimatedetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<DesignestimatedetailVO> children = new ArrayList<DesignestimatedetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((DesignestimatedetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/refreshData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> refreshData(@RequestBody List<DesignestimatedetailVO> list, HttpServletResponse response) {
        Iterator<DesignestimatedetailVO> code;
        JSONObject json = new JSONObject();
        HashMap<String, DesignestimatedetailVO> map = new HashMap<String, DesignestimatedetailVO>();
        DesignestimatedetailVO add = list.get(list.size() - 1);
        add.setId(IdWorker.getId());
        add.setTid(String.valueOf(IdWorker.getId()));
        add.setRowState("edit");
        add.setInnercode(add.getSonItemCode());
        if ("01".equals(add.getSonItemCode()) && add.getSonItemName().contains("\u88c5\u9970")) {
            add.setInnercode("a1");
        }
        if (add.getSonItemCode().length() >= 4 && ("0111".equals(code = add.getSonItemCode().substring(0, 4)) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code))) {
            add.setInnercode("a1" + add.getSonItemCode().substring(2, add.getSonItemCode().length()));
        }
        for (DesignestimatedetailVO vo : list) {
            map.put(vo.getInnercode(), vo);
            if (add.getId().equals(vo.getId()) || !add.getInnercode().equals(vo.getInnercode())) continue;
            throw new BusinessException("\u5b50\u76ee\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        for (DesignestimatedetailVO vo : list) {
            String innercode = vo.getInnercode();
            Long pid = null;
            if (innercode.length() != 2) {
                String pcode;
                if (innercode.length() == 4) {
                    pcode = innercode.substring(0, 2);
                    pid = this.setPid(pcode, map);
                } else if (innercode.length() == 6) {
                    pcode = innercode.substring(0, 4);
                    pid = this.setPid(pcode, map);
                } else if (innercode.length() > 6) {
                    pcode = innercode.substring(0, 6);
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                vo.setTpid(pid.toString());
                continue;
            }
            vo.setTpid("");
        }
        list = this.clearPData(add, list);
        Collections.sort(list, new Comparator<DesignestimatedetailVO>(){

            @Override
            public int compare(DesignestimatedetailVO o1, DesignestimatedetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });
        List<DesignestimatedetailVO> result = DesignestimateController.createTreeData(list);
        json.put("dataSource", result);
        return CommonResponse.success((Object)json);
    }

    private List<DesignestimatedetailVO> clearPData(DesignestimatedetailVO handleVO, List<DesignestimatedetailVO> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        String pid = handleVO.getTpid();
        if (pid == null || TextUtils.isEmpty((CharSequence)pid)) {
            return list;
        }
        for (int i = 0; i < list.size(); ++i) {
            DesignestimatedetailVO vo = list.get(i);
            if (!pid.equals(vo.getTid())) continue;
            vo.setCostPercent(null);
            vo.setProjectScale(null);
            vo.setUnitCost(null);
            if (vo.getTpid() == null || TextUtils.isEmpty((CharSequence)vo.getTpid())) continue;
            this.clearPData(vo, list);
            break;
        }
        return list;
    }

    private Long setPid(String pcode, Map<String, DesignestimatedetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        if (pcode.length() == 2) {
            return null;
        }
        if (pcode.length() == 4) {
            String ppcode = pcode.substring(0, 2);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode, map);
        }
        if (pcode.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode, map);
        }
        return null;
    }
}

