/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bedget.bean.SubpackageEntity;
import com.ejianc.business.bedget.bean.SubpackagedetailEntity;
import com.ejianc.business.bedget.bean.SubpackagetotalEntity;
import com.ejianc.business.bedget.mapper.SubpackagetotalMapper;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.business.bedget.service.ISubpackagedetailService;
import com.ejianc.business.bedget.service.ISubpackagetotalService;
import com.ejianc.business.bedget.vo.SubpackagetotalVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subpackagetotalService")
public class SubpackagetotalServiceImpl
extends BaseServiceImpl<SubpackagetotalMapper, SubpackagetotalEntity>
implements ISubpackagetotalService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubpackagetotalService service;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ISubpackageService subpackageService;
    @Autowired
    private ISubpackagedetailService subpackagedetailService;
    private static final String ESSignStatistic = "ejc_budgetmanage_subpackagetotal";

    @Override
    public CommonResponse<String> saveSnapshotData() {
        String curDate = this.getLastMonth();
        new Thread(() -> {
            try {
                this.service.saveESData("\u52b3\u52a1\u5206\u5305\u9884\u7b97\u6c47\u603b\u62a5\u8868" + curDate);
            }
            catch (Exception e) {
                this.logger.error("\u52b3\u52a1\u5206\u5305\u9884\u7b97\u6c47\u603b\u62a5\u8868\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
            }
        }).start();
        return CommonResponse.success((String)"\u4fdd\u5b58\u5feb\u7167\u6210\u529f");
    }

    @Override
    public CommonResponse<String> saveESData(String reportName) {
        BulkRequest bulkRequest = new BulkRequest();
        long versionId = IdWorker.getId();
        SimpleDateFormat format1 = new SimpleDateFormat("YYYY-MM-dd hh:mm:ss");
        String curDate = format1.format(new Date());
        QueryWrapper queryParam = new QueryWrapper();
        queryParam.eq((Object)"dr", (Object)0);
        List list = this.subpackageService.list((Wrapper)queryParam);
        for (SubpackageEntity entity : list) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"dr", (Object)0);
            wrapper.eq((Object)"mid", (Object)entity.getId());
            List subpackagedetailEntityList = this.subpackagedetailService.list();
            for (SubpackagedetailEntity subpackagedetailEntity : subpackagedetailEntityList) {
                try {
                    SubpackagetotalVO vo = (SubpackagetotalVO)((Object)BeanMapper.map((Object)((Object)entity), SubpackagetotalVO.class));
                    Map dataMap = (Map)BeanMapper.map((Object)((Object)vo), Map.class);
                    dataMap.put("reportId", subpackagedetailEntity.getId().toString());
                    dataMap.put("snapShotTime", curDate);
                    dataMap.put("snapShotVersion", versionId);
                    dataMap.put("projectid", entity.getProjectId());
                    dataMap.put("contract", entity.getContract());
                    dataMap.put("subtitleCode", subpackagedetailEntity.getSubtitleCode());
                    dataMap.put("subtitleName", subpackagedetailEntity.getSubtitleName());
                    dataMap.put("subtitleFeature", subpackagedetailEntity.getSubtitleFeature());
                    dataMap.put("artificialTotal", subpackagedetailEntity.getArtificialTotal());
                    dataMap.put("materialsTotal", subpackagedetailEntity.getMaterialsTotal());
                    dataMap.put("mechanicalTotal", subpackagedetailEntity.getMechanicalTotal());
                    dataMap.put("enterpriseManageTotal", subpackagedetailEntity.getEnterpriseManageTotal());
                    dataMap.put("profitsTotal", subpackagedetailEntity.getProfitsTotal());
                    dataMap.put("feesTotal", subpackagedetailEntity.getFeesTotal());
                    dataMap.put("taxTotal", subpackagedetailEntity.getTaxTotal());
                    dataMap.put("comprehensiveTotal", subpackagedetailEntity.getComprehensiveTotal());
                    dataMap.put("excludingTaxTotal", subpackagedetailEntity.getExcludingTaxTotal());
                    dataMap.put("includingTaxTotal", subpackagedetailEntity.getIncludingTaxTotal());
                    IndexRequest indexRequest = new IndexRequest(ESSignStatistic);
                    indexRequest.source(dataMap, XContentType.JSON);
                    bulkRequest.add(indexRequest);
                }
                catch (Exception e) {
                    this.logger.error("\u751f\u6210\u52b3\u52a1\u5206\u5305\u9884\u7b97\u6c47\u603b\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
                    throw new BusinessException("\u751f\u6210\u52b3\u52a1\u5206\u5305\u9884\u7b97\u6c47\u603b\u6570\u636e\u5f02\u5e38");
                }
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.logger.info("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
            throw new BusinessException("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
        }
        this.logger.info("***********\u751f\u6210\u52b3\u52a1\u5206\u5305\u9884\u7b97\u6c47\u603b---\u6267\u884c\u5b8c\u6210 *********** ");
        return CommonResponse.success((String)"\u751f\u6210\u52b3\u52a1\u5206\u5305\u9884\u7b97\u6c47\u603b\u6210\u529f");
    }

    @Override
    public IPage<SubpackagetotalVO> queryEsByPage(QueryParam param) {
        SearchRequest searchRequest = new SearchRequest(new String[]{ESSignStatistic});
        searchRequest.searchType(SearchType.DEFAULT);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Integer pageIndex = param.getPageIndex();
        Integer pageSize = param.getPageSize();
        sourceBuilder.from(pageIndex <= 0 ? 0 : (pageIndex - 1) * pageSize);
        sourceBuilder.size(pageSize.intValue());
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
        sourceBuilder.sort("snapShotTime", SortOrder.ASC);
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        List fields = param.getFuzzyFields();
        if (fields.size() > 0 && fields != null) {
            for (String field : fields) {
                boolBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)field, (Object)((Parameter)param.getParams().get(field)).getValue()));
            }
            searchRequest.source(sourceBuilder);
        }
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            Integer count = 0;
            Integer idCount = 1;
            SearchHit[] searchHits = hits.getHits();
            if (searchHits.length <= 0) {
                return null;
            }
            Page voPage = new Page();
            ArrayList<SubpackagetotalVO> list = new ArrayList<SubpackagetotalVO>();
            for (SearchHit hit : searchHits) {
                Integer n = idCount;
                Integer n2 = idCount = Integer.valueOf(idCount + 1);
                JSONObject json = new JSONObject(hit.getSourceAsMap());
                SubpackagetotalVO vo = (SubpackagetotalVO)((Object)JSONObject.toJavaObject((JSON)json, SubpackagetotalVO.class));
                vo.setId((long)idCount);
                if (vo.getSnapShotTime() != null) {
                    vo.setSnapShotTime((Date)DateUtil.date((Date)vo.getSnapShotTime()));
                }
                list.add(vo);
                Integer n3 = count;
                Integer n4 = count = Integer.valueOf(count + 1);
            }
            voPage.setTotal((long)count.intValue());
            voPage.setSize((long)pageSize.intValue());
            voPage.setPages(pageIndex <= 0 ? 0L : (long)((pageIndex - 1) * pageSize));
            return voPage.setRecords(list);
        }
        catch (IOException e) {
            throw new RuntimeException("ES\u67e5\u8be2\u5f02\u5e38" + e);
        }
    }

    @Override
    public List<String> queryEsSnap() {
        SearchRequest searchRequest = new SearchRequest(new String[]{ESSignStatistic});
        searchRequest.searchType(SearchType.DFS_QUERY_THEN_FETCH);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        sourceBuilder.fetchSource(new String[]{"snapShotVersion"}, new String[0]);
        searchRequest.source(sourceBuilder);
        SearchResponse searchResponse = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            SearchHit[] searchHits;
            searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : searchHits = hits.getHits()) {
                Map sourceAsMap = hit.getSourceAsMap();
                String versionName = (String)sourceAsMap.get("snapShotVersion");
                list.add(hit.getId());
                list.add(versionName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("ES\u67e5\u8be2\u5931\u8d25" + e);
        }
        return list;
    }

    public String getLastMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) - 1);
        date = calendar.getTime();
        String accDate = format.format(date);
        return accDate;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

