/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bedget.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.service.IMaterialrequirementsdetailService;
import com.ejianc.business.bedget.vo.MaterialrequirementsdetailVO;
import com.ejianc.business.utils.StringFormatUtil;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"materialrequirementsExport"})
public class ExcelMaterialrequirementsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialrequirementsdetailService materialrequirementsdetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @RequestMapping(value={"/downloadmaterialrequirements"})
    @ResponseBody
    public void downloadMaterialrequirement(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"materialrequirementsdetail-import.xlsx", (String)"\u7269\u8d44\u9700\u6c42\u603b\u8ba1\u5212\u6e05\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportmaterialrequirements"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterialrequirement(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MaterialrequirementsdetailVO> successList = new ArrayList<MaterialrequirementsdetailVO>();
        ArrayList<MaterialrequirementsdetailVO> errorList = new ArrayList<MaterialrequirementsdetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        HashMap<String, String> map = new HashMap<String, String>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 2; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MaterialrequirementsdetailVO materialrequirementsdetailVO = new MaterialrequirementsdetailVO();
                materialrequirementsdetailVO.setId(IdWorker.getId());
                materialrequirementsdetailVO.setSort(String.valueOf(i - 1));
                materialrequirementsdetailVO.setBillCode((String)datas.get(0));
                materialrequirementsdetailVO.setName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                materialrequirementsdetailVO.setSpec(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                materialrequirementsdetailVO.setMeasuringUnit(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                materialrequirementsdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? (String)datas.get(8) : null);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0))) || datas.get(0) == null) {
                    materialrequirementsdetailVO.setErrorMsg("\u7269\u8d44\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialrequirementsdetailVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1))) || datas.get(1) == null) {
                    materialrequirementsdetailVO.setErrorMsg("\u7269\u8d44\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialrequirementsdetailVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(4))) || datas.get(4) == null) {
                    materialrequirementsdetailVO.setErrorMsg("\u57fa\u7840\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialrequirementsdetailVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5))) || datas.get(5) == null) {
                    materialrequirementsdetailVO.setErrorMsg("\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialrequirementsdetailVO);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6))) || datas.get(6) == null) {
                    materialrequirementsdetailVO.setErrorMsg("\u88c5\u4fee\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(materialrequirementsdetailVO);
                    continue;
                }
                CommonResponse back0 = this.shareMaterialApi.queryMaterialByCode((String)datas.get(0));
                try {
                    if (back0.getCode() == 1 || back0.getData() == null) {
                        materialrequirementsdetailVO.setErrorMsg("\u672a\u67e5\u8be2\u5230\u8be5\u7269\u8d44\u7f16\u7801\u4e0b\u7684\u7269\u8d44\u8be6\u60c5");
                        errorList.add(materialrequirementsdetailVO);
                    }
                    if (StringUtils.isNotBlank((CharSequence)((MaterialVO)back0.getData()).getName()) && !((MaterialVO)back0.getData()).getName().equals(datas.get(1))) {
                        materialrequirementsdetailVO.setErrorMsg("\u7269\u8d44\u540d\u79f0\u672a\u5728\u5e93\u4e2d,\u8bf7\u68c0\u67e5\uff01");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)((MaterialVO)back0.getData()).getSpec()) && !((MaterialVO)back0.getData()).getSpec().equals(datas.get(2))) {
                        materialrequirementsdetailVO.setErrorMsg("\u7269\u8d44\u89c4\u683c\u672a\u5728\u5e93\u4e2d,\u8bf7\u68c0\u67e5\uff01");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)((MaterialVO)back0.getData()).getUnitName()) && !((MaterialVO)back0.getData()).getUnitName().equals(datas.get(3))) {
                        materialrequirementsdetailVO.setErrorMsg("\u8ba1\u91cf\u5355\u4f4d\u672a\u5728\u5e93\u4e2d,\u8bf7\u68c0\u67e5\uff01");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }
                    String data0 = (String)map.get(datas.get(0));
                    if (map.get(data0) != null && StringUtils.isNotEmpty((CharSequence)data0) && data0.equals(datas.get(0))) {
                        materialrequirementsdetailVO.setErrorMsg("\u7269\u8d44\u7f16\u7801\u91cd\u590d,\u8bf7\u68c0\u67e5\uff01");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }
                    String materConcat = materialrequirementsdetailVO.getName().concat(materialrequirementsdetailVO.getSpec()).concat(materialrequirementsdetailVO.getMeasuringUnit());
                    if (map.get(materConcat) != null) {
                        materialrequirementsdetailVO.setErrorMsg("\u7269\u8d44\u540d\u79f0,\u7269\u8d44\u89c4\u683c,\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u91cd\u590d");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }
                    map.put(materConcat, materConcat);
                    if (datas.get(4) != null && !StringFormatUtil.validateNumber((String)datas.get(4))) {
                        materialrequirementsdetailVO.setErrorMsg("\u57fa\u7840\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }
                    materialrequirementsdetailVO.setBase(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new BigDecimal((String)datas.get(4)) : null);
                    if (datas.get(5) != null && !StringFormatUtil.validateNumber((String)datas.get(5))) {
                        materialrequirementsdetailVO.setErrorMsg("\u4e3b\u4f53\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }
                    materialrequirementsdetailVO.setMain(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                    if (datas.get(6) != null && !StringFormatUtil.validateNumber((String)datas.get(6))) {
                        materialrequirementsdetailVO.setErrorMsg("\u88c5\u4fee\u8f93\u5165\u683c\u5f0f\u9519\u8bef\uff01");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }
                    materialrequirementsdetailVO.setDecorate(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : null);
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)datas.get(8))) && !StringFormatUtil.validateNumber((String)datas.get(8))) {
                        materialrequirementsdetailVO.setErrorMsg("\u5176\u4ed6\u6570\u91cf\u8f93\u5165\u683c\u5f0f\u9519\u8bef");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }
                    materialrequirementsdetailVO.setOtherNum(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                    BigDecimal subCount = new BigDecimal(0);
                    if (datas.get(7) == null || StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(7)))) {
                        subCount = new BigDecimal((String)datas.get(4)).add(new BigDecimal((String)datas.get(5))).add(new BigDecimal((String)datas.get(6)));
                        materialrequirementsdetailVO.setSubtotal(subCount);
                    } else {
                        subCount = new BigDecimal((String)datas.get(7));
                        materialrequirementsdetailVO.setSubtotal(new BigDecimal((String)datas.get(7)));
                    }
                    if (datas.get(9) == null || StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(9)))) {
                        materialrequirementsdetailVO.setTotal(subCount.add(new BigDecimal((String)datas.get(8))));
                    } else {
                        materialrequirementsdetailVO.setTotal(new BigDecimal((String)datas.get(9)));
                    }
                    successList.add(materialrequirementsdetailVO);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error(e.getMessage());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportmaterialrequirementsFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody MaterialrequirementsdetailVO materialrequirementsdetailVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)String.valueOf(materialrequirementsdetailVO.getId()));
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.materialrequirementsdetailService.list((Wrapper)queryWrapper);
        List mapList = BeanMapper.mapList((Iterable)list, MaterialrequirementsdetailVO.class);
        HashMap beans = new HashMap();
        ArrayList<MaterialrequirementsdetailVO> materialrequirementsdetailVOArrayList = new ArrayList<MaterialrequirementsdetailVO>();
        if (mapList != null && mapList.size() > 0) {
            for (int i = 0; i < mapList.size(); ++i) {
                MaterialrequirementsdetailVO vo = (MaterialrequirementsdetailVO)((Object)mapList.get(i));
                vo.setSort(String.valueOf(i + 1));
                materialrequirementsdetailVOArrayList.add(vo);
            }
        }
        beans.put("records", materialrequirementsdetailVOArrayList);
        ExcelExport.getInstance().export("materialrequirementsdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportmaterialrequirementsFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<MaterialrequirementsdetailVO> list, HttpServletResponse response) {
        HashMap beans = new HashMap();
        ArrayList<MaterialrequirementsdetailVO> materialrequirementsdetailVOArrayList = new ArrayList<MaterialrequirementsdetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                MaterialrequirementsdetailVO materialrequirementsdetailVO = list.get(i);
                materialrequirementsdetailVO.setSort(String.valueOf(i + 1));
                materialrequirementsdetailVOArrayList.add(materialrequirementsdetailVO);
            }
        }
        beans.put("records", materialrequirementsdetailVOArrayList);
        ExcelExport.getInstance().export("materialrequirementsdetail-export.xlsx", beans, response);
    }
}

