package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.*;
import com.ejianc.business.bedget.service.*;
import com.ejianc.business.bedget.vo.ContrastanalysisdetailVO;
import com.ejianc.business.record.bean.RecordContrastanalysistEntity;
import com.ejianc.business.record.service.IRecordContrastanalysistService;
import com.ejianc.business.record.vo.RecordContrastanalysistVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.vo.ContrastanalysisVO;

/**
 * 对比分析表
 *
 * @author generator
 */
@Controller
@RequestMapping("contrastanalysis")
public class ContrastanalysisController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanager-contrastanalysis";//此处需要根据实际修改

    @Autowired
    private IContrastanalysisService service;
    @Autowired
    private IQuotasummaryService quotasummaryService;
    @Autowired
    private IContrastanalysisdetailsService contrastanalysisdetailsService;
    @Autowired
    private IDesignestimateService designestimateService;
    @Autowired
    private IConsdrawbudgettotalService consdrawbudgettotalService;
    @Autowired
    private IQuotasummarydetailService quotasummarydetailService;
    @Autowired
    private IDesignestimatedetailService designestimatedetailService;
    @Autowired
    private IConsdrawbudgettotaldetailService consdrawbudgettotaldetailService;
    @Autowired
    private IRecordContrastanalysistService recordContrastanalysistService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContrastanalysisVO> saveOrUpdate(@RequestBody ContrastanalysisVO saveorUpdateVO) {
        //1.校验（一个项目只能有一个对比分析表）
        //创建条件构造器
        QueryWrapper<ContrastanalysisEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", saveorUpdateVO.getProjectId());
        queryWrapper.eq("dr", "0");
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() != 0) {
            queryWrapper.ne("id", saveorUpdateVO.getId());
        }
        List<ContrastanalysisEntity> pro = service.list(queryWrapper);
        if (pro != null && pro.size() > 0) {
            throw new BusinessException("一个项目只能有一个对比分析表");
        }

        ContrastanalysisEntity entity = BeanMapper.map(saveorUpdateVO, ContrastanalysisEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        ContrastanalysisVO vo = BeanMapper.map(entity, ContrastanalysisVO.class);
        vo.setContrastanalysisdetailEntities(createTreeData(vo.getContrastanalysisdetailEntities()));
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContrastanalysisVO> queryDetail(Long id) {
        ContrastanalysisEntity entity = service.selectById(id);
        ContrastanalysisVO vo = BeanMapper.map(entity, ContrastanalysisVO.class);

        vo.setContrastanalysisdetailEntities(createTreeData(vo.getContrastanalysisdetailEntities()));

        //当前单据变更过则显示变更记录
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper<RecordContrastanalysistEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("contrastanalysis_id", vo.getId());
            List<RecordContrastanalysistEntity> records = recordContrastanalysistService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordContrastanalysistList(BeanMapper.mapList(records, RecordContrastanalysistVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContrastanalysisVO> vos) {
        service.removeByIds(vos.stream().map(ContrastanalysisVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContrastanalysisVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ContrastanalysisEntity> page = service.queryPage(param, false);
        IPage<ContrastanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContrastanalysisVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ContrastanalysisEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<ContrastanalysisVO> contrastanalysisVOList = BeanMapper.mapList(list, ContrastanalysisVO.class);
        for (int i = 0; i < contrastanalysisVOList.size(); i++) {
            ContrastanalysisVO contrastanalysisVO = contrastanalysisVOList.get(i);
            contrastanalysisVO.setSort(Long.parseLong(String.valueOf(i + 1)));
            if (contrastanalysisVO.getCreateTime() != null) {
                contrastanalysisVO.setCreateTimeShow(DateUtils.dateSimple2(contrastanalysisVO.getCreateTime()));
            }
            String billStateStr = contrastanalysisVO.getBillState().toString();
            String changeState = contrastanalysisVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                contrastanalysisVO.setBillStateStr(billStateStr);
            }

            if (changeState != null) {
                if ("1".equals(changeState)) {//1:未变更
                    changeState = "未变更";
                } else if ("2".equals(changeState)) {//2:变更中
                    changeState = "变更中";
                } else if ("3".equals(changeState)) {//3:已变更
                    changeState = "已变更";
                }

                contrastanalysisVO.setChangeState(changeState);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", contrastanalysisVOList);
        ExcelExport.getInstance().export("Contrastanalysis-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refContrastanalysisData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContrastanalysisVO>> refContrastanalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ContrastanalysisEntity> page = service.queryPage(param, false);
        IPage<ContrastanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContrastanalysisVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param projectId
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetailList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ContrastanalysisdetailVO>> queryDetailList(Long id, Long projectId) {
        //校验项目唯一性
        QueryWrapper<ContrastanalysisEntity> queryWrapperProject = new QueryWrapper<>();
        queryWrapperProject.eq("project_id", projectId);
        queryWrapperProject.eq("dr", 0);
        if(id != null && id != 0){
            queryWrapperProject.ne("id", id);
        }
        List<ContrastanalysisEntity> entityList = service.list(queryWrapperProject);
        if(entityList != null && entityList.size() > 0){
            throw new BusinessException("该项目已经创建一个对比分析表，不允许重复创建！");
        }

        List<ContrastanalysisdetailVO> vo = new ArrayList<>();
        //查询固定表格的数据
        List<ContrastanalysisdetailsEntity> contrastanalysisdetailsEntity = contrastanalysisdetailsService.list();
        //根据项目id查询限额设计汇总表数据
        QueryWrapper<QuotasummaryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("dr", 0);
        QuotasummaryEntity quotasummaryEntity = quotasummaryService.getOne(queryWrapper);
        //根据项目id查询限设计概算数据
        QueryWrapper<DesignestimateEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("project_id", projectId);
        queryWrapper1.eq("dr", 0);
        DesignestimateEntity designestimateEntity = designestimateService.getOne(queryWrapper1);
        //根据项目id查询限施工图预算汇总数据
        QueryWrapper<ConsdrawbudgettotalEntity> queryWrapper2 = new QueryWrapper<>();
        queryWrapper2.eq("project_id", projectId);
        queryWrapper2.eq("dr", 0);
        ConsdrawbudgettotalEntity consdrawbudgettotalEntity = consdrawbudgettotalService.getOne(queryWrapper2);
        for (ContrastanalysisdetailsEntity entity : contrastanalysisdetailsEntity) {
            ContrastanalysisdetailVO contrastanalysisdetailVO = new ContrastanalysisdetailVO();
            contrastanalysisdetailVO.setId(IdWorker.getId());
            contrastanalysisdetailVO.setSort(entity.getSort());
            contrastanalysisdetailVO.setCode(entity.getCode());
            contrastanalysisdetailVO.setName(entity.getName());
            contrastanalysisdetailVO.setTid(entity.getTid());
            contrastanalysisdetailVO.setTpid(entity.getTpid());

            //根据固定表中的name和限额设计汇总表id查询汇总子表数据
            if (quotasummaryEntity != null) {
                QueryWrapper<QuotasummarydetailEntity> queryWrapper3 = new QueryWrapper<>();
                queryWrapper3.eq("mid", quotasummaryEntity.getId());
                queryWrapper3.eq("unit_project_name", entity.getName());
                queryWrapper3.eq("dr", 0);
                QuotasummarydetailEntity quotasummarydetailEntity = quotasummarydetailService.getOne(queryWrapper3);

                if (quotasummarydetailEntity != null) {
                    contrastanalysisdetailVO.setQuataDesignTotal(quotasummarydetailEntity.getScale());
                    contrastanalysisdetailVO.setQuotaDesignBudgetTotal(quotasummarydetailEntity.getProjectCost());
                    contrastanalysisdetailVO.setQuotaDesignBudgetPrice(quotasummarydetailEntity.getUnitCost());
                }
            }

            //根据固定表中的name和设计概算表id查询汇总子表数据
            if (designestimateEntity != null) {
                QueryWrapper<DesignestimatedetailEntity> queryWrapper4 = new QueryWrapper<>();
                queryWrapper4.eq("mid", designestimateEntity.getId());
                queryWrapper4.eq("son_item_name", entity.getName());
                queryWrapper4.eq("dr", 0);
                DesignestimatedetailEntity designestimatedetailEntity = designestimatedetailService.getOne(queryWrapper4);

                if (designestimatedetailEntity != null) {
                    contrastanalysisdetailVO.setDesignBugetEstimate(designestimatedetailEntity.getProjectScale());
                    contrastanalysisdetailVO.setDesignBugetEstimateTotal(designestimatedetailEntity.getProjectCost());
                    contrastanalysisdetailVO.setDesignBugetEstimatePrice(designestimatedetailEntity.getUnitCost());
                }
            }

            if (consdrawbudgettotalEntity != null) {
                //根据固定表中的name和施工图预算表id查询汇总子表数据
                QueryWrapper<ConsdrawbudgettotaldetailEntity> queryWrapper5 = new QueryWrapper<>();
                queryWrapper5.eq("mid", consdrawbudgettotalEntity.getId());
                queryWrapper5.eq("project_unit_name", entity.getName());
                queryWrapper5.eq("dr", 0);
                ConsdrawbudgettotaldetailEntity consdrawbudgettotaldetailEntity = consdrawbudgettotaldetailService.getOne(queryWrapper5);

                if (consdrawbudgettotaldetailEntity != null) {
                    BigDecimal projectScale = consdrawbudgettotaldetailEntity.getProjectScale();//工程规模
                    BigDecimal projectCost = consdrawbudgettotaldetailEntity.getProjectCost();//项目造价
                    BigDecimal constructionBugetEstimatePrice = consdrawbudgettotaldetailEntity.getUnitCost();//施工图预算单价

                    contrastanalysisdetailVO.setConstructionBugetEstimate(projectScale);
                    contrastanalysisdetailVO.setConstructionBugetEstimateTotal(projectCost);
                    contrastanalysisdetailVO.setConstructionBugetEstimatePrice(constructionBugetEstimatePrice);
                }
            }

            contrastanalysisdetailVO.setRowState("add");
            vo.add(contrastanalysisdetailVO);
        }
        return CommonResponse.success("查询参照数据成功！", createTreeData(vo));

    }

    public static List<ContrastanalysisdetailVO> createTreeData(List<ContrastanalysisdetailVO> list) {
        List<ContrastanalysisdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ContrastanalysisdetailVO> listMap = new HashMap<>();
        for (ContrastanalysisdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ContrastanalysisdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ContrastanalysisdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ContrastanalysisdetailVO> child = (List<ContrastanalysisdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ContrastanalysisdetailVO> children = new ArrayList<ContrastanalysisdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
