package com.ejianc.business.bedget.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotaldetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgettotaldetailService;
import com.ejianc.business.bedget.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 施工图预算汇总清单导入导出
 */
@Controller
@RequestMapping("consdrawtotalExport")
public class ExeclConsdrawbudgettotalController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IConsdrawbudgettotaldetailService consdrawbudgettotaldetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadConsdrawtotal")
    @ResponseBody
    public void downloadConsdrawtotal(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "consdrawbudgettotaldetail-import.xlsx", "施工图预算汇总清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportConsdrawtotal", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawtotal(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ConsdrawbudgettotaldetailVO> successList = new ArrayList<>();
        List<ConsdrawbudgettotaldetailVO> errorList = new ArrayList<>();
        Map<String, ConsdrawbudgettotaldetailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=2;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String subitemCode = datas.get(0);
                    String section = datas.get(1);
                    String projectUnitName = datas.get(2);
                    String projectCost = datas.get(3);
                    String unitLaborCost = datas.get(4);
                    String unitMaterialCost = datas.get(5);
                    String unitMachineryCost = datas.get(6);
                    String unitBusinessManagerCost = datas.get(7);
                    String unitProfit = datas.get(8);
                    String itemsSubTotal = datas.get(9);
                    String garbageConsumption = datas.get(10);
                    String unilateralMeasuresCost = datas.get(11);
                    String otherItems = datas.get(12);
                    String fees = datas.get(13);
                    String tax = datas.get(14);
                    String costPercent = datas.get(15);
                    String projectScale = datas.get(16);
                    String unitCost = datas.get(17);

                    ConsdrawbudgettotaldetailVO consdrawbudgettotaldetailVO = new ConsdrawbudgettotaldetailVO();
                    consdrawbudgettotaldetailVO.setId(IdWorker.getId());//id
                    consdrawbudgettotaldetailVO.setTid(String.valueOf(IdWorker.getId()));//tid

                    //必填项校验
                    if (subitemCode == null || TextUtils.isEmpty(subitemCode)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("编码不能为空！");
                        errorsMsgBuilder.append("编码不能为空！");
                    }
                    if (section == null || TextUtils.isEmpty(section)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("区段不能为空！");
                        errorsMsgBuilder.append("区段不能为空！");
                    }
                    if (projectUnitName == null || TextUtils.isEmpty(projectUnitName)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("单位工程名称不能为空！");
                        errorsMsgBuilder.append("单位工程名称不能为空！");
                    }
                    if (garbageConsumption == null || TextUtils.isEmpty(garbageConsumption)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("其中：施工垃圾场外晕和消纳费不能为空！");
                        errorsMsgBuilder.append("其中：施工垃圾场外晕和消纳费不能为空！");
                    }
                    if (unilateralMeasuresCost == null || TextUtils.isEmpty(unilateralMeasuresCost)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("单方措施项目合计不能为空！");
                        errorsMsgBuilder.append("单方措施项目合计不能为空！");
                    }
                    if (otherItems == null || TextUtils.isEmpty(otherItems)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("其他项目不能为空！");
                        errorsMsgBuilder.append("其他项目不能为空！");
                    }
                    if (projectScale == null || TextUtils.isEmpty(projectScale)) {
                        consdrawbudgettotaldetailVO.setErrorMsg("工程规模（m²或m）不能为空！");
                        errorsMsgBuilder.append("工程规模（m²或m）不能为空！");
                    }

                    if(subitemCode != null){
                        consdrawbudgettotaldetailVO.setInnercode(subitemCode + "_" + section);//编码、区段、确定唯一性
                        if ("01".equals(subitemCode) && projectUnitName != null && projectUnitName.contains("装饰")) {
                            consdrawbudgettotaldetailVO.setInnercode("a1" + "_" + consdrawbudgettotaldetailVO.getSection());
                        }
                        //判断是否是装饰工程的子节点编码
                        if (subitemCode.length() >= 4) {
                            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
                            String code = subitemCode.substring(0, 4);
                            if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
                                //若是的话，将内码改为a1xx
                                consdrawbudgettotaldetailVO.setInnercode("a1" + subitemCode.substring(2, subitemCode.length()) + "_" + section);
                            }
                        }
                        //1、校验编码是否符合规则--2、4、6、9、9以上
                        if (subitemCode == null || !(subitemCode.length() == 2 || subitemCode.length() == 4 || subitemCode.length() == 6 || subitemCode.length() >= 9)) {
                            consdrawbudgettotaldetailVO.setErrorMsg("编码必须符合：2位、4位、6位、9位或9位以上中任意一规则");
                            errorsMsgBuilder.append("编码必须符合：2位、4位、6位、9位或9位以上中任意一规则！");
                        }
                        consdrawbudgettotaldetailVO.setSubitemCode(subitemCode);

                        //重复性校验
                        ConsdrawbudgettotaldetailVO mapVO = map.get(consdrawbudgettotaldetailVO.getInnercode());
                        if(mapVO == null){
                            map.put(consdrawbudgettotaldetailVO.getInnercode(), consdrawbudgettotaldetailVO);
                        }else {
                            consdrawbudgettotaldetailVO.setErrorMsg("编码已存在！");
                            errorList.add(consdrawbudgettotaldetailVO);
                            errorsMsgBuilder.append("编码已存在！");
                        }
                        consdrawbudgettotaldetailVO.setSubitemCode(subitemCode);

                        //设置父级id
                        String innercode = consdrawbudgettotaldetailVO.getInnercode();
                        String[] innercodeSubArr = innercode.split("_");
                        String innercodeSub = "";
                        String sectionSuf = "";
                        if (innercodeSubArr.length > 1) {
                            innercodeSub = innercodeSubArr[0];
                            sectionSuf = "_" + innercodeSubArr[1];
                        }

                        Long pid = null;
                        if (innercodeSub.length() == 2) {
                            //最上级
                        } else if (innercodeSub.length() == 4) {
                            String pcode = innercodeSub.substring(0, 2) + sectionSuf;
                            //有父节点
                            pid = this.setPid(pcode, map);
                        } else if (innercodeSub.length() == 6) {
                            String pcode = innercodeSub.substring(0, 4) + sectionSuf;
                            //有父节点
                            pid = this.setPid(pcode, map);
                        } else if (innercodeSub.length() > 6) {
                            String pcode = innercodeSub.substring(0, 6) + sectionSuf;
                            //有父节点
                            pid = this.setPid(pcode, map);
                        }

                        if (pid != null) {
                            consdrawbudgettotaldetailVO.setTpid(pid.toString());
                        } else {
                            consdrawbudgettotaldetailVO.setTpid("");
                        }
                    }

                    //格式校验
                    if(!TextUtils.isEmpty(projectCost) && !NumberUtil.isNumber(projectCost)){
                        consdrawbudgettotaldetailVO.setErrorMsg("项目造价格式不正确！");
                        errorsMsgBuilder.append("项目造价格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setProjectCost(StringUtils.isNotBlank(projectCost) ? new BigDecimal(projectCost) : null);
                    }

                    if(!TextUtils.isEmpty(unitLaborCost) && !NumberUtil.isNumber(unitLaborCost)){
                        consdrawbudgettotaldetailVO.setErrorMsg("人工费格式不正确！");
                        errorsMsgBuilder.append("人工费格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setUnitLaborCost(StringUtils.isNotBlank(unitLaborCost) ? new BigDecimal(unitLaborCost) : null); // 人工费(单价)
                    }

                    if(!TextUtils.isEmpty(unitMaterialCost) && !NumberUtil.isNumber(unitMaterialCost)){
                        consdrawbudgettotaldetailVO.setErrorMsg("材料费格式不正确！");
                        errorsMsgBuilder.append("材料费格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setUnitMaterialCost(StringUtils.isNotBlank(unitMaterialCost) ? new BigDecimal(unitMaterialCost) : null); // 材料费(单价)
                    }

                    if(!TextUtils.isEmpty(unitMachineryCost) && !NumberUtil.isNumber(unitMachineryCost)){
                        consdrawbudgettotaldetailVO.setErrorMsg("机械费格式不正确！");
                        errorsMsgBuilder.append("机械费格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setUnitMachineryCost(StringUtils.isNotBlank(unitMachineryCost) ? new BigDecimal(unitMachineryCost) : null); // 机械费(单价)
                    }

                    if(!TextUtils.isEmpty(unitBusinessManagerCost) && !NumberUtil.isNumber(unitBusinessManagerCost)){
                        consdrawbudgettotaldetailVO.setErrorMsg("企业管理费格式不正确！");
                        errorsMsgBuilder.append("企业管理费格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setUnitBusinessManagerCost(StringUtils.isNotBlank(unitBusinessManagerCost) ? new BigDecimal(unitBusinessManagerCost) : null); // 企业管理费(单价)
                    }

                    if(!TextUtils.isEmpty(unitProfit) && !NumberUtil.isNumber(unitProfit)){
                        consdrawbudgettotaldetailVO.setErrorMsg("利润格式不正确！");
                        errorsMsgBuilder.append("利润格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setUnitProfit(StringUtils.isNotBlank(unitProfit) ? new BigDecimal(unitProfit) : null); // 利润(单价)
                    }

                    if(!TextUtils.isEmpty(itemsSubTotal) && !NumberUtil.isNumber(itemsSubTotal)){
                        consdrawbudgettotaldetailVO.setErrorMsg("分部分项合计格式不正确！");
                        errorsMsgBuilder.append("分部分项合计格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setItemsSubTotal(StringUtils.isNotBlank(itemsSubTotal) ? new BigDecimal(itemsSubTotal) : null); // 分部分项合计
                    }

                    if(!TextUtils.isEmpty(garbageConsumption) && !NumberUtil.isNumber(garbageConsumption)){
                        consdrawbudgettotaldetailVO.setErrorMsg("其中：施工垃圾场外晕和消纳费格式不正确！");
                        errorsMsgBuilder.append("其中：施工垃圾场外晕和消纳费格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setGarbageConsumption(StringUtils.isNotBlank(garbageConsumption) ? new BigDecimal(garbageConsumption) : null); //
                    }

                    if(!TextUtils.isEmpty(unilateralMeasuresCost) && !NumberUtil.isNumber(unilateralMeasuresCost)){
                        consdrawbudgettotaldetailVO.setErrorMsg("单方措施项目合计格式不正确！");
                        errorsMsgBuilder.append("单方措施项目合计格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setUnilateralMeasuresCost(StringUtils.isNotBlank(unilateralMeasuresCost) ? new BigDecimal(unilateralMeasuresCost) : null); // 材料费(综合)
                    }

                    if(!TextUtils.isEmpty(otherItems) && !NumberUtil.isNumber(otherItems)){
                        consdrawbudgettotaldetailVO.setErrorMsg("其他项目格式不正确！");
                        errorsMsgBuilder.append("其他项目格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setOtherItems(StringUtils.isNotBlank(otherItems) ? new BigDecimal(otherItems) : null); // 其他项目
                    }

                    if(!TextUtils.isEmpty(fees) && !NumberUtil.isNumber(fees)){
                        consdrawbudgettotaldetailVO.setErrorMsg("规费格式不正确！");
                        errorsMsgBuilder.append("规费格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setFees(StringUtils.isNotBlank(fees) ? new BigDecimal(fees) : null); // 规费
                    }

                    if(!TextUtils.isEmpty(tax) && !NumberUtil.isNumber(tax)){
                        consdrawbudgettotaldetailVO.setErrorMsg("税金格式不正确！");
                        errorsMsgBuilder.append("税金格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setTax(StringUtils.isNotBlank(tax) ? new BigDecimal(tax) : null); // 税金
                    }

                    if(!TextUtils.isEmpty(costPercent) && !NumberUtil.isNumber(costPercent)){
                        consdrawbudgettotaldetailVO.setErrorMsg("占造价比例（%）（仅包括分部分项和单价措施）格式不正确！");
                        errorsMsgBuilder.append("占造价比例（%）（仅包括分部分项和单价措施）格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setCostPercent(StringUtils.isNotBlank(costPercent) ? new BigDecimal(costPercent) : null); // 占造价比例（%）（仅包括分部分项和单价措施）
                    }

                    if(!TextUtils.isEmpty(projectScale) && !NumberUtil.isNumber(projectScale)){
                        consdrawbudgettotaldetailVO.setErrorMsg("工程规模格式不正确！");
                        errorsMsgBuilder.append("工程规模格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setProjectScale(StringUtils.isNotBlank(projectScale) ? new BigDecimal(projectScale) : null); //
                    }

                    if(!TextUtils.isEmpty(unitCost) && !NumberUtil.isNumber(costPercent)){
                        consdrawbudgettotaldetailVO.setErrorMsg("单位造价格式不正确！");
                        errorsMsgBuilder.append("单位造价格式不正确！");
                    }else {
                        consdrawbudgettotaldetailVO.setUnitCost(StringUtils.isNotBlank(unitCost) ? new BigDecimal(unitCost) : null); //
                    }

                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(consdrawbudgettotaldetailVO);
                    }else {
                        successList.add(consdrawbudgettotaldetailVO);
                    }
                }
            }
        }

        //构建树
        List<ConsdrawbudgettotaldetailVO> resList = createTreeData(successList);
        
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        ConsdrawbudgettotalVO resVo = new ConsdrawbudgettotalVO();
        json.put("total", getTotalAmount(resList, resVo));
        return CommonResponse.success(json);
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode, Map<String, ConsdrawbudgettotaldetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        } else {
            //父级没有找到，则继续往上找
            String[] pcodeSubArr = pcode.split("_");
            String pcodeSub = "";
            String sectionSuf = "";//"_" + 区段
            if (pcodeSubArr.length > 1) {
                pcodeSub = pcodeSubArr[0];
                sectionSuf = "_" + pcodeSubArr[1];
            }
            if (pcodeSub.length() == 2) {
                //最上级
                return null;
            } else if (pcodeSub.length() == 4) {
                String ppcode = pcodeSub.substring(0, 2);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() == 6) {
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode + sectionSuf, map);
            } else if (pcodeSub.length() > 6) {
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode + sectionSuf, map);
            } else {
                return null;
            }
        }
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<ConsdrawbudgettotaldetailVO> createTreeData(List<ConsdrawbudgettotaldetailVO> list) {
        List<ConsdrawbudgettotaldetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ConsdrawbudgettotaldetailVO> listMap = new HashMap<>();
        for (ConsdrawbudgettotaldetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ConsdrawbudgettotaldetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ConsdrawbudgettotaldetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ConsdrawbudgettotaldetailVO> child = (List<ConsdrawbudgettotaldetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ConsdrawbudgettotaldetailVO> children = new ArrayList<ConsdrawbudgettotaldetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    private ConsdrawbudgettotalVO getTotalAmount(List<ConsdrawbudgettotaldetailVO> vos, ConsdrawbudgettotalVO resVo) {
        BigDecimal costTotal = new BigDecimal(0);
        BigDecimal itemsSubTotal = new BigDecimal(0);
        BigDecimal measureItemsTotal = new BigDecimal(0);
        BigDecimal otherItemsTotal = new BigDecimal(0);
        BigDecimal feesTotal = new BigDecimal(0);
        BigDecimal taxTotal = new BigDecimal(0);

        for (ConsdrawbudgettotaldetailVO vo : vos) {
            if (vo.getProjectCost() != null) {
                costTotal = costTotal.add(vo.getProjectCost());
            }
            if (vo.getItemsSubTotal() != null) {
                itemsSubTotal = itemsSubTotal.add(vo.getItemsSubTotal());
            }
            if (vo.getGarbageConsumption() != null) {
                measureItemsTotal = measureItemsTotal.add(vo.getGarbageConsumption());
            }
            if (vo.getUnilateralMeasuresCost() != null) {
                measureItemsTotal = measureItemsTotal.add(vo.getUnilateralMeasuresCost());
            }
            if (vo.getOtherItems() != null) {
                otherItemsTotal = otherItemsTotal.add(vo.getOtherItems());
            }

            if (vo.getTax() != null) {
                taxTotal = taxTotal.add(vo.getTax());
            }

            //规费合计
            if (vo.getFees() != null) {
                feesTotal = feesTotal.add(vo.getFees());
            }
        }

        resVo.setCostTotal(costTotal);
        resVo.setItemsSubTotal(itemsSubTotal);
        resVo.setMeasureItemsTotal(measureItemsTotal);
        resVo.setOtherItemsTotal(otherItemsTotal);
        resVo.setFeesTotal(feesTotal);
        resVo.setTaxTotal(taxTotal);
        return resVo;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportConsdrawtotalFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawtotalFromDatabase(@RequestBody ConsdrawbudgettotalVO consdrawbudgettotalVO, HttpServletResponse response) {
        QueryWrapper<ConsdrawbudgettotaldetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", consdrawbudgettotalVO.getId());
        queryWrapper.eq("dr", 0);
        queryWrapper.orderByAsc("subitem_code");
        queryWrapper.orderByAsc("section");
        List<ConsdrawbudgettotaldetailEntity> list = consdrawbudgettotaldetailService.list(queryWrapper);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("consdrawbudgettotaldetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportConsdrawtotalFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawtotalFromPage(@RequestBody List<ConsdrawbudgettotaldetailVO> list, HttpServletResponse response) {
        List<ConsdrawbudgettotaldetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                ConsdrawbudgettotaldetailVO consdrawbudgetdetailVO = list.get(i);
                concatList.add(consdrawbudgetdetailVO);
            }
        }

        //children拍平
        List<ConsdrawbudgettotaldetailVO> allList = handleList(list, concatList);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("consdrawbudgettotaldetail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<ConsdrawbudgettotaldetailVO> handleList(List<ConsdrawbudgettotaldetailVO> list, List<ConsdrawbudgettotaldetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            ConsdrawbudgettotaldetailVO consdrawbudgettotaldetailVO = list.get(i);
            List<ConsdrawbudgettotaldetailVO> children = consdrawbudgettotaldetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
