package com.ejianc.business.bedget.excel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotaanalysisdetailEntity;
import com.ejianc.business.bedget.bean.QuotaanalysisdetailInnateEntity;
import com.ejianc.business.bedget.service.IQuotaanalysisdetailInnateService;
import com.ejianc.business.bedget.service.IQuotaanalysisdetailService;
import com.ejianc.business.bedget.vo.QuotaanalysisVO;
import com.ejianc.business.bedget.vo.QuotaanalysisdetailVO;
import com.ejianc.business.bedget.vo.QuotadesigndetailVO;
import com.ejianc.business.utils.StringFormatUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;



import com.ejianc.framework.core.util.ImportTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * 限额设计指标分析导入导出
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("quotaanalysisExport")
public class ExporQuotaanalysisController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IQuotaanalysisdetailService quotaanalysisdetailService;
    @Autowired
    private IQuotaanalysisdetailInnateService quotaanalysisdetailInnateService;
    
	/********************限额设计指标分析清单表导入导出start**************/
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadQuotaanalysis")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "quotaanalysisdetail-import.xlsx", "限额设计指标分析模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportQuotaanalysis", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<QuotaanalysisdetailVO> successList = new ArrayList<>();
        List<QuotaanalysisdetailVO> errorList = new ArrayList<>();
        Map<String, QuotaanalysisdetailVO> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                //查询固定列
                QueryWrapper<QuotaanalysisdetailInnateEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("dr", "0");
                queryWrapper.orderByAsc("id");
                List<QuotaanalysisdetailInnateEntity> pro = quotaanalysisdetailInnateService.list(queryWrapper);
                boolean isNeedCheck = false;
                if(pro != null && pro.size() > 0){
                    isNeedCheck = true;
                }

                for(int i=1;i<result.size();i++) {
                    int proIndex = i - 1;

                    List<String> datas = result.get(i);
                    QuotaanalysisdetailVO quotaanalysisdetailVO = new QuotaanalysisdetailVO();
                    quotaanalysisdetailVO.setId(IdWorker.getId());

                    String sort = datas.get(0);
                    String name = datas.get(1);
                    String unit = datas.get(2);
                    String tenderProjectNumber = datas.get(3);
                    String buildArea = datas.get(4);
                    String tenderTarget = datas.get(5);
                    String normTarget = datas.get(6);

                    quotaanalysisdetailVO.setName(name); // 分项名称
                    quotaanalysisdetailVO.setUnit(unit); // 单位
                    quotaanalysisdetailVO.setMemo(datas.get(7)); // 备注

                    //校验固定列
                    if(isNeedCheck && proIndex < pro.size()){
                        QuotaanalysisdetailInnateEntity quotaanalysisdetailInnate = pro.get(proIndex);
                        if(!quotaanalysisdetailInnate.getSort().equals(sort)){//校验序号
                            quotaanalysisdetailVO.setErrorMsg("序号与模板不一致，灰色区域不允许改动");
                            errorList.add(quotaanalysisdetailVO);
                            continue;
                        }
                        if(!quotaanalysisdetailInnate.getName().equals(name)){//校验名称
                            quotaanalysisdetailVO.setErrorMsg("名称与模板不一致，灰色区域不允许改动");
                            errorList.add(quotaanalysisdetailVO);
                            continue;
                        }
                        if(!quotaanalysisdetailInnate.getUnit().equals(unit)){//校验单位
                            quotaanalysisdetailVO.setErrorMsg("单位与模板不一致，灰色区域不允许改动");
                            errorList.add(quotaanalysisdetailVO);
                            continue;
                        }
                    }else {
                        if(StringUtils.isEmpty(datas.get(0))) {
                            quotaanalysisdetailVO.setErrorMsg("序号不能为空！");
                            errorList.add(quotaanalysisdetailVO);
                            continue;
                        }
                        if(StringUtils.isEmpty(datas.get(1))) {
                            quotaanalysisdetailVO.setErrorMsg("名称不能为空！");
                            errorList.add(quotaanalysisdetailVO);
                            continue;
                        }
                        if(StringUtils.isEmpty(datas.get(2))) {
                            quotaanalysisdetailVO.setErrorMsg("单位不能为空！");
                            errorList.add(quotaanalysisdetailVO);
                            continue;
                        }
                        if(StringUtils.isEmpty(datas.get(3))) {
                            quotaanalysisdetailVO.setErrorMsg("投标工程量不能为空！");
                            errorList.add(quotaanalysisdetailVO);
                            continue;
                        }
                        if(StringUtils.isEmpty(datas.get(4))) {
                            quotaanalysisdetailVO.setErrorMsg("建筑面积(m²)不能为空！");
                            errorList.add(quotaanalysisdetailVO);
                            continue;
                        }
                        if(StringUtils.isEmpty(datas.get(5))) {
                            quotaanalysisdetailVO.setErrorMsg("投标指标不能为空！");
                            errorList.add(quotaanalysisdetailVO);
                            continue;
                        }
                        if(StringUtils.isEmpty(datas.get(6))) {
                            quotaanalysisdetailVO.setErrorMsg("(计划成本)限额设计指标不能为空！");
                            errorList.add(quotaanalysisdetailVO);
                            continue;
                        }
                    }

                    //数据格式校验
                    if(!StringFormatUtil.validateNumber(sort)){
                        quotaanalysisdetailVO.setErrorMsg("序号数据格式不正确！");
                        errorList.add(quotaanalysisdetailVO);
                        continue;
                    }else {
                        quotaanalysisdetailVO.setSort(StringUtils.isNotBlank(sort) ? sort : null);//序号
                    }

                    if(!StringFormatUtil.validateNumber(tenderProjectNumber)){
                        quotaanalysisdetailVO.setErrorMsg("投标工程量数据格式不正确！");
                        errorList.add(quotaanalysisdetailVO);
                        continue;
                    }else {
                        quotaanalysisdetailVO.setTenderProjectNumber(StringUtils.isNotBlank(tenderProjectNumber)?new Double(tenderProjectNumber):null);//投标工程量
                    }

                    if(!StringFormatUtil.validateNumber(buildArea)){
                        quotaanalysisdetailVO.setErrorMsg("建筑面积数据格式不正确！");
                        errorList.add(quotaanalysisdetailVO);
                        continue;
                    }else {
                        quotaanalysisdetailVO.setBuildArea(StringUtils.isNotBlank(buildArea)?new Double(buildArea):null);
                    }

                    if(!StringFormatUtil.validateNumber(tenderTarget)){
                        quotaanalysisdetailVO.setErrorMsg("投标指标数据格式不正确！");
                        errorList.add(quotaanalysisdetailVO);
                        continue;
                    }else {
                        quotaanalysisdetailVO.setTenderTarget(StringUtils.isNotBlank(tenderTarget)?new BigDecimal(tenderTarget):null); // 投标指标
                    }

                    if(!StringFormatUtil.validateNumber(normTarget)){
                        quotaanalysisdetailVO.setErrorMsg("(计划成本)限额设计指标数据格式不正确！");
                        errorList.add(quotaanalysisdetailVO);
                        continue;
                    }else {
                        quotaanalysisdetailVO.setNormTarget(StringUtils.isNotBlank(normTarget)?new BigDecimal(normTarget):null);//投标工程量
                    }

                    //重复性校验
                    QuotaanalysisdetailVO mapVO = map.get(quotaanalysisdetailVO.getName());
                    if(mapVO == null){
                        map.put(quotaanalysisdetailVO.getName(), quotaanalysisdetailVO);
                    }else {
                        quotaanalysisdetailVO.setErrorMsg("名称不允许重复！");
                        errorList.add(quotaanalysisdetailVO);
                        continue;
                    }
                    successList.add(quotaanalysisdetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/excelExportQuotaanalysisFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportQuotaanalysisFromDatabase(@RequestBody QuotaanalysisVO quotaanalysisVO, HttpServletResponse response) {
        QueryWrapper<QuotaanalysisdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", quotaanalysisVO.getId());
        queryWrapper.eq("dr", 0);
        List<QuotaanalysisdetailEntity> list = quotaanalysisdetailService.list(queryWrapper );
        List<QuotaanalysisdetailVO> voList = BeanMapper.mapList(list, QuotaanalysisdetailVO.class);

        //按序号排序
        Collections.sort(voList, new Comparator<QuotaanalysisdetailVO>() {
            @Override
            public int compare(QuotaanalysisdetailVO o1, QuotaanalysisdetailVO o2) {
                return Integer.parseInt(o1.getSort())- (Integer.parseInt(o2.getSort()));
            }
        });

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("quotaanalysisdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/excelExportQuotaanalysisFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportQuotaanalysisFromPage(@RequestBody List<QuotaanalysisdetailVO> list, HttpServletResponse response) {
        List<QuotaanalysisdetailVO> voList = BeanMapper.mapList(list, QuotaanalysisdetailVO.class);
        if (voList != null && voList.size() > 0) {
            for (int i = 0; i < voList.size(); i++) {
                QuotaanalysisdetailVO quotaanalysisdetailVO = voList.get(i);
                quotaanalysisdetailVO.setSort(String.valueOf(i + 1));
            }
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("quotaanalysisdetail-export.xlsx", beans, response);
    }
}
