package com.ejianc.business.bedget.vo;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.record.vo.RecordQuotaanalysisVO;
import com.ejianc.business.record.vo.RecordquotasummaryVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.bedget.vo.QuotasummarydetailVO;
import com.ejianc.business.bedget.vo.SubpackagedetailVO;

/**
 * 限额设计汇总
 * 
 * @author generator
 * 
 */
public class QuotasummaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long operatorId; // 经办人id
    private String operatorName; // 经办人名称
    private java.math.BigDecimal costTotal; // 造价合计
    private java.math.BigDecimal partialItemTotal; // 分部分项合计
    private java.math.BigDecimal otherItemsTotal; // 其他项目合计
    private java.math.BigDecimal feesTotal; // 规费合计
    private java.math.BigDecimal taxTotal; // 税金合计
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private java.math.BigDecimal measuresItemTotal; // 措施项目合计

    private String sort;
    private String billStateStr;
    private String createTimeShow;
    private List<QuotasummarydetailVO> quotasummarydetailEntities = new ArrayList<>(); // 限额设计汇总子表
    private List<RecordquotasummaryVO> recordquotasummaryList = new ArrayList<>(); // 历史信

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 经办人id
     */
    public Long getOperatorId() {
        return operatorId;
    }

    /**
     * 经办人id
     */
    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    /**
     * 经办人名称
     */
    public String getOperatorName() {
        return operatorName;
    }

    /**
     * 经办人名称
     */
    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    /**
     * 造价合计
     */
    public java.math.BigDecimal getCostTotal() {
        return costTotal;
    }

    /**
     * 造价合计
     */
    public void setCostTotal(java.math.BigDecimal costTotal) {
        this.costTotal = costTotal;
    }
    /**
     * 分部分项合计
     */
    public java.math.BigDecimal getPartialItemTotal() {
        return partialItemTotal;
    }

    /**
     * 分部分项合计
     */
    public void setPartialItemTotal(java.math.BigDecimal partialItemTotal) {
        this.partialItemTotal = partialItemTotal;
    }
    /**
     * 其他项目合计
     */
    public java.math.BigDecimal getOtherItemsTotal() {
        return otherItemsTotal;
    }

    /**
     * 其他项目合计
     */
    public void setOtherItemsTotal(java.math.BigDecimal otherItemsTotal) {
        this.otherItemsTotal = otherItemsTotal;
    }
    /**
     * 规费合计
     */
    public java.math.BigDecimal getFeesTotal() {
        return feesTotal;
    }

    /**
     * 规费合计
     */
    public void setFeesTotal(java.math.BigDecimal feesTotal) {
        this.feesTotal = feesTotal;
    }
    /**
     * 税金合计
     */
    public java.math.BigDecimal getTaxTotal() {
        return taxTotal;
    }

    /**
     * 税金合计
     */
    public void setTaxTotal(java.math.BigDecimal taxTotal) {
        this.taxTotal = taxTotal;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 变更单据id
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更单据id
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public String getChangeState() {
        return changeState;
    }

    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    /**
     * 措施项目合计
     */
    public java.math.BigDecimal getMeasuresItemTotal() {
        return measuresItemTotal;
    }

    /**
     * 措施项目合计
     */
    public void setMeasuresItemTotal(java.math.BigDecimal measuresItemTotal) {
        this.measuresItemTotal = measuresItemTotal;
    }
    
     /**
      * 限额设计汇总子表
      */
     public List<QuotasummarydetailVO> getQuotasummarydetailEntities() {
        return quotasummarydetailEntities;
     }

     /**
      * 限额设计汇总子表
      */
     public void setQuotasummarydetailEntities(List<QuotasummarydetailVO> quotasummarydetailEntities) {
        this.quotasummarydetailEntities = quotasummarydetailEntities;
     }

    public List<RecordquotasummaryVO> getRecordquotasummaryList() {
        return recordquotasummaryList;
    }

    public void setRecordquotasummaryList(List<RecordquotasummaryVO> recordquotasummaryList) {
        this.recordquotasummaryList = recordquotasummaryList;
    }
}
