package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.ejianc.business.bedget.bean.ConsdrawbudgettotalEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgettotalService;
import com.ejianc.business.bedget.vo.ConsdrawbudgettotaldetailVO;
import com.ejianc.business.change.bean.ChangeconsdrawbudgettotalEntity;
import com.ejianc.business.change.service.IChangeconsdrawbudgettotalService;
import com.ejianc.business.change.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;



/**
 * 施工预算图汇总表变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changeconsdrawbudgettotal")
public class ChangeconsdrawbudgettotalController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "change-budgetmanage-consdrawbudget_total";//此处需要根据实际修改

    @Autowired
    private IChangeconsdrawbudgettotalService service;
    @Autowired
    private IConsdrawbudgettotalService consdrawbudgettotalService;

    /**
     * 初始化更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetailByConsdrawtotalId")
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgettotalVO> queryDetailByConsdrawtotalId(@RequestParam(value = "consdrawtotalId") Long consdrawtotalId) {
        ConsdrawbudgettotalEntity consdrawbudgettotalEntity = consdrawbudgettotalService.selectById(consdrawtotalId);
        ChangeconsdrawbudgettotalVO changeVO = BeanMapper.map(consdrawbudgettotalEntity, ChangeconsdrawbudgettotalVO.class);
        Long id = IdWorker.getId();
        changeVO.setOriginalId(consdrawtotalId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        //施工图预算汇总清单
        List<ChangeconsdrawbudgettotaldetailVO> changeconsdrawbudgettotaldetailEntities = changeVO.getConsdrawbudgettotaldetailEntities();
        if(changeconsdrawbudgettotaldetailEntities!=null&&changeconsdrawbudgettotaldetailEntities.size()>0){
            List<ChangeconsdrawbudgettotaldetailVO> changedesignestimatedetailVOS = new ArrayList<>();
            for(ChangeconsdrawbudgettotaldetailVO vo : changeconsdrawbudgettotaldetailEntities){
                vo.setChangeMid(id);
                vo.setOriginalId(consdrawtotalId);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changedesignestimatedetailVOS.add(vo);
            }

            changeVO.setConsdrawbudgettotaldetailEntities(handleChildren(changeconsdrawbudgettotaldetailEntities));
        }

        return CommonResponse.success("查询详情成功！", changeVO);

    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgettotalVO> saveChange(@RequestBody ChangeconsdrawbudgettotalVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgettotalVO> saveOrUpdate(@RequestBody ChangeconsdrawbudgettotalVO saveorUpdateVO) {
    	ChangeconsdrawbudgettotalEntity entity = BeanMapper.map(saveorUpdateVO, ChangeconsdrawbudgettotalEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ChangeconsdrawbudgettotalVO vo = BeanMapper.map(entity, ChangeconsdrawbudgettotalVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangeconsdrawbudgettotalVO> queryDetail(Long id) {
    	ChangeconsdrawbudgettotalEntity entity = service.selectById(id);
    	ChangeconsdrawbudgettotalVO vo = BeanMapper.map(entity, ChangeconsdrawbudgettotalVO.class);
        //构建树形结构
        List<ChangeconsdrawbudgettotaldetailVO> consdrawbudgettotaldetailVOList = vo.getConsdrawbudgettotaldetailEntities();
        vo.setConsdrawbudgettotaldetailEntities(handleChildren(consdrawbudgettotaldetailVOList));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeconsdrawbudgettotalVO> vos) {
        return service.delete(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangeconsdrawbudgettotalVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangeconsdrawbudgettotalEntity> page = service.queryPage(param,false);
        IPage<ChangeconsdrawbudgettotalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeconsdrawbudgettotalVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangeconsdrawbudgettotalEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Changeconsdrawbudgettotal-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refChangeconsdrawbudgettotalData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangeconsdrawbudgettotalVO>> refChangeconsdrawbudgettotalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangeconsdrawbudgettotalEntity> page = service.queryPage(param,false);
        IPage<ChangeconsdrawbudgettotalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangeconsdrawbudgettotalVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 对子表做排序、构建树等处理
     *
     * @param voList
     */
    private List<ChangeconsdrawbudgettotaldetailVO> handleChildren(List<ChangeconsdrawbudgettotaldetailVO> voList) {
        //按子目编码排序
        Collections.sort(voList, new Comparator<ChangeconsdrawbudgettotaldetailVO>() {
            @Override
            public int compare(ChangeconsdrawbudgettotaldetailVO o1, ChangeconsdrawbudgettotaldetailVO o2) {
                return (o1.getSubitemCode()+o1.getSection()).compareTo(o2.getSubitemCode()+o2.getSection());
            }
        });

        //构建树
        voList = createTreeData(voList);

        return voList;
    }
    public static List<ChangeconsdrawbudgettotaldetailVO> createTreeData(List<ChangeconsdrawbudgettotaldetailVO> list) {
        List<ChangeconsdrawbudgettotaldetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangeconsdrawbudgettotaldetailVO> listMap = new HashMap<>();
        for (ChangeconsdrawbudgettotaldetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ChangeconsdrawbudgettotaldetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ChangeconsdrawbudgettotaldetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ChangeconsdrawbudgettotaldetailVO> child = (List<ChangeconsdrawbudgettotaldetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ChangeconsdrawbudgettotaldetailVO> children = new ArrayList<ChangeconsdrawbudgettotaldetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
