package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.ejianc.business.bedget.bean.QuotadesignEntity;
import com.ejianc.business.bedget.bean.QuotadesigndetailEntity;
import com.ejianc.business.bedget.service.IQuotadesignService;
import com.ejianc.business.change.bean.ChangequotadesignEntity;
import com.ejianc.business.change.service.IChangequotadesignService;
import com.ejianc.business.change.vo.ChangequotadesignVO;
import com.ejianc.business.change.vo.ChangequotadesigndetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;



/**
 * 限额设计表变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changequotadesign")
public class ChangequotadesignController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "change-budgetmanage-quotadesign";//此处需要根据实际修改

    @Autowired
    private IChangequotadesignService service;
    @Autowired
    private IQuotadesignService quotadesignService;

    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @GetMapping(value = "queryDetailByOriginalId")
    @ResponseBody
    public CommonResponse<ChangequotadesignVO> queryDetailByOriginalId(@RequestParam(value = "originalId") Long originalId) {
        QuotadesignEntity quotadesignVO = quotadesignService.selectById(originalId);
        ChangequotadesignVO changeVO = BeanMapper.map(quotadesignVO, ChangequotadesignVO.class);
        Long id = IdWorker.getId();
        changeVO.setOriginalId(originalId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        //子表
        List<QuotadesigndetailEntity> quotadesigndetailList = quotadesignVO.getQuotadesigndetailEntities();
        if(quotadesigndetailList!=null&&quotadesigndetailList.size()>0){
            List<ChangequotadesigndetailVO> changequotadesigndetailVos = new ArrayList<>();
            for(QuotadesigndetailEntity entity : quotadesigndetailList){
                ChangequotadesigndetailVO vo = BeanMapper.map(entity, ChangequotadesigndetailVO.class);
                vo.setMid(id);
                vo.setOriginalId(entity.getId());
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changequotadesigndetailVos.add(vo);
            }

            //构建树形结构
            List<ChangequotadesigndetailVO> resChangequotadesigndetailVOList = createTreeData(changequotadesigndetailVos);
            changeVO.setQuotadesigndetailEntities(resChangequotadesigndetailVOList);
        }

        return CommonResponse.success("查询详情成功！", changeVO);

    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangequotadesignVO> saveOrUpdate(@RequestBody ChangequotadesignVO saveOrUpdateVO) {
        return service.saveChange(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangequotadesignVO> queryDetail(Long id) {
    	ChangequotadesignEntity entity = service.selectById(id);
    	ChangequotadesignVO vo = BeanMapper.map(entity, ChangequotadesignVO.class);

        //构建树形结构
        List<ChangequotadesigndetailVO> quotadesigndetailVO = vo.getQuotadesigndetailEntities();
        List<ChangequotadesigndetailVO> resQuotadesigndetailVO = createTreeData(quotadesigndetailVO);
        vo.setQuotadesigndetailEntities(resQuotadesigndetailVO);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangequotadesignVO> vos) {
        return service.delete(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangequotadesignVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangequotadesignEntity> page = service.queryPage(param,false);
        IPage<ChangequotadesignVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangequotadesignVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangequotadesignEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Changequotadesign-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refChangequotadesignData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangequotadesignVO>> refChangequotadesignData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangequotadesignEntity> page = service.queryPage(param,false);
        IPage<ChangequotadesignVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangequotadesignVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 页面新增后重新构建树
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/refreshData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> refreshData(@RequestBody List<ChangequotadesigndetailVO> list, HttpServletResponse response) {
        JSONObject json = new JSONObject();
        Map<String,ChangequotadesigndetailVO> map = new HashMap<>();
        ChangequotadesigndetailVO add = list.get(list.size() - 1);
        add.setId(IdWorker.getId());
        add.setTid(String.valueOf(IdWorker.getId()));
        add.setRowState("edit");
        add.setInnercode(add.getSonItemCode());
        if("01".equals(add.getSonItemCode())&&add.getSonItemName().contains("装饰")){
            add.setInnercode("a1");
        }
        //判断是否是装饰工程的子节点编码
        if(add.getSonItemCode().length()>=4){
            //0111、0112、0113、0114、0115这五个节点都是装饰工程下的
            String code = add.getSonItemCode().substring(0,4);
            if("0111".equals(code)||"0112".equals(code)||"0113".equals(code)||"0114".equals(code)||"0115".equals(code)){
//	    		若是的话，将内码改为a1xx
                add.setInnercode("a1"+add.getSonItemCode().substring(2,add.getSonItemCode().length()));
            }
        }
        for(ChangequotadesigndetailVO vo : list){
            map.put(vo.getInnercode(), vo);
            if(!add.getId().equals(vo.getId()) && add.getInnercode().equals(vo.getInnercode())){
                throw new BusinessException("子目编码已存在，请重新填写");
            }
        }
        //设置父级id
        for(ChangequotadesigndetailVO vo : list){
            String innercode = vo.getInnercode();
            Long pid = null;
            if(innercode.length()==2){
                //最上级
            }else if(innercode.length()==4){
                String pcode = innercode.substring(0, 2);
                //有父节点
                pid = this.setPid(pcode, map);

            }else if(innercode.length()==6){
                String pcode = innercode.substring(0, 4);
                //有父节点
                pid = this.setPid(pcode, map);
            }else if(innercode.length()>6){
                String pcode = innercode.substring(0, 6);
                //有父节点
                pid = this.setPid(pcode, map);
            }

            if(pid != null){
                vo.setTpid(pid.toString());
            }else {
                vo.setTpid("");
            }
        }

        //清空父级部分数据
        list = clearPData(add, list);

        //按子目编码排序
        Collections.sort(list, new Comparator<ChangequotadesigndetailVO>() {
            @Override
            public int compare(ChangequotadesigndetailVO o1, ChangequotadesigndetailVO o2) {
                return o1.getSonItemCode().compareTo(o2.getSonItemCode());
            }
        });
        //构建树
        List<ChangequotadesigndetailVO> result = createTreeData(list);

        json.put("dataSource", result);
        return CommonResponse.success(json);
    }

    private List<ChangequotadesigndetailVO> clearPData(ChangequotadesigndetailVO handleVO, List<ChangequotadesigndetailVO> list) {
        if(list == null || list.size() == 0){
            return null;
        }

        String pid = handleVO.getTpid();
        if(pid == null || TextUtils.isEmpty(pid)){
            return list;
        }

        for (int i = 0; i < list.size(); i++) {
            ChangequotadesigndetailVO vo = list.get(i);
            if(pid.equals(vo.getTid())){
                //清空父级单价和工程量
                vo.setEngineering(null);
                vo.setLabor(null);
                vo.setMaterial(null);
                vo.setMechanical(null);
                vo.setManagement(null);
                vo.setProfit(null);
                vo.setUnitPrice(null);

                if(vo.getTpid() != null && !TextUtils.isEmpty(vo.getTpid())){
                    clearPData(vo, list);
                    break;
                }
                break;
            }
        }

        return list;
    }

    //子目编码规则定死------分别是2位/4位/6位/6为以上
    private Long setPid(String pcode,Map<String,ChangequotadesigndetailVO> map){
        if(map.get(pcode)!=null){
            return Long.valueOf(map.get(pcode).getTid());
        }else{
            //父级没有找到，则继续往上找
            if(pcode.length()==2){
                //最上级
                return null;
            }else if(pcode.length()==4){
                String ppcode = pcode.substring(0, 2);
                return this.setPid(ppcode, map);
            }else if(pcode.length()==6){
                String ppcode = pcode.substring(0, 4);
                return this.setPid(ppcode, map);
            }else if(pcode.length()>6){
                String ppcode = pcode.substring(0, 6);
                return this.setPid(ppcode, map);
            }else{
                return null;
            }
        }
    }

    public static List<ChangequotadesigndetailVO> createTreeData(List<ChangequotadesigndetailVO> list) {
        List<ChangequotadesigndetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangequotadesigndetailVO> listMap = new HashMap<>();
        for(ChangequotadesigndetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangequotadesigndetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangequotadesigndetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangequotadesigndetailVO> child = (List<ChangequotadesigndetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangequotadesigndetailVO> children = new ArrayList<ChangequotadesigndetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
