package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.DesignestimateEntity;
import com.ejianc.business.bedget.bean.QuotadesignEntity;
import com.ejianc.business.bedget.service.IDesignestimateService;
import com.ejianc.business.bedget.service.IQuotadesignService;
import com.ejianc.business.change.bean.ChangedesignestimateEntity;
import com.ejianc.business.change.bean.ChangedesignestimatedetailEntity;
import com.ejianc.business.change.bean.ChangequotadesignEntity;
import com.ejianc.business.change.mapper.ChangedesignestimateMapper;
import com.ejianc.business.change.service.IChangedesignestimateService;
import com.ejianc.business.change.vo.ChangedesignestimateVO;
import com.ejianc.business.change.vo.ChangedesignestimatedetailVO;
import com.ejianc.business.change.vo.ChangequotadesignVO;
import com.ejianc.business.change.vo.ChangequotadesigndetailVO;
import com.ejianc.business.record.bean.RecorddesignestimateEntity;
import com.ejianc.business.record.bean.RecordquotadesignEntity;
import com.ejianc.business.record.service.IRecorddesignestimateService;
import com.ejianc.business.record.service.IRecordquotadesignService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 设计概算变更
 * 
 * @author generator
 * 
 */
@Service("changedesignestimateService")
public class ChangedesignestimateServiceImpl extends BaseServiceImpl<ChangedesignestimateMapper, ChangedesignestimateEntity> implements IChangedesignestimateService {
    @Autowired
    private IDesignestimateService designestimateService;

    @Autowired
    private IRecorddesignestimateService recorddesignestimateService;
    @Override
    public CommonResponse<ChangedesignestimateVO> saveChange(ChangedesignestimateVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangedesignestimateEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangedesignestimateEntity entity = BeanMapper.map(saveOrUpdateVO, ChangedesignestimateEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangedesignestimateEntity> queryWrapper = new QueryWrapper<ChangedesignestimateEntity>();
        queryWrapper.eq("designestimate_id", saveOrUpdateVO.getDesignestimateId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1,3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangedesignestimateEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //设计概算指标分析子表
        this.saveOrUpdate(entity, false);

        ChangedesignestimateVO vo = BeanMapper.map(entity, ChangedesignestimateVO.class);
        vo.setDesignestimatedetailEntities(saveOrUpdateVO.getDesignestimatedetailEntities());
        vo.setRecorddesignestimateList(saveOrUpdateVO.getRecorddesignestimateList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            DesignestimateEntity designestimateEntity = designestimateService.selectById(vo.getDesignestimateId());
            designestimateEntity.setChangeState("2");//状态改为变更中
            designestimateEntity.setChangeId(vo.getId());
            designestimateService.saveOrUpdate(designestimateEntity, false);
        }

        //构建树形结构
        List<ChangedesignestimatedetailVO> changedesignestimatedetailVOList = vo.getDesignestimatedetailEntities();
        List<ChangedesignestimatedetailVO> resChangedesignestimatedetailVOList = createTreeData(changedesignestimatedetailVOList);
        vo.setDesignestimatedetailEntities(resChangedesignestimatedetailVOList);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    public static List<ChangedesignestimatedetailVO> createTreeData(List<ChangedesignestimatedetailVO> list) {
        List<ChangedesignestimatedetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangedesignestimatedetailVO> listMap = new HashMap<>();
        for(ChangedesignestimatedetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangedesignestimatedetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangedesignestimatedetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangedesignestimatedetailVO> child = (List<ChangedesignestimatedetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangedesignestimatedetailVO> children = new ArrayList<ChangedesignestimatedetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    @Override
    public CommonResponse<String> delete(List<ChangedesignestimateVO> vos) {
        for(ChangedesignestimateVO vo : vos){
            ChangedesignestimateEntity entity = this.getById(vo.getId());
            DesignestimateEntity designestimateEntity = designestimateService.selectById(entity.getDesignestimateId());
            QueryWrapper<RecorddesignestimateEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("designestimate_id", designestimateEntity.getId());
            List<RecorddesignestimateEntity> records = recorddesignestimateService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                designestimateEntity.setChangeState("3");//状态改为已变更
            }else{
                designestimateEntity.setChangeState("1");//状态改为未变更
            }
            designestimateEntity.setChangeId(null);
            designestimateService.saveOrUpdate(designestimateEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangedesignestimateVO::getId).collect(Collectors.toList()),true);

        return CommonResponse.success("删除成功！");
    }
}
