package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotaanalysisEntity;
import com.ejianc.business.bedget.bean.QuotaanalysisdetailEntity;
import com.ejianc.business.bedget.bean.SubpackageEntity;
import com.ejianc.business.bedget.bean.SubpackagedetailEntity;
import com.ejianc.business.bedget.service.ISubpackageService;
import com.ejianc.business.change.bean.ChangeQuotaanalysisEntity;
import com.ejianc.business.change.bean.ChangeQuotaanalysisdetailEntity;
import com.ejianc.business.change.bean.ChangesubpackageEntity;
import com.ejianc.business.change.bean.ChangesubpackagedetailEntity;
import com.ejianc.business.change.service.IChangesubpackageService;
import com.ejianc.business.record.bean.RecordQuotaanalysisEntity;
import com.ejianc.business.record.bean.RecordQuotaanalysisdetailEntity;
import com.ejianc.business.record.bean.RecordsubpackageEntity;
import com.ejianc.business.record.bean.RecordsubpackagedetailEntity;
import com.ejianc.business.record.service.IRecordsubpackageService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changesubpackage") 
public class ChangesubpackageBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Subpackage = "zjkj-subpackage";//分包施工图预算
	private static final String Subpackage_CHANGE = "zjkj-subpackageChange";//分包施工图预算变更
	private static final String Subpackage_RECORD = "zjkj-subpackageRecord";//分包施工图预算变更记录

	//单据类型
	private static final String Subpackage_BILLTYPE_CODE = "BT202202000020";//分包施工图预算
	private static final String Subpackage_CHANGE_BILLTYPE_CODE = "BT202202000039";//分包施工图预算变更
	private static final String Subpackage_RECORD_BILLTYPE_CODE = "BT202202000040";//分包施工图预算变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangesubpackageService changesubpackageService;
	@Autowired
	private ISubpackageService subpackageService;
	@Autowired
	private IRecordsubpackageService recordsubpackageService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("---------进来啦--------");
		//TODO
		//1、获取目前单据信息、变更信息
		ChangesubpackageEntity changeEntity = changesubpackageService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getOriginalId());
		SubpackageEntity subpackageEntity = subpackageService.selectById(changeEntity.getOriginalId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordsubpackageEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("original_id", subpackageEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordsubpackageService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordsubpackageEntity recordRecordsubpackageEntity = BeanMapper.map(subpackageEntity, RecordsubpackageEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordRecordsubpackageEntity);
		recordRecordsubpackageEntity.setBillState(null);
		recordRecordsubpackageEntity.setOriginalId(subpackageEntity.getId());
		recordRecordsubpackageEntity.setSubpackageCode(subpackageEntity.getBillCode()+"-"+(count+1));
		recordRecordsubpackageEntity.setId(recordId);
		recordRecordsubpackageEntity.setBillCode(subpackageEntity.getBillCode());
		recordRecordsubpackageEntity.setChangeReason(changeEntity.getChangeReason());
		recordRecordsubpackageEntity.setEffectDate(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<SubpackagedetailEntity> subpackagedetailEntity = subpackageEntity.getSubpackagedetailEntities();
		if(subpackagedetailEntity!=null&&subpackagedetailEntity.size()>0){
			List<RecordsubpackagedetailEntity> recordsubpackagedetailEntity = new ArrayList<>();
			for(SubpackagedetailEntity entity : subpackagedetailEntity){
				RecordsubpackagedetailEntity reEntity = BeanMapper.map(entity, RecordsubpackagedetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setMid(recordId);
				recordsubpackagedetailEntity.add(reEntity);
				entity.setRowState("del");
			}
			recordRecordsubpackageEntity.setSubpackagedetailEntities(recordsubpackagedetailEntity);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Subpackage_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Subpackage_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(subpackageEntity.getId().toString(), sourceBillType, Subpackage , recordId.toString(), targetBillType, Subpackage_RECORD);
		recordsubpackageService.saveOrUpdate(recordRecordsubpackageEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + subpackageEntity.getCreateUserCode());
		//3、修改当前单据状态
		SubpackageEntity newSubpackageEntity = BeanMapper.map(changeEntity, SubpackageEntity.class);
		newSubpackageEntity.setChangeState("3");//状态改为已变更
		newSubpackageEntity.setChangeId(null);
		newSubpackageEntity.setBillState(subpackageEntity.getBillState());
		newSubpackageEntity.setId(subpackageEntity.getId());
		newSubpackageEntity.setCreateTime(subpackageEntity.getCreateTime());
		newSubpackageEntity.setCreateUserCode(subpackageEntity.getCreateUserCode());
		newSubpackageEntity.setTenantId(subpackageEntity.getTenantId());
		newSubpackageEntity.setVersion(subpackageEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangesubpackagedetailEntity> changesubpackagedetailList = changeEntity.getSubpackagedetailEntities();
		if(changesubpackagedetailList!=null&&changesubpackagedetailList.size()>0){
			List<SubpackagedetailEntity> newQuotaanalysisdetailList = BeanMapper.mapList(changesubpackagedetailList, SubpackagedetailEntity.class);
			newQuotaanalysisdetailList.addAll(subpackagedetailEntity);
			newSubpackageEntity.setSubpackagedetailEntities(newQuotaanalysisdetailList);
		}
		logger.info("---------保存--------");
		subpackageService.saveOrUpdate(newSubpackageEntity, false);

		sourceBillType = Subpackage_CHANGE_BILLTYPE_CODE;
		targetBillType = Subpackage_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Subpackage_CHANGE, subpackageEntity.getId().toString(), targetBillType, Subpackage);
		recordsubpackageService.saveOrUpdate(recordRecordsubpackageEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
