package com.ejianc.business.bedget.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.MaterialanalysisdetailEntity;
import com.ejianc.business.bedget.service.IMaterialanalysisdetailService;
import com.ejianc.business.bedget.vo.MaterialanalysisVO;
import com.ejianc.business.bedget.vo.MaterialanalysisdetailVO;
import com.ejianc.business.bedget.vo.SubpackagematerialanalysisdetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 施工图预算材料分析清单导入导出
 */
@Controller
@RequestMapping("materialanalysisExport")
public class ExeclMaterialanalysisController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialanalysisdetailService materialanalysisdetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadmaterialanalysis")
    @ResponseBody
    public void downloadmaterialanalysis(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "materialanalysisdetail-import.xlsx", "施工图预算材料分析清单模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportmaterialanalysis", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportmaterialanalysis(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MaterialanalysisdetailVO> successList = new ArrayList<>();
        List<MaterialanalysisdetailVO> errorList = new ArrayList<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        HashMap<String, String> map = new HashMap<>();
        HashMap<String, String> map1 = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for (int i = 3; i < result.size(); i++) {
                    int num = 0;
                    List<String> datas = result.get(i);
                    MaterialanalysisdetailVO subpackagematerialanalysisdetailVO = new MaterialanalysisdetailVO();

                    subpackagematerialanalysisdetailVO.setId(IdWorker.getId());//id
                    subpackagematerialanalysisdetailVO.setMaterialsCode(StringUtils.isNotBlank(datas.get(0)) ? datas.get(0) : null); // 物资编码
                    subpackagematerialanalysisdetailVO.setMaterialsName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 物资名称
                    subpackagematerialanalysisdetailVO.setSpec(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 规格型号
                    subpackagematerialanalysisdetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 计量单位
//                    subpackagematerialanalysisdetailVO.setQuantitiesBase(StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) : null); // 分包基础清单工程量
//                    subpackagematerialanalysisdetailVO.setMaterialWasteRateBase(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); // 合同约定基础用料损耗率
//                    subpackagematerialanalysisdetailVO.setMaterialWasteBase(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : null); // 基础用料损耗
//                    subpackagematerialanalysisdetailVO.setMaterialDosageBase(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); // 基础材料用量
//                    subpackagematerialanalysisdetailVO.setQuantitiesMain(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 分包主体清单工程量
//                    subpackagematerialanalysisdetailVO.setMaterialWasteRateMain(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 合同约定主体用料损耗率
//
//                    subpackagematerialanalysisdetailVO.setMaterialWasteMain(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null); // 主体用料损耗量
//                    subpackagematerialanalysisdetailVO.setMaterialDosageMain(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); // 主体材料用量
//
//                    subpackagematerialanalysisdetailVO.setQuantitiesDecorate(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null);//分包装修清单工程量
//                    subpackagematerialanalysisdetailVO.setMaterialWasteRateDecorate(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) : null);//合同约定装修用料损耗率
//
//                    subpackagematerialanalysisdetailVO.setMaterialWasteDecorate(StringUtils.isNotBlank(datas.get(14)) ? new BigDecimal(datas.get(14)) : null);//装修用料损耗量
//                    subpackagematerialanalysisdetailVO.setMaterialDosageDecorate(StringUtils.isNotBlank(datas.get(15)) ? new BigDecimal(datas.get(15)) : null);//装修材料用量
//
//                    subpackagematerialanalysisdetailVO.setSubtotal(StringUtils.isNotBlank(datas.get(16)) ? new BigDecimal(datas.get(16)) : null);//小计
                    subpackagematerialanalysisdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(17)) ? datas.get(17) : null); // 备注
                    /**
                     * 非空校验
                     */
                    if (StringUtils.isEmpty(datas.get(0))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "物资编码不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(1))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "物资名称不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(4))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "分包基础清单工程量不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(5))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "合同约定基础用料损耗率不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(8))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "分包主体清单工程量不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(9))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "合同约定主体用料损耗率不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(12))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "分包装修清单工程量不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    if (StringUtils.isEmpty(datas.get(13))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "合同约定装修用料损耗率不能为空!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    }
                    /**
                     * 重复校验
                     */
                    String data0 = map.get(datas.get(0));
                    if (map.get(data0) != null && StringUtils.isNotEmpty(data0) && data0.equals(datas.get(0))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "物资编码重复,请检查!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    } else {
                        map.put(datas.get(0), datas.get(0));
                    }
                    String s = map1.get(datas.get(1) + datas.get(2) + datas.get(3));
                    if (map1.get(s) != null && StringUtils.isNotEmpty(s) && s.equals(datas.get(1) + datas.get(2) + datas.get(3))) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "物资名称+规格+单位重复,请检查!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    } else {
                        map1.put(datas.get(1) + datas.get(2) + datas.get(3), datas.get(1) + datas.get(2) + datas.get(3));
                    }
                    /**
                     * 参照合法校验
                     */
                    CommonResponse<MaterialVO> back0 = shareMaterialApi.queryMaterialByCode(datas.get(0));
                    if (back0.getData() == null) {
                        String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage += "物资编码未在库中,请检查!";
                        subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                        num++;
                    } else {
                        MaterialVO materialVO = back0.getData();
                        String name = materialVO.getName() == null ? "" : materialVO.getName();
                        String spec = materialVO.getSpec() == null ? "" : materialVO.getSpec();
                        String unitName = materialVO.getUnitName() == null ? "" : materialVO.getUnitName();
                        if (!name.equals(datas.get(1))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "物资名称与物资编码不符,请检查!";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        }
                        if (!spec.equals(datas.get(2))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "规格与物资编码不符,请检查!";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        }
                        if (!unitName.equals(datas.get(3))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "计量单位与物资编码不符,请检查!";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        }
                    }

                    /**
                     * 数字格式校验
                     */
                    if (datas.get(4) != null && !"".equals(datas.get(4))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(4)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "分包基础清单工程量输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setQuantitiesBase(StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) : null); // 其它数量
                        }
                    }
                    if (datas.get(5) != null && !"".equals(datas.get(5))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(5)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "合同约定基础用料损耗率输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setMaterialWasteRateBase(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); // 其它数量
                        }
                    }
                    if (datas.get(6) == null || "".equals(datas.get(6))) {
                        //基础用料损耗量
                        if (num == 0) {
                            BigDecimal materialWasteBase = new BigDecimal(datas.get(4)).multiply(new BigDecimal(datas.get(5)));
                            subpackagematerialanalysisdetailVO.setMaterialWasteBase(materialWasteBase);
                        }
                    } else {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(6)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "基础用料损耗输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setMaterialWasteBase(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : null); // 其它数量
                        }
                    }
                    if (datas.get(7) == null || "".equals(datas.get(7))) {
                        if (num == 0) {
                            //基础用料损耗量
                            BigDecimal materialWasteBase = new BigDecimal(datas.get(4)).multiply(new BigDecimal(datas.get(5)));
//                        subpackagematerialanalysisdetailVO.setMaterialWasteBase(materialWasteBase);
                            //基础材料用量
                            BigDecimal materialDosageBase = new BigDecimal(datas.get(4)).add(materialWasteBase);
                            subpackagematerialanalysisdetailVO.setMaterialDosageBase(materialDosageBase);
                        }
                    } else {

                        if (!NumberUtil.isNumber(String.valueOf(datas.get(7)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "基础材料用量输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setMaterialDosageBase(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); // 其它数量
                        }
                    }

                    if (datas.get(8) != null && !"".equals(datas.get(8))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(8)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "分包主体清单工程量输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setQuantitiesMain(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 其它数量
                        }
                    }
                    if (datas.get(9) != null && !"".equals(datas.get(9))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(9)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "合同约定主体用料损耗率输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setMaterialWasteRateMain(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 其它数量
                        }
                    }
                    if (datas.get(10) == null || "".equals(datas.get(10))) {
                        if (num == 0) {
                            //主体用料损耗量
                            BigDecimal materialWasteMain = new BigDecimal(datas.get(8)).multiply(new BigDecimal(datas.get(9)));
                            subpackagematerialanalysisdetailVO.setMaterialWasteMain(materialWasteMain);
                        }
                    } else {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(10)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "主体用料损耗量输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setMaterialWasteMain(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null); // 其它数量
                        }
                    }
                    if (datas.get(11) == null || "".equals(datas.get(11))) {
                        if (num == 0) {
                            //主体用料损耗量
                            BigDecimal materialWasteMain = new BigDecimal(datas.get(8)).multiply(new BigDecimal(datas.get(9)));
//                        subpackagematerialanalysisdetailVO.setMaterialWasteMain(materialWasteMain);
                            //主体材料用量
                            BigDecimal materialDosageMain = new BigDecimal(datas.get(8)).add(materialWasteMain);
                            subpackagematerialanalysisdetailVO.setMaterialDosageMain(materialDosageMain);
                        }
                    } else {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(11)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "主体材料用量输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setMaterialDosageMain(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); // 其它数量
                        }
                    }
                    if (datas.get(12) != null && !"".equals(datas.get(12))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(12)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "分包装修清单工程量输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setQuantitiesDecorate(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null); // 其它数量
                        }
                    }
                    if (datas.get(13) != null && !"".equals(datas.get(13))) {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(13)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "合同约定装修用料损耗率输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setMaterialWasteRateDecorate(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) : null); // 其它数量
                        }
                    }
                    if (datas.get(14) == null || "".equals(datas.get(14))) {
                        if (num == 0) {
                            //装修用料损耗量
                            BigDecimal materialWasteDecorate = new BigDecimal(datas.get(12)).multiply(new BigDecimal(datas.get(13)));
                            subpackagematerialanalysisdetailVO.setMaterialWasteDecorate(materialWasteDecorate);
                        }
                    } else {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(14)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "装修用料损耗量输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setMaterialWasteDecorate(StringUtils.isNotBlank(datas.get(14)) ? new BigDecimal(datas.get(14)) : null); // 其它数量
                        }
                    }
                    if (datas.get(15) == null || "".equals(datas.get(15))) {
                        if (num == 0) {
                            //装修用料损耗量
                            BigDecimal materialWasteDecorate = new BigDecimal(datas.get(12)).multiply(new BigDecimal(datas.get(13)));
//                        subpackagematerialanalysisdetailVO.setMaterialWasteDecorate(materialWasteDecorate);
                            //装修材料用量
                            BigDecimal materialDosageDecorate = new BigDecimal(datas.get(12)).add(materialWasteDecorate);
                            subpackagematerialanalysisdetailVO.setMaterialDosageDecorate(materialDosageDecorate);
                        }
                    } else {
                        if (!NumberUtil.isNumber(String.valueOf(datas.get(15)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "装修材料用量输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setMaterialDosageDecorate(StringUtils.isNotBlank(datas.get(15)) ? new BigDecimal(datas.get(15)) : null); // 其它数量
                        }
                    }
                    if (datas.get(16) == null || "".equals(datas.get(16))) {
                        if (num == 0) {
                            //基础用料损耗量
                            BigDecimal materialWasteBase = new BigDecimal(datas.get(4)).multiply(new BigDecimal(datas.get(5)));
                            //基础材料用量
                            BigDecimal materialDosageBase = new BigDecimal(datas.get(4)).add(materialWasteBase);
                            //主体用料损耗量
                            BigDecimal materialWasteMain = new BigDecimal(datas.get(8)).multiply(new BigDecimal(datas.get(9)));
                            //主体材料用量
                            BigDecimal materialDosageMain = new BigDecimal(datas.get(8)).add(materialWasteMain);
                            //装修用料损耗量
                            BigDecimal materialWasteDecorate = new BigDecimal(datas.get(12)).multiply(new BigDecimal(datas.get(13)));
                            //装修材料用量
                            BigDecimal materialDosageDecorate = new BigDecimal(datas.get(12)).add(materialWasteDecorate);
                            //小计
                            BigDecimal subtotal = materialDosageBase.add(materialDosageMain).add(materialDosageDecorate);
                            subpackagematerialanalysisdetailVO.setSubtotal(subtotal);
                        }
                    } else {

                        if (!NumberUtil.isNumber(String.valueOf(datas.get(16)))) {
                            String errorMessage = subpackagematerialanalysisdetailVO.getErrorMessage();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage += "小计输入格式错误！";
                            subpackagematerialanalysisdetailVO.setErrorMessage(errorMessage);
                            num++;
                        } else {
                            subpackagematerialanalysisdetailVO.setSubtotal(StringUtils.isNotBlank(datas.get(16)) ? new BigDecimal(datas.get(16)) : null); // 其它数量
                        }
                    }


                    if (num > 0) {
                        errorList.add(subpackagematerialanalysisdetailVO);
                    } else {
                        successList.add(subpackagematerialanalysisdetailVO);
                    }
                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportmaterialanalysisFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportmaterialanalysisFromDatabase(@RequestBody MaterialanalysisVO materialanalysisVO, HttpServletResponse response) {
        QueryWrapper<MaterialanalysisdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", materialanalysisVO.getId());
        queryWrapper.eq("dr", 0);
        List<MaterialanalysisdetailEntity> list = materialanalysisdetailService.list(queryWrapper);

        List<MaterialanalysisdetailVO> materialanalysisdetailVOList = BeanMapper.mapList(list, MaterialanalysisdetailVO.class);
        if(materialanalysisdetailVOList != null && materialanalysisdetailVOList.size() > 0){
            for (int i = 0; i < materialanalysisdetailVOList.size(); i++) {
                MaterialanalysisdetailVO materialanalysisdetailVO = materialanalysisdetailVOList.get(i);
                materialanalysisdetailVO.setSort(String.valueOf(i+1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", materialanalysisdetailVOList);
        ExcelExport.getInstance().export("materialanalysisdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportmaterialanalysisFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportmaterialanalysisFromPage(@RequestBody List<MaterialanalysisdetailVO> list, HttpServletResponse response) {
        if(list != null){
            for (int i = 0; i < list.size(); i++) {
                MaterialanalysisdetailVO materialanalysisdetailVO = list.get(i);
                materialanalysisdetailVO.setSort(String.valueOf(i+1));
            }
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialanalysisdetail-export.xlsx", beans, response);
    }

}
