package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotalEntity;
import com.ejianc.business.bedget.bean.DesignestimateEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgettotalService;
import com.ejianc.business.change.bean.ChangeconsdrawbudgettotalEntity;
import com.ejianc.business.change.bean.ChangeconsdrawbudgettotaldetailEntity;
import com.ejianc.business.change.bean.ChangedesignestimateEntity;
import com.ejianc.business.change.mapper.ChangeconsdrawbudgettotalMapper;
import com.ejianc.business.change.service.IChangeconsdrawbudgettotalService;
import com.ejianc.business.change.vo.ChangeconsdrawbudgettotalVO;
import com.ejianc.business.change.vo.ChangeconsdrawbudgettotaldetailVO;
import com.ejianc.business.change.vo.ChangedesignestimateVO;
import com.ejianc.business.change.vo.ChangedesignestimatedetailVO;
import com.ejianc.business.record.bean.RecordconsdrawbudgettotalEntity;
import com.ejianc.business.record.bean.RecorddesignestimateEntity;
import com.ejianc.business.record.service.IRecordconsdrawbudgettotalService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 施工预算图汇总表变更
 * 
 * @author generator
 * 
 */
@Service("changeconsdrawbudgettotalService")
public class ChangeconsdrawbudgettotalServiceImpl extends BaseServiceImpl<ChangeconsdrawbudgettotalMapper, ChangeconsdrawbudgettotalEntity> implements IChangeconsdrawbudgettotalService {

    @Autowired
    private IConsdrawbudgettotalService consdrawbudgettotalService;

    @Autowired
    private IRecordconsdrawbudgettotalService recordconsdrawbudgettotalService;

    @Override
    public CommonResponse<ChangeconsdrawbudgettotalVO> saveChange(ChangeconsdrawbudgettotalVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeconsdrawbudgettotalEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeconsdrawbudgettotalEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeconsdrawbudgettotalEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeconsdrawbudgettotalEntity> queryWrapper = new QueryWrapper<ChangeconsdrawbudgettotalEntity>();
        queryWrapper.eq("original_id", saveOrUpdateVO.getOriginalId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1, 3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeconsdrawbudgettotalEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //设计概算指标分析子表
        this.saveOrUpdate(entity, false);

        ChangeconsdrawbudgettotalVO vo = BeanMapper.map(entity, ChangeconsdrawbudgettotalVO.class);
        vo.setConsdrawbudgettotaldetailEntities(saveOrUpdateVO.getConsdrawbudgettotaldetailEntities());
        vo.setRecordconsdrawbudgettotalVOS(saveOrUpdateVO.getRecordconsdrawbudgettotalVOS());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            ConsdrawbudgettotalEntity consdrawbudgettotalEntity = consdrawbudgettotalService.selectById(vo.getOriginalId());
            consdrawbudgettotalEntity.setChangeState("2");//状态改为变更中
            consdrawbudgettotalEntity.setChangeId(vo.getId());
            consdrawbudgettotalService.saveOrUpdate(consdrawbudgettotalEntity, false);
        }

        //构建树形结构
        List<ChangeconsdrawbudgettotaldetailVO> changeconsdrawbudgettotaldetailVOList = vo.getConsdrawbudgettotaldetailEntities();
        List<ChangeconsdrawbudgettotaldetailVO> resChangeconsdrawbudgettotaldetailVOList = createTreeData(changeconsdrawbudgettotaldetailVOList);
        vo.setConsdrawbudgettotaldetailEntities(resChangeconsdrawbudgettotaldetailVOList);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> delete(List<ChangeconsdrawbudgettotalVO> vos) {
        for(ChangeconsdrawbudgettotalVO vo : vos){
            ChangeconsdrawbudgettotalEntity entity = this.getById(vo.getId());
            ConsdrawbudgettotalEntity consdrawbudgettotalEntity = consdrawbudgettotalService.selectById(entity.getOriginalId());
            QueryWrapper<RecordconsdrawbudgettotalEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("consdrawbudgettotal_id", consdrawbudgettotalEntity.getId());
            List<RecordconsdrawbudgettotalEntity> records = recordconsdrawbudgettotalService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                consdrawbudgettotalEntity.setChangeState("3");//状态改为已变更
            }else{
                consdrawbudgettotalEntity.setChangeState("1");//状态改为未变更
            }
            consdrawbudgettotalEntity.setChangeId(null);
            consdrawbudgettotalService.saveOrUpdate(consdrawbudgettotalEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangeconsdrawbudgettotalVO::getId).collect(Collectors.toList()),true);

        return CommonResponse.success("删除成功！");
    }

    public static List<ChangeconsdrawbudgettotaldetailVO> createTreeData(List<ChangeconsdrawbudgettotaldetailVO> list) {
        List<ChangeconsdrawbudgettotaldetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangeconsdrawbudgettotaldetailVO> listMap = new HashMap<>();
        for(ChangeconsdrawbudgettotaldetailVO item:list) {
            listMap.put(item.getTid().toString(), item);
        }

        for(int i =0; i<list.size(); i++) {
            ChangeconsdrawbudgettotaldetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString():"";
            ChangeconsdrawbudgettotaldetailVO parent = listMap.get(parentId);
            if(parent != null) {
                List<ChangeconsdrawbudgettotaldetailVO> child = (List<ChangeconsdrawbudgettotaldetailVO>) parent.getChildren();
                if(child != null) {
                    child.add(item);
                }else{
                    List<ChangeconsdrawbudgettotaldetailVO> children = new ArrayList<ChangeconsdrawbudgettotaldetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
