package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.DesignestimateEntity;
import com.ejianc.business.bedget.bean.DesignestimatedetailEntity;
import com.ejianc.business.bedget.bean.QuotadesigndetailEntity;
import com.ejianc.business.bedget.service.IDesignestimateService;

import com.ejianc.business.change.bean.ChangedesignestimateEntity;
import com.ejianc.business.change.bean.ChangedesignestimatedetailEntity;
import com.ejianc.business.change.service.IChangedesignestimateService;
import com.ejianc.business.record.bean.RecorddesignestimateEntity;
import com.ejianc.business.record.bean.RecorddesignestimatedetailEntity;
import com.ejianc.business.record.service.IRecorddesignestimateService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changedesignestimate") 
public class ChangedesignestimateBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	//业务类型
	private static final String Designestimate = "zjkj-designestimate";//限额设计指标分析
	private static final String Designestimate_CHANGE = "zjkj-designestimateChange";//限额设计指标分析变更
	private static final String Designestimate_RECORD = "zjkj-designestimateRecord";//限额设计指标分析变更记录

	//单据类型
	private static final String Designestimate_BILLTYPE_CODE = "BT202202000030";//限额设计指标分析
	private static final String Designestimate_CHANGE_BILLTYPE_CODE = "BT202202000031";//限额设计指标分析变更
	private static final String Designestimate_RECORD_BILLTYPE_CODE = "BT202202000032";//限额设计指标分析变更记录


	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangedesignestimateService changeDesignestimateService;
	@Autowired
	private IDesignestimateService designestimateService;
	@Autowired
	private IRecorddesignestimateService recorddesignestimateService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
//1、获取目前单据信息、变更信息
		ChangedesignestimateEntity changeEntity = changeDesignestimateService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getDesignestimateId());
		DesignestimateEntity quotadesignEntity = designestimateService.selectById(changeEntity.getDesignestimateId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecorddesignestimateEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("designestimate_id", quotadesignEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recorddesignestimateService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecorddesignestimateEntity recordQuotadesignEntity = BeanMapper.map(quotadesignEntity, RecorddesignestimateEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordQuotadesignEntity);
		recordQuotadesignEntity.setBillState(null);
		recordQuotadesignEntity.setDesignestimateId(quotadesignEntity.getId());
		recordQuotadesignEntity.setDesignestimateCode(quotadesignEntity.getBillCode()+"-"+(count+1));
		recordQuotadesignEntity.setId(recordId);
		recordQuotadesignEntity.setBillCode(quotadesignEntity.getBillCode());
		recordQuotadesignEntity.setChangeReason(changeEntity.getChangeReason());
		recordQuotadesignEntity.setEffectDate(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<DesignestimatedetailEntity> quotadesigndetailEntities = quotadesignEntity.getDesignestimatedetailEntities();
		if(quotadesigndetailEntities!=null&&quotadesigndetailEntities.size()>0){
			List<RecorddesignestimatedetailEntity> recordquotadesigndetaillEntity = new ArrayList<>();
			for(DesignestimatedetailEntity entity : quotadesigndetailEntities){
				RecorddesignestimatedetailEntity reEntity = BeanMapper.map(entity, RecorddesignestimatedetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setId(IdWorker.getId());
				reEntity.setOriginalId(entity.getId());
				recordquotadesigndetaillEntity.add(reEntity);
			}
			recordQuotadesignEntity.setRecorddesignestimatedetailEntities(recordquotadesigndetaillEntity);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Designestimate_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Designestimate_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(quotadesignEntity.getId().toString(), sourceBillType, Designestimate , recordId.toString(), targetBillType, Designestimate_RECORD);
		recorddesignestimateService.saveOrUpdate(recordQuotadesignEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + quotadesignEntity.getCreateUserCode());
		//3、修改当前单据状态
		DesignestimateEntity newQuotadesignEntity = BeanMapper.map(changeEntity, DesignestimateEntity.class);
		newQuotadesignEntity.setChangeState("3");//状态改为已变更
		newQuotadesignEntity.setChangeId(null);
		newQuotadesignEntity.setBillState(quotadesignEntity.getBillState());
		newQuotadesignEntity.setId(quotadesignEntity.getId());
		newQuotadesignEntity.setCreateTime(quotadesignEntity.getCreateTime());
		newQuotadesignEntity.setCreateUserCode(quotadesignEntity.getCreateUserCode());
		newQuotadesignEntity.setTenantId(quotadesignEntity.getTenantId());
		newQuotadesignEntity.setVersion(quotadesignEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangedesignestimatedetailEntity> changequotadesigndetailList = changeEntity.getDesignestimatedetailEntities();
		if(changequotadesigndetailList!=null&&changequotadesigndetailList.size()>0){
			List<DesignestimatedetailEntity> newQuotadesigndetailList = BeanMapper.mapList(changequotadesigndetailList, DesignestimatedetailEntity.class);
			//原单据子表的基础信息不变
			if(quotadesigndetailEntities != null && quotadesigndetailEntities.size() > 0){
				DesignestimatedetailEntity originalQuotadesigndetailInfo = quotadesigndetailEntities.get(0);

				for (int i = 0; i < changequotadesigndetailList.size(); i++) {
					ChangedesignestimatedetailEntity changeQuotadesigndetail = changequotadesigndetailList.get(i);
					DesignestimatedetailEntity newQuotadesigndetail = newQuotadesigndetailList.get(i);

					boolean isChangeUpdate = false;//true 变更更新数据 false 变更新增数据
					for (int j = 0; j < quotadesigndetailEntities.size(); j++) {
						DesignestimatedetailEntity originalQuotadesigndetail = quotadesigndetailEntities.get(j);
						if(originalQuotadesigndetail.getId().equals(changeQuotadesigndetail.getOriginalId())){

							newQuotadesigndetail.setId(originalQuotadesigndetail.getId());
							newQuotadesigndetail.setCreateTime(originalQuotadesigndetailInfo.getCreateTime());
							newQuotadesigndetail.setCreateUserCode(originalQuotadesigndetailInfo.getCreateUserCode());

							newQuotadesigndetail.setUpdateTime(changeQuotadesigndetail.getUpdateTime());
							newQuotadesigndetail.setUpdateUserCode(changeQuotadesigndetail.getCreateUserCode());

							isChangeUpdate = true;
							break;
						}
					}

					if(!isChangeUpdate){//变更新增
						newQuotadesigndetail.setCreateTime(changeQuotadesigndetail.getUpdateTime());
						newQuotadesigndetail.setCreateUserCode(changeQuotadesigndetail.getCreateUserCode());
						newQuotadesigndetail.setRowState("add");
					}

					newQuotadesigndetail.setBillState(originalQuotadesigndetailInfo.getBillState());
					newQuotadesigndetail.setTenantId(originalQuotadesigndetailInfo.getTenantId());
					newQuotadesigndetail.setVersion(originalQuotadesigndetailInfo.getVersion());
				}
			}
			//原始单与变更单对比后（新增）
			newQuotadesignEntity.setDesignestimatedetailEntities(newQuotadesigndetailList);

			//原始单与变更单对比后（删除）
			List<DesignestimatedetailEntity> deleteDatas = new ArrayList<>();
			for (int i = 0; i < quotadesigndetailEntities.size(); i++) {
				DesignestimatedetailEntity quotadesigndetail = quotadesigndetailEntities.get(i);
				boolean isSame = false;
				for (int j = 0; j < newQuotadesigndetailList.size(); j++) {
					DesignestimatedetailEntity newDetail = newQuotadesigndetailList.get(j);
					if(quotadesigndetail.getId().equals(newDetail.getId())) {
						isSame = true;
					}
				}
				if(!isSame){//变更已删除行
					quotadesigndetail.setRowState("del");
					deleteDatas.add(quotadesigndetail);
				}
			}

			if(deleteDatas.size() > 0){
				newQuotadesigndetailList.addAll(deleteDatas);
				newQuotadesignEntity.setDesignestimatedetailEntities(newQuotadesigndetailList);
			}
			newQuotadesignEntity.setDesignestimatedetailEntities(newQuotadesigndetailList);
		}
		logger.info("---------保存--------");
		designestimateService.saveOrUpdate(newQuotadesignEntity, false);

		sourceBillType = Designestimate_CHANGE_BILLTYPE_CODE;
		targetBillType = Designestimate_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Designestimate_CHANGE, quotadesignEntity.getId().toString(), targetBillType, Designestimate);
		recorddesignestimateService.saveOrUpdate(recordQuotadesignEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
