package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.*;
import com.ejianc.business.bedget.service.IConsdrawbudgetService;
import com.ejianc.business.bedget.service.IConsdrawbudgetdetailService;
import com.ejianc.business.bedget.service.ISubpackagedetailService;
import com.ejianc.business.bedget.vo.*;
import com.ejianc.business.change.service.IChangesubpackageService;
import com.ejianc.business.record.bean.RecordQuotaanalysisEntity;
import com.ejianc.business.record.bean.RecordsubpackageEntity;
import com.ejianc.business.record.service.IRecordsubpackageService;
import com.ejianc.business.record.vo.RecordQuotaanalysisVO;
import com.ejianc.business.record.vo.RecordsubpackageVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.service.ISubpackageService;

/**
 * 分包施工图预算
 *
 * @author generator
 */
@Controller
@RequestMapping("subpackage")
public class SubpackageController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanager-subpackage";//此处需要根据实际修改

    @Autowired
    private ISubpackageService service;
    @Autowired
    private IRecordsubpackageService recordsubpackageService;
    @Autowired
    private ISubpackagedetailService subpackagedetailService;

    @Autowired
    private IConsdrawbudgetService consdrawbudgetService;
    @Autowired
    private IConsdrawbudgetdetailService consdrawbudgetdetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubpackageVO> saveOrUpdate(@RequestBody SubpackageVO saveorUpdateVO) {
        SubpackageEntity entity = BeanMapper.map(saveorUpdateVO, SubpackageEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setChangeState("1");//未变更
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //查询是否开启控制
        QueryWrapper<ConsdrawbudgetEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("project_id", entity.getProjectId());
        wrapper.in("bill_state", 1, 3);
        ConsdrawbudgetEntity control = consdrawbudgetService.getOne(wrapper);

        List<ConsdrawbudgetdetailEntity> drawList = new ArrayList<>();
        List<SubpackagedetailEntity> subList = new ArrayList<>();
        for (SubpackagedetailEntity detail : entity.getSubpackagedetailEntities()) {
            //根据施工图预算行ID查该行的累计工程量,
            QueryWrapper<ConsdrawbudgetdetailEntity> countWrapper = new QueryWrapper<>();
            countWrapper.eq("mid", control.getId());
            countWrapper.eq("section",detail.getSection());
            countWrapper.eq("subitem_code",detail.getSubtitleCode());
            ConsdrawbudgetdetailEntity consdrawbudgetdetail = consdrawbudgetdetailService.getOne(countWrapper);

            if (consdrawbudgetdetail.getEngineeQuatity() != null) {
                drawList.add(consdrawbudgetdetail);
                subList.add(detail);
                //更新本单据子表的预计工程量
                detail.setSubpackageBudgetTotal(consdrawbudgetdetail.getEngineeQuatity());
            }

            //开启控制后进行判断
            if (control.getIsOpenControl() == 1) {
                if (consdrawbudgetdetail.getSubEngineeQuatity() == null) {
                    consdrawbudgetdetail.setSubEngineeQuatity(new BigDecimal(0));
                }
                if (consdrawbudgetdetail.getEngineeQuatity() != null) {
                    BigDecimal allowance = consdrawbudgetdetail.getEngineeQuatity().subtract(consdrawbudgetdetail.getSubEngineeQuatity());
                    if (allowance.compareTo(detail.getSubpackageQuantities()) == -1) {
                        throw new BusinessException("本次输入的工程量不允许超过'分包施工图预算量合计（施工图预算工程量）'");
                    }
                }
            }
        }

        entity.setChangeState("1");
        service.saveOrUpdate(entity, false);

        for (ConsdrawbudgetdetailEntity draw : drawList) {
            for (SubpackagedetailEntity subpackagedetail : subList) {
                if (draw.getId().equals(subpackagedetail.getConsdrawbudgetId()) && draw.getEngineeQuatity() != null) {
                    //更新累计分包工程量
                    if (draw.getSubEngineeQuatity() == null) {
                        draw.setSubEngineeQuatity(subpackagedetail.getSubpackageQuantities());
                    } else {
                        draw.setSubEngineeQuatity(draw.getSubEngineeQuatity().add(subpackagedetail.getSubpackageQuantities()));
                    }
                    consdrawbudgetdetailService.saveOrUpdate(draw);
                }
            }
        }
        logger.info("-------更新施工图预算表的累计分包工程量成功！！！-------");
        SubpackageVO vo = BeanMapper.map(entity, SubpackageVO.class);
        vo.setSubpackagedetailEntities(createTreeData(vo.getSubpackagedetailEntities()));
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubpackageVO> queryDetail(Long id) {
        SubpackageEntity entity = service.selectById(id);
        SubpackageVO vo = BeanMapper.map(entity, SubpackageVO.class);

        //当前单据变更过则显示变更记录
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper<RecordsubpackageEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", vo.getId());
            List<RecordsubpackageEntity> records = recordsubpackageService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordsubpackageList(BeanMapper.mapList(records, RecordsubpackageVO.class));
            }
        }
        vo.setSubpackagedetailEntities(createTreeData(vo.getSubpackagedetailEntities()));
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubpackageVO> vos) {
        service.removeByIds(vos.stream().map(SubpackageVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubpackageVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        fuzzyFields.add("subcontract_unit_name");
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SubpackageEntity> page = service.queryPage(param, false);
        IPage<SubpackageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubpackageVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        fuzzyFields.add("subcontract_unit_name");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubpackageEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SubpackageVO> subpackageVOList = BeanMapper.mapList(list, SubpackageVO.class);
        for (int i = 0; i < subpackageVOList.size(); i++) {
            SubpackageVO subpackageVO = subpackageVOList.get(i);
            subpackageVO.setSort(String.valueOf(i + 1));
            if (subpackageVO.getCreateTime() != null) {
                subpackageVO.setCreateTimeShow(DateUtils.dateSimple2(subpackageVO.getCreateTime()));
            }

            String billStateStr = subpackageVO.getBillState().toString();
            String changeState = subpackageVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                subpackageVO.setBillStateStr(billStateStr);
            }

            if (changeState != null) {
                if ("1".equals(changeState)) {//1:未变更
                    changeState = "未变更";
                } else if ("2".equals(changeState)) {//2:变更中
                    changeState = "变更中";
                } else if ("3".equals(changeState)) {//3:已变更
                    changeState = "已变更";
                }

                subpackageVO.setChangeState(changeState);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", subpackageVOList);
        ExcelExport.getInstance().export("Subpackage-export.xlsx", beans, response);
    }

    /**
     * @param id
     * @param projectId
     * @Description queryDetail 查询该项目是否已有限额设计指标分析单据
     */
    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConsdrawbudgetEntity> queryProject(Long projectId) {

        QueryWrapper<ConsdrawbudgetEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr",0);
        wrapper.in("bill_state",1,3);
        wrapper.eq("project_id",projectId);
        ConsdrawbudgetEntity consdrawbudget = consdrawbudgetService.getOne(wrapper);
        return CommonResponse.success(consdrawbudget);
    }




    @RequestMapping(value = "/volidateProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConsdrawbudgetEntity> volidateProject(Long projectId,Long contract) {
        QueryWrapper<SubpackageEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr",0);
        queryWrapper.eq("project_id",projectId);
        List<SubpackageEntity> entity = service.list(queryWrapper);
        for (SubpackageEntity e : entity) {
            if(e.getContract().equals(contract)){
                throw new BusinessException("该项目下已存在所选合同的单据，请重新选择");
            }
        }
        return CommonResponse.success();
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubpackageData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubpackageVO>> refSubpackageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubpackageEntity> page = service.queryPage(param, false);
        IPage<SubpackageVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubpackageVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    public static List<SubpackagedetailVO> createTreeData(List<SubpackagedetailVO> list) {
        List<SubpackagedetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, SubpackagedetailVO> listMap = new HashMap<>();
        for (SubpackagedetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            SubpackagedetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            SubpackagedetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<SubpackagedetailVO> child = (List<SubpackagedetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<SubpackagedetailVO> children = new ArrayList<SubpackagedetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }
}
