package com.ejianc.business.bedget.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.*;
import com.ejianc.business.bedget.service.*;
import com.ejianc.business.bedget.vo.MaterialanalysisVO;
import com.ejianc.business.record.bean.RecordmaterialanalysisEntity;
import com.ejianc.business.record.bean.RecordsubpackagematerialanalysisEntity;
import com.ejianc.business.record.service.IRecordsubpackagematerialanalysisService;
import com.ejianc.business.record.vo.RecordmaterialanalysisVO;
import com.ejianc.business.record.vo.RecordsubpackagematerialanalysisVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bedget.vo.SubpackagematerialanalysisVO;

/**
 * 分包施工图预算材料分析
 *
 * @author generator
 */
@Controller
@RequestMapping("subpackagematerialanalysis")
public class SubpackagematerialanalysisController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "budgetmanager-subpackagematerialanalysis";//此处需要根据实际修改

    @Autowired
    private ISubpackagematerialanalysisService service;
    @Autowired
    private IMaterialrequirementsService materialrequirementsService;//需求总计划service
    @Autowired
    private IMaterialrequirementsdetailService materialrequirementsdetailService;//需求总计划明细service
    @Autowired
    private ISubpackagematerialanalysisdetailService subpackagematerialanalysisdetailService;//明细service
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubpackagematerialanalysisVO> saveOrUpdate(@RequestBody SubpackagematerialanalysisVO saveorUpdateVO) {
        //页面参数转为entity
        SubpackagematerialanalysisEntity entity = BeanMapper.map(saveorUpdateVO, SubpackagematerialanalysisEntity.class);
        //如果当前entityid为空，则是新增，否则为修改
        if (entity.getId() == null || entity.getId() == 0) {
            //初始化单据变更状态
            entity.setChangeState("1");//未变更
        }
        //获取当前entity的单据编号
        String billCode_now = entity.getBillCode();
        //如果当前单据编号为空，则生成单据编号，否则直接写入
        if (billCode_now == null || "".equals(billCode_now)) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //查询当前单据编号是否存在
            QueryWrapper<SubpackagematerialanalysisEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("bill_code", entity.getBillCode());
            queryWrapper.eq("dr", "0");
            if(entity.getId() != null && entity.getId() != 0) {
                queryWrapper.ne("id", entity.getId());
            }
            List<SubpackagematerialanalysisEntity> subpackagematerialanalysisEntityList = service.list(queryWrapper);
            if (subpackagematerialanalysisEntityList.size() > 0) {
                throw new BusinessException("当前单据编号已存在，请检查！");
            }
        }
        /**
         * 查询当前项目对应的物资需求总计划
         * 当前项目下的分包材料预算总和不得超过需求总计划合计汇总数量
         */
        /**
         * 创建一个map集合，将当前的物资及数量插入
         * 再遍历当前项目下其他数据，数量累加
         * 物资需求总计划拼接后插入map集合
         */
        HashMap<String, BigDecimal> fbMap = new HashMap<>();
        HashMap<String, BigDecimal> xqMap = new HashMap<>();
        //获取主表项目
        Long projectId = entity.getProjectId();
        //查找该项目的物资需求总计划
        QueryWrapper<MaterialrequirementsEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("project_id", projectId);
        queryWrapper1.eq("dr", "0");
        queryWrapper1.in("bill_state", "1","3");
        List<MaterialrequirementsEntity> materialrequirementsEntityList = materialrequirementsService.list(queryWrapper1);
        if (materialrequirementsEntityList.size() > 0) {
            MaterialrequirementsEntity materialrequirementsEntity = materialrequirementsEntityList.get(0);
            //主表id
            Long mid = materialrequirementsEntity.getId();
            QueryWrapper<MaterialrequirementsdetailEntity> queryWrappers = new QueryWrapper<>();
            queryWrappers.eq("dr","0");
            queryWrappers.eq("mid",mid);
            List<MaterialrequirementsdetailEntity> materialrequirementsdetailEntityList = materialrequirementsdetailService.list(queryWrappers);
            //物资需求总计划明细
            for (MaterialrequirementsdetailEntity materialrequirementsdetailEntity : materialrequirementsdetailEntityList) {
                String s = materialrequirementsdetailEntity.getBillCode() + materialrequirementsdetailEntity.getName() + materialrequirementsdetailEntity.getSpec() + materialrequirementsdetailEntity.getMeasuringUnit();
                BigDecimal sl = materialrequirementsdetailEntity.getTotal();
                xqMap.put(s, sl);
            }
            //获取子表集合
            List<SubpackagematerialanalysisdetailEntity> subpackagematerialanalysisdetailEntitiesList = entity.getSubpackagematerialanalysisdetailEntities();
            //遍历子表数据
            for (SubpackagematerialanalysisdetailEntity subpackagematerialanalysisdetailEntity : subpackagematerialanalysisdetailEntitiesList) {
                //获取编码，名称 ，规格，单位拼接
                String rowState = subpackagematerialanalysisdetailEntity.getRowState();
                if (!"del".equals(rowState)) {
                    String s = subpackagematerialanalysisdetailEntity.getMaterialsCode() + subpackagematerialanalysisdetailEntity.getMaterialsName() + subpackagematerialanalysisdetailEntity.getSpec() + subpackagematerialanalysisdetailEntity.getMeasuringUnit();
                    BigDecimal sl = subpackagematerialanalysisdetailEntity.getSubtotal();
                    fbMap.put(s, sl);
                }
            }
            //查询当前项目其他分包
            QueryWrapper<SubpackagematerialanalysisEntity> queryWrapper2 = new QueryWrapper<>();
            queryWrapper2.eq("project_id", entity.getProjectId());
            queryWrapper2.eq("dr", "0");
            queryWrapper2.in("bill_state", "1","3");
            if (entity.getId()!=null&&entity.getId()!=0) {
                queryWrapper2.ne("id", entity.getId());
            }
            List<SubpackagematerialanalysisEntity> subpackagematerialanalysisEntities = service.list(queryWrapper2);
            //可用数量
            BigDecimal kysl = new BigDecimal("0.00");
            for (SubpackagematerialanalysisEntity subpackagematerialanalysisEntity : subpackagematerialanalysisEntities) {
                Long mids = subpackagematerialanalysisEntity.getId();
                QueryWrapper<SubpackagematerialanalysisdetailEntity> queryWrapper4 = new QueryWrapper<>();
                queryWrapper4.eq("dr","0");
                queryWrapper4.eq("mid",mids);
                List<SubpackagematerialanalysisdetailEntity> subpackagematerialanalysisdetailEntities = subpackagematerialanalysisdetailService.list(queryWrapper4);
                for (SubpackagematerialanalysisdetailEntity subpackagematerialanalysisdetailEntity : subpackagematerialanalysisdetailEntities) {
                    String s = subpackagematerialanalysisdetailEntity.getMaterialsCode() + subpackagematerialanalysisdetailEntity.getMaterialsName() + subpackagematerialanalysisdetailEntity.getSpec() + subpackagematerialanalysisdetailEntity.getMeasuringUnit();
                    BigDecimal sl = subpackagematerialanalysisdetailEntity.getSubtotal();
                    kysl=kysl.add(sl);
                    BigDecimal bigDecimal = fbMap.get(s);
                    if (bigDecimal == null) {
                        fbMap.put(s, sl);
                    } else {
                        bigDecimal = bigDecimal.add(sl);
                        fbMap.put(s, bigDecimal);
                    }
                }
            }
            for (String s : fbMap.keySet()) {
                BigDecimal bigDecimal = xqMap.get(s);
                if (bigDecimal==null){
                    throw new BusinessException(s+"需求总计划数量不足，请检查！当前可用数量：0");
                } else {
                    BigDecimal bigDecimal1 = fbMap.get(s);
                    if (bigDecimal.compareTo(bigDecimal1)==-1){
                        kysl = bigDecimal.subtract(kysl);
                        throw new BusinessException(s+"需求总计划数量不足，请检查！当前可用数量："+kysl.setScale(2));
                    }
                }
            }


        } else {
            throw new BusinessException("该项目未创建物资需求总计划，请检查！");
        }
        service.saveOrUpdate(entity, false);
        SubpackagematerialanalysisVO vo = BeanMapper.map(entity, SubpackagematerialanalysisVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @Autowired
    private IRecordsubpackagematerialanalysisService recordsubpackagematerialanalysisService;

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubpackagematerialanalysisVO> queryDetail(Long id) {
        SubpackagematerialanalysisEntity entity = service.selectById(id);
        SubpackagematerialanalysisVO vo = BeanMapper.map(entity, SubpackagematerialanalysisVO.class);
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper<RecordsubpackagematerialanalysisEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", vo.getId());
            List<RecordsubpackagematerialanalysisEntity> records = recordsubpackagematerialanalysisService.list(queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordsubpackagematerialanalysisVOS(BeanMapper.mapList(records, RecordsubpackagematerialanalysisVO.class));
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubpackagematerialanalysisVO> vos) {
        service.removeByIds(vos.stream().map(SubpackagematerialanalysisVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubpackagematerialanalysisVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SubpackagematerialanalysisEntity> page = service.queryPage(param, false);
        IPage<SubpackagematerialanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubpackagematerialanalysisVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubpackagematerialanalysisEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SubpackagematerialanalysisVO> quotadesignVOList = BeanMapper.mapList(list, SubpackagematerialanalysisVO.class);
        for (int i = 0; i < quotadesignVOList.size(); i++) {
            SubpackagematerialanalysisVO quotadesignVO = quotadesignVOList.get(i);
            quotadesignVO.setSort(String.valueOf(i+1));
            if (quotadesignVO.getCreateTime()!=null){
                quotadesignVO.setCreateTimeShow(DateUtils.dateSimple2(quotadesignVO.getCreateTime()));
            }
            String billStateStr = quotadesignVO.getBillState().toString();
            String changeState = quotadesignVO.getChangeState();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                quotadesignVO.setBillStateStr(billStateStr);
            }

            if (changeState != null){
                if("1".equals(changeState)){//1:未变更
                    changeState = "未变更";
                }else if("2".equals(changeState)){//2:变更中
                    changeState = "变更中";
                }else if("3".equals(changeState)){//3:已变更
                    changeState = "已变更";
                }

                quotadesignVO.setChangeState(changeState);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", quotadesignVOList);
        ExcelExport.getInstance().export("Subpackagematerialanalysis-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubpackagematerialanalysisData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubpackagematerialanalysisVO>> refSubpackagematerialanalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                                 String condition,
                                                                                                 String searchObject,
                                                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubpackagematerialanalysisEntity> page = service.queryPage(param, false);
        IPage<SubpackagematerialanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubpackagematerialanalysisVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param id
     * @param projectId
     * @Description queryDetail 查询该项目是否已有物资需求总计划单据
     */
    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryProject(Long projectId) {
        QueryWrapper<MaterialrequirementsEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", "1","3");

        List<MaterialrequirementsEntity> entityList = materialrequirementsService.list(queryWrapper);

        if (entityList == null || entityList.size() == 0) {
            return CommonResponse.success("该项目未创建需求总计划，请选择其他项目!", "0");
        }

        return CommonResponse.success("查询成功！", "1");
    }
    @RequestMapping(value = "/queryContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryContract(Long contractId,Long projectId,Long id) {
        //判断该合同是否已创建分包施工图预算材料分析
        QueryWrapper<SubpackagematerialanalysisEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("dr", 0);
        queryWrapper1.eq("contract_id", contractId);
        if (id != null && id != 0) {
            queryWrapper1.ne("id", id);
        }
        List<SubpackagematerialanalysisEntity> entityList1 = service.list(queryWrapper1);
        if (entityList1 != null && entityList1.size() > 0) {
            return CommonResponse.success("该合同已经创建一个分包施工图预算材料分析，请选择其他合同!", "0");
        }
        QueryWrapper<MaterialrequirementsEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", "1","3");

        List<MaterialrequirementsEntity> entityList = materialrequirementsService.list(queryWrapper);

        if (entityList == null || entityList.size() == 0) {
            return CommonResponse.success("该合同所属项目未创建需求总计划，请选择其他合同!", "1");
        }

        return CommonResponse.success("查询成功！", "2");
    }
}
