package com.ejianc.business.bedget.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.MaterialrequirementsdetailEntity;
import com.ejianc.business.bedget.service.IMaterialrequirementsdetailService;
import com.ejianc.business.bedget.vo.MaterialrequirementsdetailVO;
import com.ejianc.business.utils.StringFormatUtil;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 物资需求总计划导入导出
 */
@Controller
@RequestMapping("materialrequirementsExport")
public class ExcelMaterialrequirementsController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialrequirementsdetailService materialrequirementsdetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadmaterialrequirements")
    @ResponseBody
    public void downloadMaterialrequirement(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "materialrequirementsdetail-import.xlsx", "物资需求总计划清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportmaterialrequirements", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterialrequirement(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MaterialrequirementsdetailVO> successList = new ArrayList<>();
        List<MaterialrequirementsdetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        HashMap<String, String> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 2; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    MaterialrequirementsdetailVO materialrequirementsdetailVO = new MaterialrequirementsdetailVO();
                    materialrequirementsdetailVO.setId(IdWorker.getId());
                    materialrequirementsdetailVO.setSort(String.valueOf(i - 1));
                    materialrequirementsdetailVO.setBillCode(datas.get(0));
                    materialrequirementsdetailVO.setName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 物资名称
                    materialrequirementsdetailVO.setSpec(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 物资规格
                    materialrequirementsdetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 计量单位
                    materialrequirementsdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(8)) ? datas.get(8) : null); // 备注

                    if (StringUtils.isEmpty(datas.get(0)) || datas.get(0) == null) {
                        materialrequirementsdetailVO.setErrorMsg("'物资编码'不能为空！");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }

                    if (StringUtils.isEmpty(datas.get(1)) || datas.get(1) == null) {
                        materialrequirementsdetailVO.setErrorMsg("'物资名称'不能为空！");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }
                    if (StringUtils.isEmpty(datas.get(4)) || datas.get(4) == null) {
                        materialrequirementsdetailVO.setErrorMsg("'基础'不能为空！");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }
                    if (StringUtils.isEmpty(datas.get(5)) || datas.get(5) == null) {
                        materialrequirementsdetailVO.setErrorMsg("'主体'不能为空！");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }
                    if (StringUtils.isEmpty(datas.get(6)) || datas.get(6) == null) {
                        materialrequirementsdetailVO.setErrorMsg("'装修'不能为空！");
                        errorList.add(materialrequirementsdetailVO);
                        continue;
                    }

                    //校验库中物资
                    CommonResponse<MaterialVO> back0 = shareMaterialApi.queryMaterialByCode(datas.get(0));
                    try {
                        if (back0.getCode() == 1 || back0.getData() == null) {
                            materialrequirementsdetailVO.setErrorMsg("未查询到该物资编码下的物资详情");
                            errorList.add(materialrequirementsdetailVO);
                        }
                        if (StringUtils.isNotBlank(back0.getData().getName())) {
                            if (!back0.getData().getName().equals(datas.get(1))) {
                                materialrequirementsdetailVO.setErrorMsg("'物资名称'未在库中,请检查！");
                                errorList.add(materialrequirementsdetailVO);
                                continue;
                            }
                        }

                        if (StringUtils.isNotBlank(back0.getData().getSpec())) {
                            if (!back0.getData().getSpec().equals(datas.get(2))) {
                                materialrequirementsdetailVO.setErrorMsg("'物资规格'未在库中,请检查！");
                                errorList.add(materialrequirementsdetailVO);
                                continue;
                            }
                        }

                        if (StringUtils.isNotBlank(back0.getData().getUnitName())) {
                            if (!back0.getData().getUnitName().equals(datas.get(3))) {
                                materialrequirementsdetailVO.setErrorMsg("'计量单位'未在库中,请检查！");
                                errorList.add(materialrequirementsdetailVO);
                                continue;
                            }
                        }

                        String data0 = map.get(datas.get(0));
                        if (map.get(data0) != null && StringUtils.isNotEmpty(data0) && data0.equals(datas.get(0))) {
                            materialrequirementsdetailVO.setErrorMsg("'物资编码'重复,请检查！");
                            errorList.add(materialrequirementsdetailVO);
                            continue;
                        }else{
                            map.put(datas.get(0),datas.get(0));
                        }
                        //物资名称三项是否重复
                        StringBuffer materConcat = new StringBuffer();
                        if(datas.get(2)!=null && StringUtils.isNotBlank(datas.get(2))){
                            materConcat.append(back0.getData().getName()).append(back0.getData().getSpec());
                        }
                        if(datas.get(3)!=null && StringUtils.isNotBlank(datas.get(3))){
                            materConcat.append(back0.getData().getUnitName());
                        }
                        if (map.containsKey(materConcat.toString())) {
                            materialrequirementsdetailVO.setErrorMsg("'物资名称','物资规格','计量单位不能重复'");
                            errorList.add(materialrequirementsdetailVO);
                            continue;
                        } else {
                            map.put(materConcat.toString(), materConcat.toString());
                        }

                        if (datas.get(4) != null && !StringFormatUtil.validateNumber(datas.get(4))) {
                            materialrequirementsdetailVO.setErrorMsg("'基础'输入格式错误！");
                            errorList.add(materialrequirementsdetailVO);
                            continue;
                        } else {
                            materialrequirementsdetailVO.setBase(StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) : null); // 基础
                        }

                        if (datas.get(5) != null && !StringFormatUtil.validateNumber(datas.get(5))) {
                            materialrequirementsdetailVO.setErrorMsg("'主体'输入格式错误！");
                            errorList.add(materialrequirementsdetailVO);
                            continue;
                        } else {
                            materialrequirementsdetailVO.setMain(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); // 主体
                        }

                        if (datas.get(6) != null && !StringFormatUtil.validateNumber(datas.get(6))) {
                            materialrequirementsdetailVO.setErrorMsg("'装修'输入格式错误！");
                            errorList.add(materialrequirementsdetailVO);
                            continue;
                        } else {
                            materialrequirementsdetailVO.setDecorate(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : null); // 装修
                        }

                        if(!TextUtils.isEmpty(datas.get(8)) && !StringFormatUtil.validateNumber(datas.get(8))){
                            materialrequirementsdetailVO.setErrorMsg("'其他数量'输入格式错误");
                            errorList.add(materialrequirementsdetailVO);
                            continue;
                        }else {
                            materialrequirementsdetailVO.setOtherNum(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : new BigDecimal(0)); // 其他数量
                        }

                        BigDecimal subCount = new BigDecimal(0);
                        if (datas.get(7) == null || StringUtils.isEmpty(datas.get(7))) {
                            //小计计算
                            subCount = new BigDecimal(datas.get(4)).add(new BigDecimal(datas.get(5))).add(new BigDecimal(datas.get(6)));
                            materialrequirementsdetailVO.setSubtotal(subCount);
                        } else {
                            subCount = new BigDecimal(datas.get(7));
                            materialrequirementsdetailVO.setSubtotal(new BigDecimal(datas.get(7)));
                        }

                        if (datas.get(9) == null || StringUtils.isEmpty(datas.get(9))) {
                            //合计计算
                            materialrequirementsdetailVO.setTotal(subCount.add(StringUtils.isBlank(datas.get(8))?new BigDecimal(0):new BigDecimal(datas.get(8))));
                        } else {
                            materialrequirementsdetailVO.setTotal(new BigDecimal(datas.get(9)));
                        }
                        successList.add(materialrequirementsdetailVO);
                    } catch (Exception e) {
                        e.printStackTrace();
                        logger.error(e.getMessage());
                    }

                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportmaterialrequirementsFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody MaterialrequirementsdetailVO materialrequirementsdetailVO, HttpServletResponse response) {
        QueryWrapper<MaterialrequirementsdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", String.valueOf(materialrequirementsdetailVO.getId()));
        queryWrapper.eq("dr", 0);
        List<MaterialrequirementsdetailEntity> list = materialrequirementsdetailService.list(queryWrapper);
        List<MaterialrequirementsdetailVO> mapList = BeanMapper.mapList(list, MaterialrequirementsdetailVO.class);
        Map<String, Object> beans = new HashMap<String, Object>();
        ArrayList<MaterialrequirementsdetailVO> materialrequirementsdetailVOArrayList = new ArrayList<>();
        if (mapList != null && mapList.size() > 0) {
            for (int i = 0; i < mapList.size(); i++) {
                MaterialrequirementsdetailVO vo = mapList.get(i);
                vo.setSort(String.valueOf(i + 1));
                materialrequirementsdetailVOArrayList.add(vo);
            }
        }
        beans.put("records", materialrequirementsdetailVOArrayList);
        ExcelExport.getInstance().export("materialrequirementsdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportmaterialrequirementsFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<MaterialrequirementsdetailVO> list, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        ArrayList<MaterialrequirementsdetailVO> materialrequirementsdetailVOArrayList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                MaterialrequirementsdetailVO materialrequirementsdetailVO = list.get(i);
                materialrequirementsdetailVO.setSort(String.valueOf(i + 1));
                materialrequirementsdetailVOArrayList.add(materialrequirementsdetailVO);
            }
        }
        beans.put("records", materialrequirementsdetailVOArrayList);
        ExcelExport.getInstance().export("materialrequirementsdetail-export.xlsx", beans, response);
    }
}
