package com.ejianc.business.change.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.*;
import com.ejianc.business.bedget.service.IMaterialanalysisService;
import com.ejianc.business.bedget.service.IMaterialrequirementsService;
import com.ejianc.business.bedget.service.IMaterialrequirementsdetailService;
import com.ejianc.business.change.bean.ChangematerialanalysisEntity;
import com.ejianc.business.change.bean.ChangematerialanalysisdetailEntity;
import com.ejianc.business.change.service.IChangematerialanalysisService;
import com.ejianc.business.change.vo.ChangeconsdrawbudgettotalVO;
import com.ejianc.business.change.vo.ChangeconsdrawbudgettotaldetailVO;
import com.ejianc.business.change.vo.ChangematerialanalysisVO;
import com.ejianc.business.change.vo.ChangematerialanalysisdetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;



/**
 * 施工图预算材料分析变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("changematerialanalysis")
public class ChangematerialanalysisController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialanalysisService materialanalysisService;

    private static final String BILL_CODE = "budgetmanager-changematerialanalysis";//此处需要根据实际修改

    @Autowired
    private IChangematerialanalysisService service;
    @Autowired
    private IMaterialrequirementsService materialrequirementsService;//需求总计划service
    @Autowired
    private IMaterialrequirementsdetailService materialrequirementsdetailService;//需求总计划明细service

    /**
     * 初始化更详情页面
     *
     * @param id
     * @return
     */
    @GetMapping(value = "queryDetailByMaterialanalysisId")
    @ResponseBody
    public CommonResponse<ChangematerialanalysisVO> queryDetailByMaterialanalysisId(@RequestParam(value = "materialanalysisId") Long materialanalysisId) {
        MaterialanalysisEntity consdrawbudgettotalEntity = materialanalysisService.selectById(materialanalysisId);
        ChangematerialanalysisVO changeVO = BeanMapper.map(consdrawbudgettotalEntity, ChangematerialanalysisVO.class);
        Long id = IdWorker.getId();
        changeVO.setOriginalId(materialanalysisId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setId(id);

        //限额设计指标分析清单
        List<ChangematerialanalysisdetailVO> changematerialanalysisdetailEntities = changeVO.getMaterialanalysisdetailEntities();
        if(changematerialanalysisdetailEntities!=null&&changematerialanalysisdetailEntities.size()>0){
            List<ChangematerialanalysisVO> changematerialanalysisVOS = new ArrayList<>();
            for(ChangematerialanalysisdetailVO entity : changematerialanalysisdetailEntities){
                ChangematerialanalysisVO vo = BeanMapper.map(entity, ChangematerialanalysisVO.class);
                vo.setOriginalId(materialanalysisId);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setRowState("edit");
                vo.setId(IdWorker.getId());
                changematerialanalysisVOS.add(vo);
            }
            changeVO.setMaterialanalysisdetailEntities(changematerialanalysisdetailEntities);
        }

        return CommonResponse.success("查询详情成功！", changeVO);

    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveChange", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangematerialanalysisVO> saveChange(@RequestBody ChangematerialanalysisVO saveOrUpdateVO) {
        /**
         * 获取当前单据项目id
         * 查询项目对于物资需求总计划
         */

        ChangematerialanalysisEntity entity = BeanMapper.map(saveOrUpdateVO, ChangematerialanalysisEntity.class);
        HashMap<String, BigDecimal> fbMap = new HashMap<>();
        HashMap<String, BigDecimal> xqMap = new HashMap<>();
        //获取主表项目
        Long projectId = entity.getProjectId();
        //查找该项目的物资需求总计划
        QueryWrapper<MaterialrequirementsEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("project_id", projectId);
        queryWrapper1.eq("dr", "0");
        queryWrapper1.in("bill_state", "1", "3");
        List<MaterialrequirementsEntity> materialrequirementsEntityList = materialrequirementsService.list(queryWrapper1);
        if (materialrequirementsEntityList.size() > 0) {
            MaterialrequirementsEntity materialrequirementsEntity = materialrequirementsEntityList.get(0);
            //主表id
            Long mid = materialrequirementsEntity.getId();
            QueryWrapper<MaterialrequirementsdetailEntity> queryWrappers = new QueryWrapper<>();
            queryWrappers.eq("dr", "0");
            queryWrappers.eq("mid", mid);
            List<MaterialrequirementsdetailEntity> materialrequirementsdetailEntityList = materialrequirementsdetailService.list(queryWrappers);
            //物资需求总计划明细
            for (MaterialrequirementsdetailEntity materialrequirementsdetailEntity : materialrequirementsdetailEntityList) {
                String s = materialrequirementsdetailEntity.getBillCode() + materialrequirementsdetailEntity.getName() + materialrequirementsdetailEntity.getSpec() + materialrequirementsdetailEntity.getMeasuringUnit();
                BigDecimal sl = materialrequirementsdetailEntity.getTotal();
                xqMap.put(s, sl);
            }
            List<ChangematerialanalysisdetailEntity> subpackagematerialanalysisdetailEntitiesList = entity.getMaterialanalysisdetailEntities();
            //遍历子表数据
            for (ChangematerialanalysisdetailEntity subpackagematerialanalysisdetailEntity : subpackagematerialanalysisdetailEntitiesList) {
                String rowState = subpackagematerialanalysisdetailEntity.getRowState();
                if (!"del".equals(rowState)) {
                    //获取编码，名称 ，规格，单位拼接
                    String s = subpackagematerialanalysisdetailEntity.getMaterialsCode() + subpackagematerialanalysisdetailEntity.getMaterialsName() + subpackagematerialanalysisdetailEntity.getSpec() + subpackagematerialanalysisdetailEntity.getMeasuringUnit();
                    BigDecimal sl = subpackagematerialanalysisdetailEntity.getSubtotal();
                    fbMap.put(s, sl);
                }
            }
            for (String s : fbMap.keySet()) {
                BigDecimal bigDecimal = xqMap.get(s);
                if (bigDecimal==null){
                    throw new BusinessException(s+"需求总计划数量不足，请检查！当前可用数量：0");
                } else {
                    BigDecimal bigDecimal1 = fbMap.get(s);
                    if (bigDecimal.compareTo(bigDecimal1)==-1){
                        throw new BusinessException(s+"需求总计划数量不足，请检查！当前可用数量："+bigDecimal.setScale(2));
                    }
                }
            }
        }
        return service.saveChange(saveOrUpdateVO);
    }



    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ChangematerialanalysisVO> saveOrUpdate(@RequestBody ChangematerialanalysisVO saveorUpdateVO) {
    	ChangematerialanalysisEntity entity = BeanMapper.map(saveorUpdateVO, ChangematerialanalysisEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	ChangematerialanalysisVO vo = BeanMapper.map(entity, ChangematerialanalysisVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ChangematerialanalysisVO> queryDetail(Long id) {
    	ChangematerialanalysisEntity entity = service.selectById(id);
    	ChangematerialanalysisVO vo = BeanMapper.map(entity, ChangematerialanalysisVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangematerialanalysisVO> vos) {
        service.delete(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ChangematerialanalysisVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ChangematerialanalysisEntity> page = service.queryPage(param,false);
        IPage<ChangematerialanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangematerialanalysisVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ChangematerialanalysisEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Changematerialanalysis-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refChangematerialanalysisData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ChangematerialanalysisVO>> refChangematerialanalysisData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        //param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ChangematerialanalysisEntity> page = service.queryPage(param,false);
        IPage<ChangematerialanalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ChangematerialanalysisVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
