package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgetdetailEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotalEntity;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotaldetailEntity;
import com.ejianc.business.bedget.service.IConsdrawbudgettotalService;
import com.ejianc.business.change.bean.ChangeconsdrawbudgetdetailEntity;
import com.ejianc.business.change.bean.ChangeconsdrawbudgettotalEntity;
import com.ejianc.business.change.bean.ChangeconsdrawbudgettotaldetailEntity;
import com.ejianc.business.change.service.IChangeconsdrawbudgettotalService;
import com.ejianc.business.record.bean.RecordconsdrawbudgettotalEntity;
import com.ejianc.business.record.bean.RecordconsdrawbudgettotaldetailEntity;
import com.ejianc.business.record.service.IRecordconsdrawbudgettotalService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changeconsdrawbudgettotal") 
public class ChangeconsdrawbudgettotalBpmServiceImpl implements ICommonBusinessService {
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}



	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}


	private Logger logger = LoggerFactory.getLogger(this.getClass());
	//业务类型
	private static final String Consdrawbudgettotal = "zjkj-consdrawbudgettotal";//施工图预算汇总
	private static final String Consdrawbudgettotal_CHANGE = "zjkj-consdrawbudgettotalChange";//施工图预算汇总变更
	private static final String Consdrawbudgettotal_RECORD = "zjkj-consdrawbudgettotalRecord";//施工图预算汇总变更记录

	//单据类型
	private static final String Consdrawbudgettotal_BILLTYPE_CODE = "BT202202000033";//施工图预算汇总
	private static final String Consdrawbudgettotal_CHANGE_BILLTYPE_CODE = "BT202202000034";//施工图预算汇总变更
	private static final String Consdrawbudgettotal_RECORD_BILLTYPE_CODE = "BT202202000035";//施工图预算汇总变更记录


	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangeconsdrawbudgettotalService changeconsdrawbudgettotalService;
	@Autowired
	private IRecordconsdrawbudgettotalService recordconsdrawbudgettotalService;
	@Autowired
	private IConsdrawbudgettotalService  consdrawbudgettotalService;


	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		logger.info("---------进来啦--------");
		//TODO
		//1、获取目前单据信息、变更信息
		ChangeconsdrawbudgettotalEntity changeEntity = changeconsdrawbudgettotalService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getOriginalId());
		ConsdrawbudgettotalEntity consdrawbudgettotalEntity = consdrawbudgettotalService.selectById(changeEntity.getOriginalId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordconsdrawbudgettotalEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("consdrawbudgettotal_id", consdrawbudgettotalEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordconsdrawbudgettotalService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordconsdrawbudgettotalEntity recordconsdrawbudgettotalEntity = BeanMapper.map(consdrawbudgettotalEntity, RecordconsdrawbudgettotalEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordconsdrawbudgettotalEntity);
		recordconsdrawbudgettotalEntity.setBillState(null);
		recordconsdrawbudgettotalEntity.setConsdrawbudgettotalId(consdrawbudgettotalEntity.getId());
		recordconsdrawbudgettotalEntity.setConsdrawbudgettotalCode(consdrawbudgettotalEntity.getBillCode()+"-"+(count+1));
		recordconsdrawbudgettotalEntity.setId(recordId);
		recordconsdrawbudgettotalEntity.setBillCode(consdrawbudgettotalEntity.getBillCode());
		recordconsdrawbudgettotalEntity.setChangeReason(changeEntity.getChangeReason());
		recordconsdrawbudgettotalEntity.setEffectDate(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<ConsdrawbudgettotaldetailEntity> quotaanalysisdetailEntities = consdrawbudgettotalEntity.getConsdrawbudgettotaldetailEntities();
		if(quotaanalysisdetailEntities!=null&&quotaanalysisdetailEntities.size()>0){
			List<RecordconsdrawbudgettotaldetailEntity> recorddesignestimatedetailEntities = new ArrayList<>();
			for(ConsdrawbudgettotaldetailEntity entity : quotaanalysisdetailEntities){
				RecordconsdrawbudgettotaldetailEntity reEntity = BeanMapper.map(entity, RecordconsdrawbudgettotaldetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setRecordMid(recordId);
				reEntity.setId(null);
				recorddesignestimatedetailEntities.add(reEntity);
			}
			recordconsdrawbudgettotalEntity.setConsdrawbudgettotaldetailEntities(recorddesignestimatedetailEntities);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		sourceBillType = Consdrawbudgettotal_BILLTYPE_CODE;
		String targetBillType = "";
		targetBillType = Consdrawbudgettotal_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(consdrawbudgettotalEntity.getId().toString(), sourceBillType, Consdrawbudgettotal , recordId.toString(), targetBillType, Consdrawbudgettotal_RECORD);
		recordconsdrawbudgettotalService.saveOrUpdate(recordconsdrawbudgettotalEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + recordconsdrawbudgettotalEntity.getCreateUserCode());
		//3、修改当前单据状态
		ConsdrawbudgettotalEntity consdrawbudgettotalEntity1 = BeanMapper.map(changeEntity, ConsdrawbudgettotalEntity.class);
		consdrawbudgettotalEntity1.setChangeState("3");//状态改为已变更
		consdrawbudgettotalEntity1.setChangeId(null);
		consdrawbudgettotalEntity1.setBillState(consdrawbudgettotalEntity.getBillState());
		consdrawbudgettotalEntity1.setId(consdrawbudgettotalEntity.getId());
		consdrawbudgettotalEntity1.setCreateTime(consdrawbudgettotalEntity.getCreateTime());
		consdrawbudgettotalEntity1.setCreateUserCode(consdrawbudgettotalEntity.getCreateUserCode());
		consdrawbudgettotalEntity1.setTenantId(consdrawbudgettotalEntity.getTenantId());
		consdrawbudgettotalEntity1.setVersion(consdrawbudgettotalEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangeconsdrawbudgettotaldetailEntity> changequotadesigndetailList = changeEntity.getConsdrawbudgettotaldetailEntities();
		if(changequotadesigndetailList!=null&&changequotadesigndetailList.size()>0){
			List<ConsdrawbudgettotaldetailEntity> newQuotadesigndetailList = BeanMapper.mapList(changequotadesigndetailList, ConsdrawbudgettotaldetailEntity.class);
			//原单据子表的基础信息不变
			if(quotaanalysisdetailEntities != null && quotaanalysisdetailEntities.size() > 0){
				ConsdrawbudgettotaldetailEntity originalQuotadesigndetailInfo = quotaanalysisdetailEntities.get(0);

				for (int i = 0; i < changequotadesigndetailList.size(); i++) {
					ChangeconsdrawbudgettotaldetailEntity changeQuotadesigndetail = changequotadesigndetailList.get(i);
					ConsdrawbudgettotaldetailEntity newQuotadesigndetail = newQuotadesigndetailList.get(i);

					boolean isChangeUpdate = false;//true 变更更新数据 false 变更新增数据
					for (int j = 0; j < quotaanalysisdetailEntities.size(); j++) {
						ConsdrawbudgettotaldetailEntity originalQuotadesigndetail = quotaanalysisdetailEntities.get(j);
						if(originalQuotadesigndetail.getId().equals(changeQuotadesigndetail.getOriginalId())){

							newQuotadesigndetail.setId(originalQuotadesigndetail.getId());
							newQuotadesigndetail.setCreateTime(originalQuotadesigndetailInfo.getCreateTime());
							newQuotadesigndetail.setCreateUserCode(originalQuotadesigndetailInfo.getCreateUserCode());

							newQuotadesigndetail.setUpdateTime(changeQuotadesigndetail.getUpdateTime());
							newQuotadesigndetail.setUpdateUserCode(changeQuotadesigndetail.getCreateUserCode());

							isChangeUpdate = true;
							break;
						}
					}

					if(!isChangeUpdate){//变更新增
						newQuotadesigndetail.setCreateTime(changeQuotadesigndetail.getUpdateTime());
						newQuotadesigndetail.setCreateUserCode(changeQuotadesigndetail.getCreateUserCode());
					}

					newQuotadesigndetail.setBillState(originalQuotadesigndetailInfo.getBillState());
					newQuotadesigndetail.setTenantId(originalQuotadesigndetailInfo.getTenantId());
					newQuotadesigndetail.setVersion(originalQuotadesigndetailInfo.getVersion());
				}
			}
			//原始单与变更单对比后（新增）
			consdrawbudgettotalEntity1.setConsdrawbudgettotaldetailEntities(newQuotadesigndetailList);

			//原始单与变更单对比后（删除）
			List<ConsdrawbudgettotaldetailEntity> deleteDatas = new ArrayList<>();
			for (int i = 0; i < quotaanalysisdetailEntities.size(); i++) {
				ConsdrawbudgettotaldetailEntity quotadesigndetail = quotaanalysisdetailEntities.get(i);
				boolean isSame = false;
				for (int j = 0; j < newQuotadesigndetailList.size(); j++) {
					ConsdrawbudgettotaldetailEntity newDetail = newQuotadesigndetailList.get(j);
					if(quotadesigndetail.getId().equals(newDetail.getId())) {
						isSame = true;
					}
				}
				if(!isSame){//变更已删除行
					quotadesigndetail.setRowState("del");
					deleteDatas.add(quotadesigndetail);
				}
			}

			if(deleteDatas.size() > 0){
				newQuotadesigndetailList.addAll(deleteDatas);
				consdrawbudgettotalEntity1.setConsdrawbudgettotaldetailEntities(newQuotadesigndetailList);
			}
			consdrawbudgettotalEntity1.setConsdrawbudgettotaldetailEntities(newQuotadesigndetailList);
		}
		logger.info("---------保存--------");
		consdrawbudgettotalService.saveOrUpdate(consdrawbudgettotalEntity1, false);

		sourceBillType = Consdrawbudgettotal_CHANGE_BILLTYPE_CODE;
		targetBillType = Consdrawbudgettotal_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Consdrawbudgettotal_CHANGE, consdrawbudgettotalEntity.getId().toString(), targetBillType, Consdrawbudgettotal);
		recordconsdrawbudgettotalService.saveOrUpdate(recordconsdrawbudgettotalEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}
	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
