package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.MaterialrequirementsEntity;
import com.ejianc.business.bedget.bean.MaterialrequirementsdetailEntity;
import com.ejianc.business.bedget.bean.QuotaanalysisEntity;
import com.ejianc.business.bedget.bean.QuotaanalysisdetailEntity;
import com.ejianc.business.bedget.service.IMaterialrequirementsService;
import com.ejianc.business.change.bean.ChangeQuotaanalysisEntity;
import com.ejianc.business.change.bean.ChangeQuotaanalysisdetailEntity;
import com.ejianc.business.change.bean.ChangematerialrequirementsEntity;
import com.ejianc.business.change.bean.ChangematerialrequirementsdetailEntity;
import com.ejianc.business.change.service.IChangematerialrequirementsService;
import com.ejianc.business.record.bean.RecodematerialrequirementsEntity;
import com.ejianc.business.record.bean.RecodematerialrequirementsdetailEntity;
import com.ejianc.business.record.bean.RecordQuotaanalysisEntity;
import com.ejianc.business.record.bean.RecordQuotaanalysisdetailEntity;
import com.ejianc.business.record.service.IRecodematerialrequirementsService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changematerialrequirements") 
public class ChangematerialrequirementsBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Materialrequirements = "zjkj-materialrequirements";//物资需求总计划
	private static final String Materialrequirements_CHANGE = "zjkj-materialrequirementsChange";//物资需求总计划变更
	private static final String Materialrequirements_RECORD = "zjkj-materialrequirementsRecord";//物资需求总计划变更记录

	//单据类型
	private static final String Materialrequirements_BILLTYPE_CODE = "BT202203000004";//物资需求总计划
	private static final String Materialrequirements_CHANGE_BILLTYPE_CODE = "BT202203000006";//物资需求总计划变更
	private static final String Materialrequirements_RECORD_BILLTYPE_CODE = "BT202203000008";//物资需求总计划变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangematerialrequirementsService changematerialrequirementsService;
	@Autowired
	private IMaterialrequirementsService materialrequirementsService;
	@Autowired
	private IRecodematerialrequirementsService recodematerialrequirementsService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("---------进来啦--------");
		//TODO
		//1、获取目前单据信息、变更信息
		ChangematerialrequirementsEntity changeEntity = changematerialrequirementsService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getOriginalId());
		MaterialrequirementsEntity materialrequirementsEntity = materialrequirementsService.selectById(changeEntity.getOriginalId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecodematerialrequirementsEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("original_id", materialrequirementsEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recodematerialrequirementsService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecodematerialrequirementsEntity recodematerialrequirementsEntity = BeanMapper.map(materialrequirementsEntity, RecodematerialrequirementsEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recodematerialrequirementsEntity);
		recodematerialrequirementsEntity.setBillState(null);
		recodematerialrequirementsEntity.setOriginalId(materialrequirementsEntity.getId());
		recodematerialrequirementsEntity.setMaterialrequirementsCode(materialrequirementsEntity.getBillCode()+"-"+(count+1));
		recodematerialrequirementsEntity.setId(recordId);
		recodematerialrequirementsEntity.setBillCode(materialrequirementsEntity.getBillCode());
		recodematerialrequirementsEntity.setChangeReason(changeEntity.getChangeReason());
		recodematerialrequirementsEntity.setEffectDate(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<MaterialrequirementsdetailEntity> materialrequirementsdetailEntity = materialrequirementsEntity.getMaterialrequirementsdetailEntities();
		if(materialrequirementsdetailEntity!=null&&materialrequirementsdetailEntity.size()>0){
			List<RecodematerialrequirementsdetailEntity> recodematerialrequirementsdetailEntity = new ArrayList<>();
			for(MaterialrequirementsdetailEntity entity : materialrequirementsdetailEntity){
				RecodematerialrequirementsdetailEntity reEntity = BeanMapper.map(entity, RecodematerialrequirementsdetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setOriginalId(recordId);
				reEntity.setId(null);
				recodematerialrequirementsdetailEntity.add(reEntity);
				entity.setRowState("del");
			}
			recodematerialrequirementsEntity.setMaterialrequirementsdetailEntities(recodematerialrequirementsdetailEntity);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Materialrequirements_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Materialrequirements_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(materialrequirementsEntity.getId().toString(), sourceBillType, Materialrequirements , recordId.toString(), targetBillType, Materialrequirements_RECORD);
		recodematerialrequirementsService.saveOrUpdate(recodematerialrequirementsEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + materialrequirementsEntity.getCreateUserCode());
		//3、修改当前单据状态
		MaterialrequirementsEntity newMaterialrequirementsEntity = BeanMapper.map(changeEntity, MaterialrequirementsEntity.class);
		newMaterialrequirementsEntity.setChangeState("3");//状态改为已变更
		newMaterialrequirementsEntity.setChangeId(null);
		newMaterialrequirementsEntity.setBillState(materialrequirementsEntity.getBillState());
		newMaterialrequirementsEntity.setId(materialrequirementsEntity.getId());
		newMaterialrequirementsEntity.setCreateTime(materialrequirementsEntity.getCreateTime());
		newMaterialrequirementsEntity.setCreateUserCode(materialrequirementsEntity.getCreateUserCode());
		newMaterialrequirementsEntity.setTenantId(materialrequirementsEntity.getTenantId());
		newMaterialrequirementsEntity.setVersion(materialrequirementsEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangematerialrequirementsdetailEntity> changematerialrequirementsdetailList = changeEntity.getMaterialrequirementsdetailEntities();
		if(changematerialrequirementsdetailList!=null&&changematerialrequirementsdetailList.size()>0){
			List<MaterialrequirementsdetailEntity> newQuotaanalysisdetailList = BeanMapper.mapList(changematerialrequirementsdetailList, MaterialrequirementsdetailEntity.class);
			newQuotaanalysisdetailList.addAll(materialrequirementsdetailEntity);
			newMaterialrequirementsEntity.setMaterialrequirementsdetailEntities(newQuotaanalysisdetailList);
		}
		logger.info("---------保存--------");
		materialrequirementsService.saveOrUpdate(newMaterialrequirementsEntity, false);

		sourceBillType = Materialrequirements_CHANGE_BILLTYPE_CODE;
		targetBillType = Materialrequirements_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Materialrequirements_CHANGE, materialrequirementsEntity.getId().toString(), targetBillType, Materialrequirements);
		recodematerialrequirementsService.saveOrUpdate(recodematerialrequirementsEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
