package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.QuotasummaryEntity;
import com.ejianc.business.bedget.bean.QuotasummarydetailEntity;
import com.ejianc.business.bedget.service.IQuotasummaryService;
import com.ejianc.business.change.bean.ChangequotasummaryEntity;
import com.ejianc.business.change.bean.ChangequotasummarydetaillEntity;
import com.ejianc.business.change.service.IChangequotasummaryService;
import com.ejianc.business.record.bean.RecordquotasummaryEntity;
import com.ejianc.business.record.bean.RecordquotasummarydetaillEntity;
import com.ejianc.business.record.service.IRecordquotasummaryService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changequotasummary") 
public class ChangequotasummaryBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Quotasummary = "zjkj-quotasummary";//限额设计指标分析
	private static final String Quotasummary_CHANGE = "zjkj-quotasummaryChange";//限额设计指标分析变更
	private static final String Quotasummary_RECORD = "zjkj-quotasummaryRecord";//限额设计指标分析变更记录

	//单据类型
	private static final String Quotasummary_BILLTYPE_CODE = "BT202202000024";//限额设计指标分析
	private static final String Quotasummary_CHANGE_BILLTYPE_CODE = "BT202202000025";//限额设计指标分析变更
	private static final String Quotasummary_RECORD_BILLTYPE_CODE = "BT202202000026";//限额设计指标分析变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangequotasummaryService changequotasummaryService;
	@Autowired
	private IQuotasummaryService quotasummaryService;
	@Autowired
	private IRecordquotasummaryService recordquotasummaryService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前单据信息、变更信息
		ChangequotasummaryEntity changeEntity = changequotasummaryService.selectById(billId);
		QuotasummaryEntity quotasummaryEntity = quotasummaryService.selectById(changeEntity.getOriginalId());

		//获取历史版本条数
		QueryWrapper<RecordquotasummaryEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("original_id", quotasummaryEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordquotasummaryService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordquotasummaryEntity recordquotasummaryEntity = BeanMapper.map(quotasummaryEntity, RecordquotasummaryEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordquotasummaryEntity);
		recordquotasummaryEntity.setBillState(null);
		recordquotasummaryEntity.setQuotasummaryId(quotasummaryEntity.getId());
		recordquotasummaryEntity.setQuotasummaryCode(quotasummaryEntity.getBillCode()+"-"+(count+1));
		recordquotasummaryEntity.setId(recordId);
		recordquotasummaryEntity.setBillCode(quotasummaryEntity.getBillCode());
		recordquotasummaryEntity.setChangeReason(changeEntity.getChangeReason());
		recordquotasummaryEntity.setEffectDate(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<QuotasummarydetailEntity> quotasummarydetailEntities = quotasummaryEntity.getQuotasummarydetailEntities();
		if(quotasummarydetailEntities!=null&&quotasummarydetailEntities.size()>0){
			List<RecordquotasummarydetaillEntity> recordquotasummarydetaillEntities = new ArrayList<>();
			for(QuotasummarydetailEntity entity : quotasummarydetailEntities){
				RecordquotasummarydetaillEntity reEntity = BeanMapper.map(entity, RecordquotasummarydetaillEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setRecordMid(recordId);
				reEntity.setId(null);
				recordquotasummarydetaillEntities.add(reEntity);
				entity.setRowState("del");
			}
			recordquotasummaryEntity.setQuotasummarydetailEntities(recordquotasummarydetaillEntities);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Quotasummary_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Quotasummary_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(quotasummaryEntity.getId().toString(), sourceBillType, Quotasummary , recordId.toString(), targetBillType, Quotasummary_RECORD);
		recordquotasummaryService.saveOrUpdate(recordquotasummaryEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + quotasummaryEntity.getCreateUserCode());
		//3、修改当前单据状态
		QuotasummaryEntity newQuotasummaryEntity = BeanMapper.map(changeEntity, QuotasummaryEntity.class);
		newQuotasummaryEntity.setChangeState("3");//状态改为已变更
		newQuotasummaryEntity.setChangeId(null);
		newQuotasummaryEntity.setBillState(quotasummaryEntity.getBillState());
		newQuotasummaryEntity.setId(quotasummaryEntity.getId());
		newQuotasummaryEntity.setCreateTime(quotasummaryEntity.getCreateTime());
		newQuotasummaryEntity.setCreateUserCode(quotasummaryEntity.getCreateUserCode());
		newQuotasummaryEntity.setTenantId(quotasummaryEntity.getTenantId());
		newQuotasummaryEntity.setVersion(quotasummaryEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangequotasummarydetaillEntity> changequotasummarydetaillEntityList = changeEntity.getQuotasummarydetailEntities();
		if(changequotasummarydetaillEntityList!=null&&changequotasummarydetaillEntityList.size()>0){
			List<QuotasummarydetailEntity> newQuotasummarydetailEntityList = BeanMapper.mapList(changequotasummarydetaillEntityList, QuotasummarydetailEntity.class);
			newQuotasummarydetailEntityList.addAll(quotasummarydetailEntities);
			newQuotasummaryEntity.setQuotasummarydetailEntities(newQuotasummarydetailEntityList);
		}
		logger.info("---------保存--------");
		quotasummaryService.saveOrUpdate(newQuotasummaryEntity, false);

		sourceBillType = Quotasummary_CHANGE_BILLTYPE_CODE;
		targetBillType = Quotasummary_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Quotasummary_CHANGE, quotasummaryEntity.getId().toString(), targetBillType, Quotasummary);
		recordquotasummaryService.saveOrUpdate(recordquotasummaryEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
