package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bedget.bean.ConsdrawbudgettotalEntity;
import com.ejianc.business.bedget.bean.QuotadesignEntity;
import com.ejianc.business.bedget.bean.SubpackagematerialanalysisEntity;
import com.ejianc.business.bedget.service.ISubpackagematerialanalysisService;
import com.ejianc.business.change.bean.ChangeconsdrawbudgettotalEntity;
import com.ejianc.business.change.bean.ChangequotadesignEntity;
import com.ejianc.business.change.bean.ChangesubpachagematerialanalysisEntity;
import com.ejianc.business.change.mapper.ChangesubpachagematerialanalysisMapper;
import com.ejianc.business.change.service.IChangesubpachagematerialanalysisService;
import com.ejianc.business.change.vo.ChangeconsdrawbudgettotalVO;
import com.ejianc.business.change.vo.ChangequotadesignVO;
import com.ejianc.business.change.vo.ChangesubpachagematerialanalysisVO;
import com.ejianc.business.record.bean.RecordquotadesignEntity;
import com.ejianc.business.record.bean.RecordsubpackagematerialanalysisEntity;
import com.ejianc.business.record.service.IRecordsubpackagematerialanalysisService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;
import java.util.stream.Collectors;


/**
 * 分包施工图预算材料分析变更
 * 
 * @author generator
 * 
 */
@Service("changesubpachagematerialanalysisService")
public class ChangesubpachagematerialanalysisServiceImpl extends BaseServiceImpl<ChangesubpachagematerialanalysisMapper, ChangesubpachagematerialanalysisEntity> implements IChangesubpachagematerialanalysisService {
    @Autowired
    private ISubpackagematerialanalysisService subpackagematerialanalysisService;
    @Autowired
    private IRecordsubpackagematerialanalysisService recordsubpackagematerialanalysisService;
    @Override
    public CommonResponse<ChangesubpachagematerialanalysisVO> saveChange(ChangesubpachagematerialanalysisVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangesubpachagematerialanalysisEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangesubpachagematerialanalysisEntity entity = BeanMapper.map(saveOrUpdateVO, ChangesubpachagematerialanalysisEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangesubpachagematerialanalysisEntity> queryWrapper = new QueryWrapper<ChangesubpachagematerialanalysisEntity>();
        queryWrapper.eq("original_id", saveOrUpdateVO.getOriginalId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "[0,4]");
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangesubpachagematerialanalysisEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //设计概算指标分析子表
        this.saveOrUpdate(entity, false);

        ChangesubpachagematerialanalysisVO vo = BeanMapper.map(entity, ChangesubpachagematerialanalysisVO.class);

        vo.setSubpackagematerialanalysisdetailEntities(saveOrUpdateVO.getSubpackagematerialanalysisdetailEntities());
        vo.setRecordsubpackagematerialanalysisVOS(saveOrUpdateVO.getRecordsubpackagematerialanalysisVOS());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            SubpackagematerialanalysisEntity consdrawbudgettotalEntity = subpackagematerialanalysisService.selectById(vo.getOriginalId());
            consdrawbudgettotalEntity.setChangeState("2");//状态改为变更中
            consdrawbudgettotalEntity.setChangeId(vo.getId());
            subpackagematerialanalysisService.saveOrUpdate(consdrawbudgettotalEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @Override
    public CommonResponse<String> delete(List<ChangesubpachagematerialanalysisVO> vos) {
        for(ChangesubpachagematerialanalysisVO vo : vos){
            ChangesubpachagematerialanalysisEntity entity = this.getById(vo.getId());
            SubpackagematerialanalysisEntity subpackagematerialanalysisEntity = subpackagematerialanalysisService.selectById(entity.getOriginalId());
            QueryWrapper<RecordsubpackagematerialanalysisEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", subpackagematerialanalysisEntity.getId());
            List<RecordsubpackagematerialanalysisEntity> records = recordsubpackagematerialanalysisService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                subpackagematerialanalysisEntity.setChangeState("3");//状态改为已变更
            }else{
                subpackagematerialanalysisEntity.setChangeState("1");//状态改为未变更
            }
            subpackagematerialanalysisEntity.setChangeId(null);
            subpackagematerialanalysisService.saveOrUpdate(subpackagematerialanalysisEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangesubpachagematerialanalysisVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
